/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtils {
    public static final String BACK_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String DOUBLE_BACK_SLASH = "\\\\";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String DOT = ".";
    public static final String EMPTY_STRING = "";
    public static final String CRLF = "\r\n";
    public static final String CRLFCRLF = "\r\n\r\n";
    public static final String SPACE = " ";
    public static final String QUOTE = "\"";
    public static final String EQUAL = "=";
    public static final String UNDERSCORE = "_";
    public static final String NEW_LINE_PATTERN = "(?:\r\n|\n|\r)";
    private static final String LEFT_WHITESPACE = "^\\s+";
    private static final String RIGHT_WHITESPACE = "\\s+$";
    private static final char MNEMONIC_CHAR = '&';
    private static final String MNEMONIC = "&";
    private static final char NO_MNEMONIC = '\u0000';
    private static final char[] BASE64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] BASE64_REVERSE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final char BASE64_PAD = '=';
    private static final int BIN_11111111 = 255;
    private static final int BIN_00110000 = 48;
    private static final int BIN_00111100 = 60;
    private static final int BIN_00111111 = 63;
    public static final String ERROR_CANNOT_PARSE_STATUS = "StrU.error.cannot.parse.status";
    public static final String ERROR_UNKNOWN_PLATFORM = "StrU.error.unknown.platform";

    public static String format(String message, Object ... arguments) {
        return MessageFormat.format(message, arguments);
    }

    public static String leftTrim(String string) {
        return string.replaceFirst(LEFT_WHITESPACE, EMPTY_STRING);
    }

    public static String rightTrim(String string) {
        return string.replaceFirst(RIGHT_WHITESPACE, EMPTY_STRING);
    }

    public static char fetchMnemonic(String string) {
        int i = StringUtils.findMnemonicAmpersand(string);
        return i >= 0 ? string.charAt(i + 1) : (char)'\u0000';
    }

    public static String stripMnemonic(String string) {
        int i = StringUtils.findMnemonicAmpersand(string);
        String s = string;
        if (i >= 0) {
            s = string.startsWith("<html>") ? string.substring(0, i) + "<u>" + string.charAt(i + 1) + "</u>" + string.substring(i + 2) : string.substring(0, i) + string.substring(i + 1);
        }
        return s;
    }

    public static int findMnemonicAmpersand(String text) {
        int i = -1;
        boolean isHTML = text.startsWith("<html>");
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length()) continue;
            if (isHTML) {
                boolean startsEntity = false;
                for (int j = i + 1; j < text.length(); ++j) {
                    char c = text.charAt(j);
                    if (c == ';') {
                        startsEntity = true;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c)) break;
                }
                if (startsEntity) continue;
                return i;
            }
            if (text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }

    public static String capitalizeFirst(String string) {
        return EMPTY_STRING + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String getGetterName(String propertyName) {
        return "get" + StringUtils.capitalizeFirst(propertyName);
    }

    public static String getBooleanGetterName(String propertyName) {
        return "is" + StringUtils.capitalizeFirst(propertyName);
    }

    public static String getSetterName(String propertyName) {
        return "set" + StringUtils.capitalizeFirst(propertyName);
    }

    public static String getFilenameFromUrl(String string) {
        String url = string.trim();
        int index = Math.max(url.lastIndexOf(FORWARD_SLASH), url.lastIndexOf(BACK_SLASH));
        int length = url.length();
        return index > 0 && index < length - 1 ? url.substring(index + 1, length) : null;
    }

    public static String formatSize(long longBytes) {
        StringBuffer result = new StringBuffer();
        double bytes = longBytes;
        double gigabytes = bytes / 1024.0 / 1024.0 / 1024.0;
        if (gigabytes > 1.0) {
            return String.format("%.1f GB", gigabytes);
        }
        double megabytes = bytes / 1024.0 / 1024.0;
        if (megabytes > 1.0) {
            return String.format("%.1f MB", megabytes);
        }
        double kilobytes = bytes / 1024.0;
        if (kilobytes > 0.5) {
            return String.format("%.1f KB", kilobytes);
        }
        return EMPTY_STRING + longBytes + " B";
    }

    public static String asHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            String byteHex = Integer.toHexString(b);
            if (byteHex.length() == 1) {
                byteHex = "0" + byteHex;
            }
            if (byteHex.length() > 2) {
                byteHex = byteHex.substring(byteHex.length() - 2);
            }
            builder.append(byteHex);
        }
        return builder.toString();
    }

    public static String pad(String string, int number) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static String escapeRegExp(String string) {
        return string.replace(BACK_SLASH, DOUBLE_BACK_SLASH).replace("$", "\\$");
    }

    public static String[] splitByLines(CharSequence cs) {
        return StringUtils.splitByLines(((Object)cs).toString());
    }

    public static String[] splitByLines(String s) {
        return s.split(NEW_LINE_PATTERN, -1);
    }

    public static String readStream(InputStream stream) throws IOException {
        return StringUtils.readStream(stream, null);
    }

    public static String readStream(InputStream stream, String charset) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while (stream.available() > 0) {
            int read = stream.read(buffer);
            String readString = charset == null ? new String(buffer, 0, read) : new String(buffer, 0, read, charset);
            String[] strings = StringUtils.splitByLines(readString);
            for (int i = 0; i < strings.length; ++i) {
                builder.append(strings[i]);
                if (i == strings.length - 1) continue;
                builder.append(SystemUtils.getLineSeparator());
            }
        }
        return builder.toString();
    }

    public static String httpFormat(Date date) {
        return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(date);
    }

    public static String asPath(Class clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static String replace(String string, String replacement, int begin, int end) {
        return string.substring(0, begin) + replacement + string.substring(end);
    }

    public static String escapePath(String path) {
        String localPath = path;
        if (localPath.indexOf(32) > -1) {
            localPath = SystemUtils.isWindows() ? QUOTE + localPath + QUOTE : localPath.replace(SPACE, "\\ ");
        }
        return localPath;
    }

    public static String joinCommand(String ... commandArray) {
        StringBuffer command = new StringBuffer();
        for (int i = 0; i < commandArray.length; ++i) {
            command.append(StringUtils.escapePath(commandArray[i]));
            if (i == commandArray.length - 1) continue;
            command.append(SPACE);
        }
        return command.toString();
    }

    public static String asString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static String asString(List<? extends Object> objects) {
        return StringUtils.asString(objects.toArray(), 0, objects.size(), ", ");
    }

    public static String asString(List<? extends Object> objects, String separator) {
        return StringUtils.asString(objects.toArray(), 0, objects.size(), separator);
    }

    public static String asString(List<? extends Object> objects, int offset, int length, String separator) {
        return StringUtils.asString(objects.toArray(), offset, length, separator);
    }

    public static String asString(Object[] objects) {
        return StringUtils.asString(objects, 0, objects.length, ", ");
    }

    public static String asString(Object[] objects, String separator) {
        return StringUtils.asString(objects, 0, objects.length, separator);
    }

    public static String asString(Object[] objects, int offset, int length, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            result.append(EMPTY_STRING + objects[i]);
            if (i == offset + length - 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String base64Encode(String string) throws UnsupportedEncodingException {
        return StringUtils.base64Encode(string, ENCODING_UTF8);
    }

    public static String base64Encode(String string, String charset) throws UnsupportedEncodingException {
        int byte2;
        int byte1;
        int i;
        StringBuilder builder = new StringBuilder();
        byte[] bytes = string.getBytes(charset);
        for (i = 0; i < bytes.length - 2; i += 3) {
            byte1 = bytes[i] & 0xFF;
            byte2 = bytes[i + 1] & 0xFF;
            int byte3 = bytes[i + 2] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30 | byte2 >> 4]);
            builder.append(BASE64_TABLE[byte2 << 2 & 0x3C | byte3 >> 6]);
            builder.append(BASE64_TABLE[byte3 & 0x3F]);
        }
        if (i == bytes.length - 2) {
            byte1 = bytes[i] & 0xFF;
            byte2 = bytes[i + 1] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30 | byte2 >> 4]);
            builder.append(BASE64_TABLE[byte2 << 2 & 0x3C]);
            builder.append('=');
        }
        if (i == bytes.length - 1) {
            byte1 = bytes[i] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30]);
            builder.append('=');
            builder.append('=');
        }
        return builder.toString();
    }

    public static String base64Decode(String string) throws UnsupportedEncodingException {
        return StringUtils.base64Decode(string, ENCODING_UTF8);
    }

    public static String base64Decode(String string, String charset) throws UnsupportedEncodingException {
        byte byte2;
        byte byte1;
        int completeBlocksNumber = string.length() / 4;
        int missingBytesNumber = 0;
        if (string.endsWith(EQUAL)) {
            --completeBlocksNumber;
            ++missingBytesNumber;
        }
        if (string.endsWith("==")) {
            ++missingBytesNumber;
        }
        int decodedLength = completeBlocksNumber * 3 + (3 - missingBytesNumber) % 3;
        byte[] decodedBytes = new byte[decodedLength];
        int encodedCounter = 0;
        int decodedCounter = 0;
        for (int i = 0; i < completeBlocksNumber; ++i) {
            byte byte12 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte22 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte3 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte4 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte12 << 2 | byte22 >> 4);
            decodedBytes[decodedCounter++] = (byte)(byte22 << 4 | byte3 >> 2);
            decodedBytes[decodedCounter++] = (byte)(byte3 << 6 | byte4);
        }
        if (missingBytesNumber == 1) {
            byte1 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte2 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte3 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte1 << 2 | byte2 >> 4);
            decodedBytes[decodedCounter++] = (byte)(byte2 << 4 | byte3 >> 2);
        }
        if (missingBytesNumber == 2) {
            byte1 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte2 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte1 << 2 | byte2 >> 4);
        }
        return new String(decodedBytes, charset);
    }

    public static String parseAscii(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(("key=" + string).getBytes()));
        }
        catch (IOException e) {
            ErrorManager.notifyWarning("Cannot parse string", e);
            return string;
        }
        return (String)properties.get("key");
    }

    public static String convertToAscii(String string) {
        Properties properties = new Properties();
        properties.put("uberkey", string);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            properties.store(baos, EMPTY_STRING);
        }
        catch (IOException e) {
            ErrorManager.notifyWarning("Cannot convert string", e);
            return string;
        }
        Matcher matcher = Pattern.compile("uberkey=(.*)$", 8).matcher(baos.toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return string;
    }

    public static List<String> asList(String string) {
        return StringUtils.asList(string, ", ");
    }

    public static List<String> asList(String string, String separator) {
        return Arrays.asList(string.split(separator));
    }

    public static Locale parseLocale(String string) {
        String[] parts = string.split(UNDERSCORE);
        switch (parts.length) {
            case 1: {
                return new Locale(parts[0]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    public static String getLocalizedString(Map<Locale, String> stringsMap, Locale inLocale) {
        String message = stringsMap.get(inLocale);
        if (message == null && !inLocale.equals(new Locale(EMPTY_STRING))) {
            Locale upLocale = !inLocale.getVariant().equals(EMPTY_STRING) ? new Locale(inLocale.getLanguage(), inLocale.getCountry()) : (!inLocale.getCountry().equals(EMPTY_STRING) ? new Locale(inLocale.getLanguage()) : new Locale(EMPTY_STRING));
            return StringUtils.getLocalizedString(stringsMap, upLocale);
        }
        return message;
    }

    public static URL parseUrl(String string) throws ParseException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new ParseException("Cannot parse URL", e);
        }
    }

    public static Platform parsePlatform(String string) throws ParseException {
        for (Platform platform : Platform.values()) {
            if (!platform.getCodeName().equals(string)) continue;
            return platform;
        }
        throw new ParseException(ResourceUtils.getString(StringUtils.class, ERROR_UNKNOWN_PLATFORM, string));
    }

    public static List<Platform> parsePlatforms(String string) throws ParseException {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        for (String name : StringUtils.asList(string, SPACE)) {
            Platform platform = StringUtils.parsePlatform(name);
            if (platforms.contains((Object)platform)) continue;
            platforms.add(platform);
        }
        return platforms;
    }

    public static Status parseStatus(String string) throws ParseException {
        for (Status status : Status.values()) {
            if (!status.getName().equals(string)) continue;
            return status;
        }
        throw new ParseException(ResourceUtils.getString(StringUtils.class, ERROR_CANNOT_PARSE_STATUS, string));
    }
}

