/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.Bundle;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class RepositoryPreferences {
    private static final Logger LOG = Logger.getLogger(RepositoryPreferences.class.getName());
    private static RepositoryPreferences instance;
    public static final String TYPE_NEXUS = "nexus";
    private static final String KEY_TYPE = "provider";
    private static final String KEY_DISPLAY_NAME = "name";
    private static final String KEY_PATH = "path";
    private static final String KEY_INDEX_URL = "index";
    private static final String KEY_REPO_URL = "url";
    public static final String PROP_INDEX_FREQ = "indexUpdateFrequency";
    public static final String PROP_LAST_INDEX_UPDATE = "lastIndexUpdate";
    public static final int FREQ_ONCE_WEEK = 0;
    public static final int FREQ_ONCE_DAY = 1;
    public static final int FREQ_STARTUP = 2;
    public static final int FREQ_NEVER = 3;
    private final Map<String, RepositoryInfo> infoCache = new HashMap<String, RepositoryInfo>();
    private final Map<Object, List<RepositoryInfo>> transients = new LinkedHashMap<Object, List<RepositoryInfo>>();
    private final RepositoryInfo local;
    private final RepositoryInfo central;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    private RepositoryPreferences() {
        try {
            this.local = new RepositoryInfo("local", TYPE_NEXUS, Bundle.local(), EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir(), null);
            this.central = new RepositoryInfo("central", TYPE_NEXUS, "central", null, "http://repo1.maven.org/maven2");
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing");
    }

    private Preferences storage() {
        return NbPreferences.root().node("org/netbeans/modules/maven/repositories");
    }

    public static synchronized RepositoryPreferences getInstance() {
        if (instance == null) {
            instance = new RepositoryPreferences();
        }
        return instance;
    }

    @CheckForNull
    private static RepositoryInfo createRepositoryInfo(Preferences p) throws URISyntaxException {
        String type = p.get(KEY_TYPE, TYPE_NEXUS);
        String id = p.name();
        String name = p.get(KEY_DISPLAY_NAME, null);
        if (name == null) {
            return null;
        }
        String path = p.get(KEY_PATH, null);
        String repourl = p.get(KEY_REPO_URL, null);
        String indexurl = p.get(KEY_INDEX_URL, null);
        return new RepositoryInfo(id, type, name, path, repourl, indexurl);
    }

    @NonNull
    public RepositoryInfo getLocalRepository() {
        return this.local;
    }

    @CheckForNull
    public RepositoryInfo getRepositoryInfoById(String id) {
        for (RepositoryInfo ri : this.getRepositoryInfos()) {
            if (!ri.getId().equals(id)) continue;
            return ri;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos() {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        toRet.add(this.local);
        HashSet<String> ids = new HashSet<String>();
        ids.add("local");
        HashSet<String> urls = new HashSet<String>();
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            Preferences storage = this.storage();
            try {
                HashSet<String> gone = new HashSet<String>(this.infoCache.keySet());
                for (String c : storage.childrenNames()) {
                    RepositoryInfo ri = this.infoCache.get(c);
                    if (ri == null) {
                        Preferences child = storage.node(c);
                        try {
                            ri = RepositoryPreferences.createRepositoryInfo(child);
                            if (ri == null) continue;
                            this.infoCache.put(c, ri);
                        }
                        catch (Exception x) {
                            LOG.log(Level.INFO, c, x);
                            try {
                                child.removeNode();
                            }
                            catch (BackingStoreException x2) {
                                LOG.log(Level.INFO, null, x2);
                            }
                            continue;
                        }
                    }
                    toRet.add(ri);
                    gone.remove(c);
                    ids.add(ri.getId());
                    urls.add(ri.getRepositoryUrl());
                }
                for (String g : gone) {
                    this.infoCache.remove(g);
                }
            }
            catch (BackingStoreException x) {
                LOG.log(Level.INFO, null, x);
            }
            if (this.transients.isEmpty()) {
                if (ids.add(this.central.getId()) && urls.add(this.central.getRepositoryUrl())) {
                    toRet.add(this.central);
                }
            } else {
                for (List<RepositoryInfo> infos : this.transients.values()) {
                    for (RepositoryInfo info : infos) {
                        if (!ids.add(info.getId()) || !urls.add(info.getRepositoryUrl())) continue;
                        toRet.add(info);
                    }
                }
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrModifyRepositoryInfo(RepositoryInfo info) {
        String id = info.getId();
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            this.infoCache.put(id, info);
            Preferences p = this.storage().node(id);
            RepositoryPreferences.put(p, KEY_TYPE, info.getType().equals(TYPE_NEXUS) ? null : info.getType());
            p.put(KEY_DISPLAY_NAME, info.getName());
            RepositoryPreferences.put(p, KEY_PATH, info.getRepositoryPath());
            RepositoryPreferences.put(p, KEY_REPO_URL, info.getRepositoryUrl());
            if (info.getRepositoryUrl() != null) {
                RepositoryPreferences.put(p, KEY_INDEX_URL, info.getIndexUpdateUrl().equals(info.getRepositoryUrl() + ".index/") ? null : info.getIndexUpdateUrl());
            }
        }
        this.cs.fireChange();
    }

    private static void put(@NonNull Preferences p, @NonNull String key, @NullAllowed String value) {
        if (value != null) {
            p.put(key, value);
        } else {
            p.remove(key);
        }
    }

    public boolean isPersistent(String id) {
        return this.storage().node(id).get(KEY_DISPLAY_NAME, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryInfo(RepositoryInfo info) {
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            String id = info.getId();
            this.infoCache.remove(id);
            try {
                this.storage().node(id).removeNode();
            }
            catch (BackingStoreException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        this.cs.fireChange();
    }

    public void setIndexUpdateFrequency(int fr) {
        this.getPreferences().putInt(PROP_INDEX_FREQ, fr);
    }

    public int getIndexUpdateFrequency() {
        return this.getPreferences().getInt(PROP_INDEX_FREQ, Boolean.getBoolean("netbeans.full.hack") ? 3 : 0);
    }

    public Date getLastIndexUpdate(String repoId) {
        long old = this.getPreferences().getLong("lastIndexUpdate." + repoId, 0L);
        if (old != 0L) {
            this.getPreferences().remove("lastIndexUpdate." + repoId);
            this.storage().node(repoId).putLong(PROP_LAST_INDEX_UPDATE, old);
        }
        return new Date(this.storage().node(repoId).getLong(PROP_LAST_INDEX_UPDATE, 0L));
    }

    public void setLastIndexUpdate(String repoId, Date date) {
        this.getPreferences().remove("lastIndexUpdate." + repoId);
        this.storage().node(repoId).putLong(PROP_LAST_INDEX_UPDATE, date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientRepository(Object key, String id, String displayName, String url) throws URISyntaxException {
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            List<RepositoryInfo> infos = this.transients.get(key);
            if (infos == null) {
                infos = new ArrayList<RepositoryInfo>();
                this.transients.put(key, infos);
            }
            infos.add(new RepositoryInfo(id, TYPE_NEXUS, displayName, null, url));
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientRepositories(Object key) {
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            this.transients.remove(key);
        }
        this.cs.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }
}

