/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.semc;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SemcApplicationUIDCustomizer
extends JPanel {
    boolean uidValid = true;
    private String uidString;
    private File sdkInstallation;
    private static final String[] MODEL_ITEMS = new String[]{NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_0"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_1"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_2"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_3"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_4")};
    private static final int[] MODEL_VALUES = new int[]{0, 2, 7, 10, 14};
    private JLabel errorLabel;
    private JTextField idTextField;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel resultValueLabel;

    public SemcApplicationUIDCustomizer(String uidString, File sdkInstallation) {
        this.sdkInstallation = sdkInstallation;
        this.uidString = uidString;
        this.initComponents();
        Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (nbErrorForeground == null) {
            nbErrorForeground = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(nbErrorForeground);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(MODEL_ITEMS));
        if (uidString.length() > 0) {
            int uid = Integer.parseInt(uidString.substring(0, 1), 16);
            for (int i = 0; i < MODEL_VALUES.length; ++i) {
                if (uid != MODEL_VALUES[i]) continue;
                this.jComboBox1.setSelectedIndex(i);
                this.idTextField.setText(uidString.substring(1));
                break;
            }
        } else {
            this.jComboBox1.setSelectedIndex(4);
        }
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }
        });
        this.computeUID();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.idTextField = new JTextField();
        this.errorLabel = new JLabel();
        this.resultValueLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_AppUID"));
        this.jLabel2.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_ResultUID"));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemcApplicationUIDCustomizer.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.idTextField.setColumns(7);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox1, -2, 203, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idTextField, -2, 111, -2)).addComponent(this.resultValueLabel, -1, 321, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 14, -2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.resultValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.jComboBox1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSN_jComboBox1"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSD_jComboBox1"));
        this.idTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSN_idTextField"));
        this.idTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSD_idTextField"));
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.computeUID();
    }

    private void computeUID() {
        File f;
        String text = this.idTextField.getText();
        int length = text.length();
        if (length != 7) {
            this.uidValid = false;
        } else {
            this.uidValid = true;
            for (int i = 0; i < length; ++i) {
                if (Character.digit(text.charAt(i), 16) != -1) continue;
                this.uidValid = false;
                break;
            }
        }
        int domain = MODEL_VALUES[this.jComboBox1.getSelectedIndex()];
        String tmpUid = (Integer.toHexString(domain) + this.idTextField.getText()).toUpperCase();
        this.resultValueLabel.setText("0x" + tmpUid);
        boolean duplicity = false;
        if (this.sdkInstallation != null && (f = new File(this.sdkInstallation, "\\epoc32\\release\\winscw\\udeb\\PProLauncher" + tmpUid + ".exe")).exists() && !tmpUid.equals(this.uidString)) {
            this.uidValid = false;
            duplicity = true;
        }
        if (!this.uidValid) {
            if (!duplicity) {
                this.errorLabel.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ERR_WrongRange"));
            } else {
                this.errorLabel.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ERR_UIDAlreadyExists", (Object)tmpUid));
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        } else {
            this.errorLabel.setText(" ");
            this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
        }
    }

    String getUID() {
        return (Integer.toHexString(MODEL_VALUES[this.jComboBox1.getSelectedIndex()]) + this.idTextField.getText()).toUpperCase();
    }
}

