/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.openide.util.NbBundle;

public class FixVersionConflictPanel
extends JPanel {
    private DependencyGraphScene scene;
    private ArtifactGraphNode conflictNode;
    private List<ArtifactVersion> clashingVersions;
    private ExclusionTargets eTargets;
    private JCheckBox addSetCheck;
    private JPanel addSetP;
    private JLabel conflictL;
    private JCheckBox excludeCheck;
    private JPanel excludeP;
    private JList excludesList;
    private JLabel fixPossibL;
    private JPanel fixesP;
    private JLabel fromDirectL;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel sumContent;
    private JLabel summaryL;
    private JLabel versionL;
    private JList versionList;

    public FixVersionConflictPanel(DependencyGraphScene scene, ArtifactGraphNode node) {
        this.scene = scene;
        this.conflictNode = node;
        this.initComponents();
        ExclTargetRenderer render = new ExclTargetRenderer(this.excludesList, this);
        this.excludesList.setCellRenderer(render);
        this.excludesList.addMouseListener(render);
        this.excludesList.addKeyListener(render);
        this.eTargets = new ExclusionTargets(this.conflictNode, this.getClashingVersions().get(0));
        this.visualizeRecommandations(this.computeRecommandations());
    }

    FixDescription getResult() {
        FixDescription res = new FixDescription();
        res.isSet = this.addSetCheck.isSelected();
        res.version2Set = res.isSet ? (ArtifactVersion)this.versionList.getSelectedValue() : null;
        res.isExclude = this.excludeCheck.isSelected();
        if (res.isExclude) {
            res.exclusionTargets = new HashSet<Artifact>();
            res.conflictParents = new HashSet<DependencyNode>();
            ListModel lm = this.excludesList.getModel();
            for (int i = 0; i < lm.getSize(); ++i) {
                ExclTargetEntry entry = (ExclTargetEntry)lm.getElementAt(i);
                if (!entry.isSelected) continue;
                res.exclusionTargets.add(entry.artif);
                res.conflictParents.addAll(this.eTargets.getConflictParents(entry.artif));
            }
        }
        return res;
    }

    private void addSetCheckChanged() {
        boolean isSel = this.addSetCheck.isSelected();
        this.versionL.setEnabled(isSel);
        this.versionList.setEnabled(isSel);
        if (isSel && this.versionList.getSelectedValue() == null) {
            this.versionList.setSelectedIndex(0);
        }
    }

    private void excludeCheckChanged() {
        boolean isSel = this.excludeCheck.isSelected();
        this.fromDirectL.setEnabled(isSel);
        this.excludesList.setEnabled(isSel);
    }

    private String getClashingVersionsAsText() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (ArtifactVersion av : this.getClashingVersions()) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append(av.toString());
        }
        return sb.toString();
    }

    private List<ArtifactVersion> getClashingVersions() {
        if (this.clashingVersions == null) {
            this.clashingVersions = new ArrayList<ArtifactVersion>();
            this.clashingVersions.add((ArtifactVersion)new DefaultArtifactVersion(this.conflictNode.getArtifact().getArtifact().getVersion()));
            Set<DependencyNode> deps = this.conflictNode.getDuplicatesOrConflicts();
            DefaultArtifactVersion av = null;
            for (DependencyNode dn : deps) {
                if (dn.getState() != 2 || this.clashingVersions.contains(av = new DefaultArtifactVersion(dn.getArtifact().getVersion()))) continue;
                this.clashingVersions.add((ArtifactVersion)av);
            }
            Collections.sort(this.clashingVersions);
            Collections.reverse(this.clashingVersions);
        }
        return this.clashingVersions;
    }

    private FixDescription computeRecommandations() {
        Set<Artifact> nonConf;
        FixDescription recs = new FixDescription();
        boolean isDirect = this.conflictNode.getPrimaryLevel() == 1;
        DefaultArtifactVersion usedVersion = new DefaultArtifactVersion(this.conflictNode.getArtifact().getArtifact().getVersion());
        ArtifactVersion newAvailVersion = this.getClashingVersions().get(0);
        if (isDirect && usedVersion.compareTo((Object)newAvailVersion) < 0) {
            recs.isSet = true;
            recs.version2Set = newAvailVersion;
        }
        if (!(nonConf = this.eTargets.getNonConflicting()).isEmpty() && this.eTargets.getAll().size() > 1) {
            recs.isExclude = true;
            recs.exclusionTargets = this.eTargets.getConflicting();
        }
        if (!recs.isSet && !recs.isExclude && usedVersion.compareTo((Object)newAvailVersion) < 0) {
            recs.isSet = true;
            recs.version2Set = newAvailVersion;
            recs.isExclude = true;
            recs.exclusionTargets = this.eTargets.getAll();
        }
        return recs;
    }

    private void visualizeRecommandations(FixDescription recs) {
        this.addSetCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.addSetCheck.text", (Object)this.getSetText()));
        this.addSetCheck.setSelected(recs.isSet);
        this.addSetCheckChanged();
        List<ArtifactVersion> versions = this.getClashingVersions();
        DefaultListModel<ArtifactVersion> model = new DefaultListModel<ArtifactVersion>();
        for (ArtifactVersion av : versions) {
            model.addElement(av);
        }
        this.versionList.setModel(model);
        this.versionList.setSelectedIndex(0);
        if (recs.version2Set != null) {
            this.versionList.setSelectedValue(recs.version2Set, true);
        }
        this.excludeCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.excludeCheck.text"));
        this.excludeCheck.setSelected(recs.isExclude);
        this.excludeCheckChanged();
        Set<Artifact> exclTargets = this.eTargets.getAll();
        if (!exclTargets.isEmpty()) {
            DefaultListModel<ExclTargetEntry> lModel = new DefaultListModel<ExclTargetEntry>();
            for (Artifact exc : exclTargets) {
                lModel.addElement(new ExclTargetEntry(exc, recs.exclusionTargets != null && recs.exclusionTargets.contains(exc)));
            }
            this.excludesList.setModel(lModel);
        } else {
            this.excludeCheck.setEnabled(false);
        }
        this.updateSummary();
    }

    private String getSetText() {
        return this.conflictNode.getPrimaryLevel() == 1 ? NbBundle.getMessage(FixVersionConflictPanel.class, (String)"LBL_SetDep") : NbBundle.getMessage(FixVersionConflictPanel.class, (String)"LBL_AddDep");
    }

    private void updateSummary() {
        FixDescription curFix = this.getResult();
        String part1 = "";
        String part2 = "";
        if (curFix.isSet && curFix.version2Set != null) {
            part1 = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumPart1.text", (Object)this.getSetText(), (Object)curFix.version2Set.toString(), (Object)this.conflictNode.getArtifact().getArtifact().getArtifactId());
        }
        if (curFix.isExclude && !curFix.exclusionTargets.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Artifact art : curFix.exclusionTargets) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(art.getArtifactId());
            }
            part2 = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumPart2.text", (Object)this.conflictNode.getArtifact().getArtifact().getArtifactId(), (Object)sb.toString());
        }
        if (part1.equals("") && part2.equals("")) {
            part1 = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.noChanges");
        }
        if (!part1.equals("") && !part2.equals("")) {
            part1 = part1 + " ";
        }
        this.sumContent.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumContent.text", (Object)part1, (Object)part2));
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.fixesP = new JPanel();
        this.addSetP = new JPanel();
        this.addSetCheck = new JCheckBox();
        this.versionL = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.versionList = new JList();
        this.excludeP = new JPanel();
        this.excludeCheck = new JCheckBox();
        this.fromDirectL = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.excludesList = new JList();
        this.fixPossibL = new JLabel();
        this.summaryL = new JLabel();
        this.jPanel1 = new JPanel();
        this.sumContent = new JLabel();
        this.jPanel2 = new JPanel();
        this.conflictL = new JLabel();
        this.addSetCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.addSetCheck.text"));
        this.addSetCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixVersionConflictPanel.this.addSetCheckActionPerformed(evt);
            }
        });
        this.versionL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.versionL.text"));
        this.versionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FixVersionConflictPanel.this.versionListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.versionList);
        GroupLayout addSetPLayout = new GroupLayout(this.addSetP);
        this.addSetP.setLayout(addSetPLayout);
        addSetPLayout.setHorizontalGroup(addSetPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(addSetPLayout.createSequentialGroup().addGroup(addSetPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addSetCheck).addComponent(this.versionL)).addGap(46, 46, 46)).addGroup(addSetPLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE).addContainerGap()));
        addSetPLayout.setVerticalGroup(addSetPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(addSetPLayout.createSequentialGroup().addComponent(this.addSetCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 156, Short.MAX_VALUE).addContainerGap()));
        this.excludeCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.excludeCheck.text"));
        this.excludeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixVersionConflictPanel.this.excludeCheckActionPerformed(evt);
            }
        });
        this.fromDirectL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.fromDirectL.text"));
        this.jScrollPane2.setViewportView(this.excludesList);
        GroupLayout excludePLayout = new GroupLayout(this.excludeP);
        this.excludeP.setLayout(excludePLayout);
        excludePLayout.setHorizontalGroup(excludePLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(excludePLayout.createSequentialGroup().addGroup(excludePLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludeCheck).addComponent(this.fromDirectL)).addContainerGap(46, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 290, Short.MAX_VALUE));
        excludePLayout.setVerticalGroup(excludePLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(excludePLayout.createSequentialGroup().addComponent(this.excludeCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromDirectL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 156, Short.MAX_VALUE).addContainerGap()));
        GroupLayout fixesPLayout = new GroupLayout(this.fixesP);
        this.fixesP.setLayout(fixesPLayout);
        fixesPLayout.setHorizontalGroup(fixesPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fixesPLayout.createSequentialGroup().addComponent(this.addSetP, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeP, -1, -1, Short.MAX_VALUE)));
        fixesPLayout.setVerticalGroup(fixesPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addSetP, -1, -1, Short.MAX_VALUE).addComponent(this.excludeP, -1, -1, Short.MAX_VALUE));
        this.fixPossibL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.fixPossibL.text"));
        this.summaryL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.summaryL.text"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.sumContent.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumContent.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sumContent, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.conflictL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.conflictL.text", (Object[])new Object[]{this.conflictNode.getArtifact().getArtifact().getArtifactId(), this.getClashingVersionsAsText()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.conflictL, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryL).addComponent(this.fixPossibL).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 531, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 531, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 531, Short.MAX_VALUE).addComponent(this.fixesP, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fixPossibL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fixesP, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    private void excludeCheckActionPerformed(ActionEvent evt) {
        this.excludeCheckChanged();
        this.updateSummary();
    }

    private void addSetCheckActionPerformed(ActionEvent evt) {
        this.addSetCheckChanged();
        this.updateSummary();
    }

    private void versionListValueChanged(ListSelectionEvent evt) {
        this.updateSummary();
    }

    private static class ExclTargetRenderer
    extends JCheckBox
    implements ListCellRenderer,
    MouseListener,
    KeyListener {
        private JList parentList;
        private FixVersionConflictPanel parentPanel;

        public ExclTargetRenderer(JList list, FixVersionConflictPanel parentPanel) {
            this.parentList = list;
            this.parentPanel = parentPanel;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ExclTargetEntry entry = (ExclTargetEntry)value;
            this.setText(entry.artif.getArtifactId());
            this.setSelected(entry.isSelected);
            this.setEnabled(list.isEnabled());
            this.setOpaque(isSelected && list.isEnabled());
            if (isSelected && list.isEnabled()) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int idx = this.parentList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            Rectangle rect = this.parentList.getCellBounds(idx, idx);
            if (rect.contains(e.getPoint())) {
                this.doCheck();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                this.doCheck();
            }
        }

        private void doCheck() {
            int index = this.parentList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            ExclTargetEntry ge = (ExclTargetEntry)this.parentList.getModel().getElementAt(index);
            ge.isSelected = !ge.isSelected;
            this.parentList.repaint();
            this.parentPanel.updateSummary();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class ExclTargetEntry {
        Artifact artif;
        boolean isSelected = false;

        public ExclTargetEntry(Artifact artif, boolean isSelected) {
            this.artif = artif;
            this.isSelected = isSelected;
        }
    }

    static class ExclusionTargets {
        Map<Artifact, Set<ArtifactVersion>> targets2Versions;
        Map<Artifact, Set<DependencyNode>> targets2ConfPar;
        ArtifactGraphNode conflictNode;
        ArtifactVersion usedVersion;
        ArtifactVersion newestVersion;

        public ExclusionTargets(ArtifactGraphNode conflictNode, ArtifactVersion newestVersion) {
            this.conflictNode = conflictNode;
            this.newestVersion = newestVersion;
            this.usedVersion = new DefaultArtifactVersion(conflictNode.getArtifact().getArtifact().getVersion());
            this.initialize();
        }

        private void initialize() {
            this.targets2Versions = new HashMap<Artifact, Set<ArtifactVersion>>();
            this.targets2ConfPar = new HashMap<Artifact, Set<DependencyNode>>();
            DependencyNode curDn = null;
            DependencyNode parent = null;
            ArrayList<DependencyNode> allDNs = new ArrayList<DependencyNode>(this.conflictNode.getDuplicatesOrConflicts());
            if (this.conflictNode.getPrimaryLevel() > 1) {
                allDNs.add(this.conflictNode.getArtifact());
            }
            for (DependencyNode dn : allDNs) {
                curDn = dn;
                parent = curDn.getParent();
                if (parent == null) continue;
                while (parent.getParent() != null) {
                    parent = parent.getParent();
                    curDn = curDn.getParent();
                }
                Set<DependencyNode> confPar = this.targets2ConfPar.get(curDn.getArtifact());
                if (confPar == null) {
                    confPar = new HashSet<DependencyNode>();
                    this.targets2ConfPar.put(curDn.getArtifact(), confPar);
                }
                confPar.add(dn.getParent());
                Set<ArtifactVersion> versions = this.targets2Versions.get(curDn.getArtifact());
                if (versions == null) {
                    versions = new HashSet<ArtifactVersion>();
                    this.targets2Versions.put(curDn.getArtifact(), versions);
                }
                versions.add((ArtifactVersion)new DefaultArtifactVersion(dn.getArtifact().getVersion()));
            }
        }

        public Set<Artifact> getAll() {
            return this.targets2Versions.keySet();
        }

        public Set<Artifact> getNonConflicting() {
            HashSet<Artifact> result = new HashSet<Artifact>();
            for (Artifact art : this.getAll()) {
                if (!this.isNonConflicting(art)) continue;
                result.add(art);
            }
            return result;
        }

        public Set<Artifact> getConflicting() {
            HashSet<Artifact> result = new HashSet<Artifact>();
            for (Artifact art : this.getAll()) {
                if (this.isNonConflicting(art)) continue;
                result.add(art);
            }
            return result;
        }

        public boolean isNonConflicting(Artifact art) {
            Set<ArtifactVersion> versions = this.targets2Versions.get(art);
            return versions != null && versions.size() == 1 && this.newestVersion.equals(versions.iterator().next());
        }

        public Set<DependencyNode> getConflictParents(Artifact art) {
            return this.targets2ConfPar.get(art);
        }
    }

    static class FixDescription {
        boolean isSet = false;
        boolean isExclude = false;
        ArtifactVersion version2Set = null;
        Set<Artifact> exclusionTargets = null;
        Set<DependencyNode> conflictParents = null;

        FixDescription() {
        }
    }
}

