/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.EventQueue;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;

class TaskListModel
extends AbstractTableModel
implements TaskList.Listener {
    protected TaskList taskList;
    protected static final int COL_GROUP = 0;
    protected static final int COL_DESCRIPTION = 1;
    protected static final int COL_FILE = 2;
    protected static final int COL_LOCATION = 3;
    private List<? extends Task> listOfTasks;
    private final Object lock = new Object();
    protected int sortingCol = -1;
    protected boolean ascending = true;

    public TaskListModel(TaskList taskList) {
        this.taskList = taskList;
        this.listOfTasks = this.getListOfTasks();
        this.sortingCol = Settings.getDefault().getSortingColumn();
        this.ascending = Settings.getDefault().isAscendingSort();
        this.sortTaskList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.lock;
        synchronized (object) {
            List<? extends Task> list = this.getListOfTasks();
            return null == list ? 0 : list.size();
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (0 == column) {
            return TaskGroup.class;
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Description");
            }
            case 2: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_File");
            }
            case 3: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Location");
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Task t = this.getTaskAtRow(row);
        if (null != t) {
            switch (col) {
                case 0: {
                    return Accessor.getGroup(t);
                }
                case 1: {
                    return Accessor.getDescription(t);
                }
                case 2: {
                    return Accessor.getFileNameExt(t);
                }
                case 3: {
                    return Accessor.getLocation(t);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task getTaskAtRow(int row) {
        Object object = this.lock;
        synchronized (object) {
            List<? extends Task> list = this.getListOfTasks();
            if (list.size() > row) {
                return list.get(row);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tasksAdded(List<? extends Task> tasks) {
        int endRow;
        int startRow;
        if (tasks.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            startRow = this.getListOfTasks().indexOf(tasks.get(0));
            endRow = this.getListOfTasks().indexOf(tasks.get(tasks.size() - 1));
            this.listOfTasks = null;
        }
        if (startRow > -1 && endRow > -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListModel.this.fireTableRowsInserted(startRow, endRow);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tasksRemoved(List<? extends Task> tasks) {
        int endRow;
        int startRow;
        if (tasks.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            startRow = this.getListOfTasks().indexOf(tasks.get(0));
            endRow = this.getListOfTasks().indexOf(tasks.get(tasks.size() - 1));
            this.listOfTasks = null;
        }
        if (startRow > -1 && endRow > -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListModel.this.fireTableRowsDeleted(startRow, endRow);
                }
            });
        }
    }

    @Override
    public void cleared() {
        this.fireTableDataChanged();
    }

    public void toggleSort(int column) {
        if (column != this.sortingCol) {
            this.sortingCol = column;
            this.ascending = true;
        } else if (this.ascending) {
            this.ascending = false;
        } else {
            this.sortingCol = -1;
        }
        this.sortTaskList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortTaskList() {
        Comparator<Task> comparator;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        this.taskList.setComparator(comparator);
        Object object = this.lock;
        synchronized (object) {
            this.listOfTasks = null;
        }
        Settings.getDefault().setSortingColumn(this.sortingCol);
        Settings.getDefault().setAscendingSort(this.ascending);
        this.fireTableDataChanged();
    }

    public int getSortingColumnn() {
        return this.sortingCol;
    }

    public boolean isAscendingSort() {
        return this.ascending;
    }

    public void setAscendingSort(boolean asc) {
        if (this.sortingCol >= 0) {
            this.ascending = asc;
            this.sortTaskList();
        }
    }

    void attach() {
        this.taskList.addListener(this);
    }

    void detach() {
        this.taskList.removeListener(this);
    }

    private List<? extends Task> getListOfTasks() {
        if (this.listOfTasks == null) {
            this.listOfTasks = this.taskList.getTasks();
        }
        return this.listOfTasks;
    }
}

