/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskIndexer;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;

public class Loader
implements Runnable,
Cancellable {
    private boolean cancelled = false;
    private final TaskScanningScope scope;
    private final TaskFilter filter;
    private final TaskList taskList;

    public Loader(TaskScanningScope scope, TaskFilter filter, TaskList taskList) {
        this.scope = scope;
        this.filter = filter;
        this.taskList = taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskManagerImpl.getInstance().setLoadingStatus(this, true);
        try {
            Collection projectsInScope = this.scope.getLookup().lookupAll(Project.class);
            if (!projectsInScope.isEmpty()) {
                LinkedList roots = new LinkedList();
                for (Project p : projectsInScope) {
                    if (this.cancelled) {
                        return;
                    }
                    roots.addAll(QuerySupport.findRoots((Project)p, null, null, null));
                }
                this.loadTasks(roots.toArray(new FileObject[roots.size()]), null);
            } else {
                Iterator it = this.scope.iterator();
                while (it.hasNext() && !this.cancelled) {
                    FileObject fo = (FileObject)it.next();
                    ArrayList roots = new ArrayList(QuerySupport.findRoots((FileObject)fo, null, null, null));
                    this.loadTasks(roots.toArray(new FileObject[roots.size()]), fo);
                }
            }
        }
        finally {
            TaskManagerImpl.getInstance().setLoadingStatus(this, false);
        }
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    private void loadTasks(FileObject[] roots, FileObject resource) {
        ArrayList<Task> loadedTasks = null;
        try {
            QuerySupport qs = QuerySupport.forRoots((String)"TaskListIndexer", (int)2, (FileObject[])roots);
            for (FileTaskScanner scanner : ScannerList.getFileScannerList().getScanners()) {
                if (this.cancelled) {
                    return;
                }
                if (!this.filter.isEnabled(scanner)) continue;
                String scannerId = ScannerDescriptor.getType(scanner);
                Collection cache = qs.query("scanner", scannerId, QuerySupport.Kind.EXACT, new String[]{"task"});
                for (IndexResult ir : cache) {
                    String[] tasks;
                    if (this.cancelled) {
                        return;
                    }
                    FileObject fo = ir.getFile();
                    if (null == fo || null != resource && !resource.equals(ir.getFile())) continue;
                    if (null != loadedTasks) {
                        loadedTasks.clear();
                    }
                    for (String encodedTask : tasks = ir.getValues("task")) {
                        if (this.cancelled) {
                            return;
                        }
                        Task t = TaskIndexer.decode(fo, encodedTask);
                        if (null == loadedTasks) {
                            loadedTasks = new ArrayList<Task>(1000);
                        }
                        loadedTasks.add(t);
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (null == loadedTasks || loadedTasks.isEmpty()) continue;
                    this.taskList.update(scanner, fo, (List<Task>)loadedTasks, this.filter);
                }
            }
        }
        catch (IOException ioE) {
            Logger.getLogger(TaskIndexer.class.getName()).log(Level.INFO, "Error while loading tasks from cache", ioE);
        }
    }

    void refresh(FileObject fo) {
        this.loadTasks(new FileObject[]{fo}, null);
    }
}

