/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzer;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.editor.ext.html.parser.spi.UndeclaredContentResolver;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class HtmlGSFParser
extends Parser {
    private HtmlParserResult lastResult;
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.lastResult = this.parse(snapshot, event);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private HtmlParserResult parse(Snapshot snapshot, SourceModificationEvent event) {
        HtmlSource source = new HtmlSource(snapshot);
        String sourceMimetype = snapshot.getSource().getMimeType();
        Collection<HtmlExtension> exts = HtmlExtension.getRegisteredExtensions(sourceMimetype);
        ArrayList<UndeclaredContentResolver> resolvers = new ArrayList<UndeclaredContentResolver>();
        for (HtmlExtension ex : exts) {
            UndeclaredContentResolver resolver = ex.getUndeclaredContentResolver();
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        SyntaxAnalyzerResult spresult = SyntaxAnalyzer.create((HtmlSource)source).analyze((UndeclaredContentResolver)new AggregatedUndeclaredContentResolver(resolvers));
        HtmlParserResult result = HtmlParserResultAccessor.get().createInstance(spresult);
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord rec = new LogRecord(Level.FINE, "HTML parse result");
            rec.setParameters(new Object[]{result});
            TIMERS.log(rec);
        }
        return result;
    }

    public static ElementHandle resolveHandle(ParserResult info, ElementHandle oldElementHandle) {
        if (oldElementHandle instanceof HtmlElementHandle) {
            HtmlElementHandle element = (HtmlElementHandle)oldElementHandle;
            AstNode oldNode = element.node();
            AstNode oldRoot = AstNodeUtils.getRoot((AstNode)oldNode);
            HtmlParserResult newResult = (HtmlParserResult)info;
            AstNode newRoot = newResult.root();
            if (newRoot == null) {
                return null;
            }
            AstNode newNode = HtmlGSFParser.find(oldRoot, oldNode, newRoot);
            if (newNode != null) {
                return new HtmlElementHandle(newNode, info.getSnapshot().getSource().getFileObject());
            }
        }
        return null;
    }

    private static AstNode find(AstNode oldRoot, AstNode oldObject, AstNode newRoot) {
        if (oldRoot == oldObject) {
            return newRoot;
        }
        List oChildren = oldRoot.children();
        List nChildren = newRoot.children();
        for (int i = 0; i < oChildren.size(); ++i) {
            AstNode oCh = (AstNode)oChildren.get(i);
            if (i == nChildren.size()) {
                return null;
            }
            AstNode nCh = (AstNode)nChildren.get(i);
            if (oCh == oldObject) {
                return nCh;
            }
            AstNode match = HtmlGSFParser.find(oCh, oldObject, nCh);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static class AggregatedUndeclaredContentResolver
    extends UndeclaredContentResolver {
        private Collection<UndeclaredContentResolver> resolvers;

        public AggregatedUndeclaredContentResolver(Collection<UndeclaredContentResolver> resolvers) {
            this.resolvers = resolvers;
        }

        public Map<String, List<String>> getUndeclaredNamespaces(HtmlSource source) {
            HashMap<String, List<String>> aggregated = new HashMap<String, List<String>>();
            for (UndeclaredContentResolver resolver : this.resolvers) {
                aggregated.putAll(resolver.getUndeclaredNamespaces(source));
            }
            return aggregated;
        }
    }
}

