/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.html.editor.HtmlCaretAwareSourceTask;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class NavigationSideBar
extends JPanel
implements Accessible {
    private JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final Document doc;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            NavigationSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigationSideBar.this.repaint();
                }
            });
        }
    };
    private boolean enabled = true;
    List<AstNode> nesting = new ArrayList<AstNode>(5);
    private TestAccess testAccess;

    public NavigationSideBar() {
        this.doc = null;
    }

    public NavigationSideBar(JTextComponent component) {
        this.setLayout(new FlowLayout(0, 14, 0));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.component = component;
        this.doc = component.getDocument();
        HtmlCaretAwareSourceTask.Source source = HtmlCaretAwareSourceTask.forDocument(this.doc);
        source.addChangeListener(new HtmlCaretAwareSourceTask.SourceListener(){

            @Override
            public void parsed(Parser.Result info, SchedulerEvent event) {
                NavigationSideBar.this.change(info, event);
            }
        });
        this.updatePreferredSize();
    }

    private void change(Parser.Result info, SchedulerEvent event) {
        if (event == null) {
            return;
        }
        int caretPosition = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        HtmlParserResult result = (HtmlParserResult)info;
        LinkedList<AstNode> allRoots = new LinkedList<AstNode>();
        allRoots.addAll(result.roots().values());
        allRoots.add(result.rootOfUndeclaredTagsParseTree());
        ArrayList<AstNode> nodesInPath = new ArrayList<AstNode>();
        int astOffset = info.getSnapshot().getEmbeddedOffset(caretPosition);
        for (AstNode root : allRoots) {
            AstNode leaf = AstNodeUtils.findNode((AstNode)root, (int)astOffset, (boolean)false, (boolean)false);
            if (leaf == null) continue;
            for (AstNode node : leaf.path().path()) {
                if (node.type() != AstNode.NodeType.OPEN_TAG || node.isVirtual()) continue;
                nodesInPath.add(node);
            }
        }
        Collections.sort(nodesInPath, new Comparator<AstNode>(){

            @Override
            public int compare(AstNode o1, AstNode o2) {
                return o1.startOffset() - o2.startOffset();
            }
        });
        this.updateNestingInfo(info, nodesInPath);
        if (this.testAccess != null) {
            this.testAccess.updated(nodesInPath);
        }
    }

    private void updateNestingInfo(final Parser.Result tsource, List<AstNode> sortedPath) {
        this.nesting = sortedPath;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigationSideBar.this.updatePanelUI(tsource);
            }
        });
    }

    private void updatePanelUI(final Parser.Result tsource) {
        this.removeAll();
        for (final AstNode node : this.nesting) {
            final JLabel label = new JLabel();
            label.setForeground(Color.BLACK);
            label.setFont(new Font("Monospaced", 0, (int)((double)this.getColoring().getFont().getSize() * 0.9)));
            label.setCursor(Cursor.getPredefinedCursor(12));
            label.setText(this.getDrawText(node.name()));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    label.setForeground(Color.BLUE);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    label.setForeground(Color.BLACK);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int documentOffset = tsource.getSnapshot().getOriginalOffset(node.startOffset());
                    NavigationSideBar.this.component.getCaret().setDot(documentOffset);
                }
            });
            this.add(label);
        }
        this.revalidate();
        this.repaint();
    }

    private String getDrawText(String tagName) {
        return tagName;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.component.getWidth(), this.getColoring().getFont().getSize() + 4));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            FontColorSettings fcs = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next();
            this.attribs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.attribs, fcs.getFontColors("default")});
        }
        return Coloring.fromAttributeSet((AttributeSet)this.attribs);
    }

    void regicterTestAccess(TestAccess ta) {
        this.testAccess = ta;
    }

    static interface TestAccess {
        public void updated(List<AstNode> var1);
    }

    public static final class NavigationSideBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new NavigationSideBar(target);
        }
    }
}

