/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.VCSAccessor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class StackTraceSupport {
    private static final Pattern ST_PATTERN = Pattern.compile("([\\p{Alnum}\\.\\$_<>]*?)\\((?:Native Method|Unknown Source|Compiled Code|([\\p{Alnum}\\.\\$_]*?):(\\p{Digit}+?))\\)", 32);
    private static List<String> subs;
    private static MouseInputAdapter hyperlinkListener;

    private StackTraceSupport() {
    }

    private static void findAndOpen(String text) {
        block0: {
            List<StackTracePosition> st = StackTraceSupport.find(text);
            Iterator<StackTracePosition> i$ = st.iterator();
            if (!i$.hasNext()) break block0;
            StackTracePosition stp = i$.next();
            StackTraceElement ste = stp.getStackTraceElements()[0];
            String path = StackTraceSupport.getPath(ste);
            StackTraceSupport.open(path, ste.getLineNumber() - 1);
        }
    }

    private static void findAndShowHistory(String text) {
        block0: {
            List<StackTracePosition> st = StackTraceSupport.find(text);
            Iterator<StackTracePosition> i$ = st.iterator();
            if (!i$.hasNext()) break block0;
            StackTracePosition stp = i$.next();
            StackTraceElement ste = stp.getStackTraceElements()[0];
            String path = StackTraceSupport.getPath(ste);
            StackTraceSupport.openSearchHistory(path, ste.getLineNumber());
        }
    }

    private static String getPath(StackTraceElement ste) {
        String path = ste.getClassName();
        int index = path.indexOf(36);
        if (index != -1) {
            path = path.substring(0, index);
        }
        path = path.replace(".", "/") + ".java";
        return path;
    }

    static List<StackTracePosition> find(String text) {
        LinkedList<StackTracePosition> result = new LinkedList<StackTracePosition>();
        if (text == null) {
            return result;
        }
        ArrayList<Integer> lineBreaks = new ArrayList<Integer>();
        int pos = -1;
        while ((pos = text.indexOf("\n", pos + 1)) > -1) {
            lineBreaks.add(pos);
        }
        String nt = StackTraceSupport.removeAll(text, '\n');
        Matcher m = ST_PATTERN.matcher(nt);
        ArrayList<StackTraceElement> st = new ArrayList<StackTraceElement>();
        subs = new ArrayList<String>();
        int last = -1;
        int start = -1;
        while (m.find()) {
            StackTraceElement ste;
            if (start == -1) {
                start = m.start();
            }
            if (!StackTraceSupport.isStacktraceContinuation(nt, last, m.start())) {
                StackTraceElement[] stArray = st.toArray(new StackTraceElement[0]);
                if (stArray.length > 1) {
                    start = StackTraceSupport.adjustFirstLinePosition(text, start);
                    result.add(new StackTracePosition(stArray, start, last));
                }
                st = new ArrayList();
                start = m.start();
                subs = new ArrayList<String>();
            }
            if ((ste = StackTraceSupport.createStackTraceElement(m.group(1), m.group(2), m.group(3))) != null) {
                st.add(ste);
            }
            last = m.end();
        }
        if (!st.isEmpty()) {
            start = StackTraceSupport.adjustFirstLinePosition(text, start);
            result.add(new StackTracePosition(st.toArray(new StackTraceElement[st.size()]), start, last));
        }
        return result;
    }

    private static boolean isStacktraceContinuation(String text, int last, int start) {
        if (last == -1) {
            return true;
        }
        String sub = text.substring(last, start);
        subs.add(sub);
        block3: for (int i = 0; i < sub.length(); ++i) {
            char ch = sub.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '[': 
                case ']': 
                case 'a': 
                case 'c': 
                case 'h': 
                case 't': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static int adjustFirstLinePosition(String text, int start) {
        if (start > 0) {
            int startOfLine;
            for (startOfLine = start - 1; startOfLine > 0; --startOfLine) {
                if (text.charAt(startOfLine) != '\n') continue;
                ++startOfLine;
                break;
            }
            if (StackTraceSupport.isStacktraceContinuation(text, startOfLine, start)) {
                return startOfLine;
            }
        }
        return start;
    }

    private static StackTraceElement createStackTraceElement(String method, String file, String line) {
        int lastDot = method.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return new StackTraceElement(method.substring(0, lastDot), method.substring(lastDot + 1), file, line == null ? -1 : Integer.parseInt(line));
    }

    private static String removeAll(String source, char toRemove) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\n') {
                if (i > 1 && source.charAt(i - 2) == 'a' && source.charAt(i - 2) == 't') {
                    sb.append("");
                }
                sb.append(" ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static void open(String path, final int line) {
        final FileObject fo = StackTraceSupport.search(path);
        if (fo != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackTraceSupport.doOpen(fo, line);
                }
            });
        }
    }

    private static void openSearchHistory(String path, final int line) {
        FileObject fo = StackTraceSupport.search(path);
        if (fo != null) {
            final File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                return;
            }
            Collection supports = Lookup.getDefault().lookupAll(VCSAccessor.class);
            if (supports == null) {
                return;
            }
            for (final VCSAccessor s : supports) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        s.searchHistory(file, line);
                    }
                });
            }
        }
    }

    private static boolean doOpen(FileObject fo, int line) {
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && line != -1 && (doc = ec.openDocument()) != null && line != -1) {
                Line l = null;
                try {
                    l = lc.getLineSet().getCurrent(line);
                }
                catch (IndexOutOfBoundsException e) {
                    BugtrackingManager.LOG.log(Level.FINE, null, e);
                    ec.open();
                    return false;
                }
                if (l != null) {
                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, e);
        }
        return false;
    }

    private static FileObject search(String path) {
        return GlobalPathRegistry.getDefault().findResource(path);
    }

    public static void register(final JTextPane textPane) {
        final StyledDocument doc = textPane.getStyledDocument();
        final String comment = textPane.getText();
        final List<StackTracePosition> stacktraces = StackTraceSupport.find(comment);
        if (!stacktraces.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackTraceSupport.underlineStacktraces(doc, textPane, stacktraces, comment);
                    textPane.addMouseListener(StackTraceSupport.getHyperlinkListener());
                    textPane.addMouseMotionListener(StackTraceSupport.getHyperlinkListener());
                }
            });
        }
    }

    private static void underlineStacktraces(StyledDocument doc, JTextPane textPane, List<StackTracePosition> stacktraces, String comment) {
        Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style hlStyle = doc.addStyle("regularBlue-stacktrace", defStyle);
        hlStyle.addAttribute("attribute.stacktrace.link", new StackTraceAction());
        StyleConstants.setForeground(hlStyle, Color.BLUE);
        StyleConstants.setUnderline(hlStyle, true);
        int last = 0;
        textPane.setText("");
        for (StackTracePosition stp : stacktraces) {
            int start = stp.getStartOffset();
            int end = stp.getEndOffset();
            if (last < start) {
                StackTraceSupport.insertString(doc, comment, last, start, defStyle);
            }
            last = start;
            boolean inStackTrace = comment.charAt(start) > ' ';
            for (int i = start; i < end; ++i) {
                char ch = comment.charAt(i);
                if ((!inStackTrace || ch != '\n') && (inStackTrace || ch <= ' ')) continue;
                StackTraceSupport.insertString(doc, comment, last, i, inStackTrace ? hlStyle : defStyle);
                inStackTrace = !inStackTrace;
                last = i;
            }
            if (last < end) {
                StackTraceSupport.insertString(doc, comment, last, end, inStackTrace ? hlStyle : defStyle);
            }
            last = end;
        }
        try {
            doc.insertString(doc.getLength(), comment.substring(last), defStyle);
        }
        catch (BadLocationException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static void insertString(StyledDocument doc, String comment, int last, int start, Style defStyle) {
        try {
            doc.insertString(doc.getLength(), comment.substring(last, start), defStyle);
        }
        catch (BadLocationException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static MouseInputAdapter getHyperlinkListener() {
        if (hyperlinkListener == null) {
            hyperlinkListener = new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Element elem;
                        AttributeSet as;
                        StackTraceAction stacktraceAction;
                        if (SwingUtilities.isLeftMouseButton(e) && (stacktraceAction = (StackTraceAction)(as = (elem = this.element(e)).getAttributes()).getAttribute("attribute.stacktrace.link")) != null) {
                            try {
                                StackTraceAction.openStackTrace(elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset()), false);
                            }
                            catch (Exception ex) {
                                BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showMenu(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                private Element element(MouseEvent e) {
                    JTextPane pane = (JTextPane)e.getSource();
                    StyledDocument doc = pane.getStyledDocument();
                    return doc.getCharacterElement(pane.viewToModel(e.getPoint()));
                }

                private void showMenu(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        try {
                            Element elem = this.element(e);
                            if (elem.getAttributes().getAttribute("attribute.stacktrace.link") != null) {
                                String stackFrame = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                                JPopupMenu menu = new JPopupMenu();
                                menu.add(new StackTraceAction(stackFrame, false));
                                menu.add(new StackTraceAction(stackFrame, true));
                                menu.show((JTextPane)e.getSource(), e.getX(), e.getY());
                            }
                        }
                        catch (Exception ex) {
                            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
        }
        return hyperlinkListener;
    }

    static class StackTraceAction
    extends AbstractAction {
        private String stackFrame;
        private boolean showHistory;

        StackTraceAction() {
        }

        StackTraceAction(String stackFrame, boolean showHistory) {
            this.stackFrame = stackFrame;
            this.showHistory = showHistory;
            String name = NbBundle.getMessage(StackTraceAction.class, (String)(showHistory ? "StackTraceSupport.StackTraceAction.showHistory" : "StackTraceSupport.StackTraceAction.open"));
            this.putValue("Name", name);
        }

        static void openStackTrace(String text, boolean showHistory) {
            if (showHistory) {
                StackTraceSupport.findAndShowHistory(text);
            } else {
                StackTraceSupport.findAndOpen(text);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StackTraceAction.openStackTrace(this.stackFrame, this.showHistory);
        }
    }

    static class StackTracePosition {
        private final StackTraceElement[] stackTraceElements;
        private int start;
        private int end;

        StackTracePosition(StackTraceElement[] stackTraceElements, int start, int end) {
            this.stackTraceElements = stackTraceElements;
            this.start = start;
            this.end = end;
        }

        int getStartOffset() {
            return this.start;
        }

        int getEndOffset() {
            return this.end;
        }

        StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }
    }
}

