/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RepositoryFormPanel
extends JPanel {
    private Collection<String> cardNames = new ArrayList<String>(6);
    private Repository selectedRepository = null;
    private BugtrackingController selectedFormController = null;
    private boolean isValidData = false;
    private JComponent cardsPanel;
    private JLabel errorLabel;
    private final FormDataListener formDataListener = new FormDataListener();
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(4);
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private JPanel emptyPanel;

    public RepositoryFormPanel() {
        this.initComponents();
    }

    public RepositoryFormPanel(Repository repository, String initialErrorMessage) {
        this();
        this.displayForm(repository, initialErrorMessage);
    }

    private void initComponents() {
        this.cardsPanel = new JPanel(new CardLayout());
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(new Color(153, 0, 0));
        this.errorLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/error.gif")));
        this.updateErrorMessage(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.cardsPanel).addComponent(this.errorLabel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.cardsPanel).addGap(6, 14, 14).addComponent(this.errorLabel));
        layout.setHonorsVisibility(false);
    }

    public boolean displayForm(Repository repository, String initialErrMsg) {
        if (repository == this.selectedRepository) {
            return false;
        }
        boolean wasValid = this.isValidData;
        boolean firstTimeUse = this.displayFormPanel(repository, initialErrMsg);
        if (this.isValidData != wasValid) {
            this.fireValidityChanged();
        }
        return firstTimeUse;
    }

    void displayErrorMessage(String message) {
        this.updateErrorMessage(message);
    }

    public Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    private void checkDataValidity() {
        assert (this.selectedFormController != null);
        boolean valid = this.selectedFormController.isValid();
        this.updateErrorMessage(this.selectedFormController.getErrorMessage());
        this.setDataValid(valid);
    }

    private void setDataValid(boolean valid) {
        if (valid != this.isValidData) {
            this.isValidData = valid;
            this.fireValidityChanged();
        }
    }

    private void updateErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            errorMessage = errorMessage.trim();
        }
        if (errorMessage != null && errorMessage.length() != 0) {
            this.errorLabel.setText(errorMessage);
            this.errorLabel.setVisible(true);
        } else {
            this.errorLabel.setVisible(false);
            this.errorLabel.setText(" ");
        }
    }

    private boolean displayFormPanel(Repository repository, String initialErrMsg) {
        if (repository == this.selectedRepository) {
            return false;
        }
        this.stopListeningOnController();
        if (repository != null) {
            String cardName = RepositoryFormPanel.getCardName(repository);
            BugtrackingController controller = repository.getController();
            boolean firstTimeUse = this.registerCard(cardName);
            if (firstTimeUse) {
                this.cardsPanel.add((Component)controller.getComponent(), cardName);
            }
            ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, cardName);
            this.selectedFormController = controller;
            this.selectedRepository = repository;
            this.startListeningOnController();
            if (initialErrMsg != null && initialErrMsg.trim().length() != 0) {
                this.updateErrorMessage(initialErrMsg);
                this.setDataValid(false);
            } else {
                this.checkDataValidity();
            }
            return firstTimeUse;
        }
        String cardName = RepositoryFormPanel.getCardName(repository);
        if (this.emptyPanel == null) {
            this.emptyPanel = new JPanel();
        }
        this.cardsPanel.add((Component)this.emptyPanel, cardName);
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, cardName);
        this.selectedFormController = null;
        this.selectedRepository = null;
        this.updateErrorMessage(NbBundle.getMessage(RepositoryFormPanel.class, (String)"LBL_CouldNotCreateRepository"));
        this.setDataValid(false);
        return true;
    }

    private void startListeningOnController() {
        this.selectedFormController.addPropertyChangeListener(this.formDataListener);
    }

    private void stopListeningOnController() {
        if (this.selectedFormController != null) {
            assert (this.formDataListener != null);
            this.selectedFormController.removePropertyChangeListener(this.formDataListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopListeningOnController();
    }

    private static String getCardName(Repository repository) {
        return Integer.toString(System.identityHashCode(repository), 36);
    }

    private boolean registerCard(String cardName) {
        if (!this.cardNames.contains(cardName)) {
            this.cardNames.add(cardName);
            return true;
        }
        return false;
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireValidityChanged() {
        if (!this.listeners.isEmpty()) {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(this.changeEvent);
            }
        }
    }

    class FormDataListener
    implements PropertyChangeListener {
        FormDataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("bugtracking.data.changed".equals(evt.getPropertyName())) {
                RepositoryFormPanel.this.checkDataValidity();
            }
        }
    }
}

