/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPopup;

public class QuickSearchComboBar
extends JPanel {
    private QuickSearchPopup displayer;
    private Color origForeground;
    private JPanel caller;
    private PropertyChangeSupport changeSupport;
    public static final String EVT_ISSUE_CHANGED = "QuickSearchComboBar.issue.changed";
    private JComboBox command;

    public QuickSearchComboBar(JPanel caller) {
        this.caller = caller;
        this.initComponents();
        this.command.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Issue) {
                    Issue item = (Issue)value;
                    value = PopupItem.IssueItem.getIssueDescription(item);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.command.setEditor(new ComboEditor(this.command.getEditor()));
        this.displayer = new QuickSearchPopup(this);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    public Issue getIssue() {
        return (Issue)this.command.getEditor().getItem();
    }

    public void setRepository(Repository repo) {
        this.displayer.setRepository(repo);
        List<Issue> issues = BugtrackingManager.getInstance().getRecentIssues(repo);
        this.command.setModel(new DefaultComboBoxModel<Issue>(issues.toArray(new Issue[issues.size()])));
        this.command.setSelectedItem(null);
    }

    void setIssue(Issue issue) {
        if (issue != null) {
            this.command.getEditor().setItem(issue);
            this.displayer.setVisible(false);
        }
    }

    private void initComponents() {
        this.command = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                QuickSearchComboBar.this.formFocusLost(evt);
            }
        });
        this.command.setEditable(true);
        this.command.setName("command");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.command, 0, 353, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.command, -2, -1, -2));
    }

    private void formFocusLost(FocusEvent evt) {
        this.displayer.setVisible(false);
    }

    private void returnFocus() {
        this.displayer.setVisible(false);
        if (this.caller != null) {
            this.caller.requestFocus();
        }
    }

    public void enableFields(boolean enable) {
        this.command.setEnabled(enable);
    }

    public void invokeSelectedItem() {
        JList list = this.displayer.getList();
        if (list.getModel().getSize() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JList l = QuickSearchComboBar.this.displayer.getList();
                    if (l.getSelectedIndex() == -1) {
                        l.setSelectedIndex(l.getModel().getSize() - 1);
                    }
                    QuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport;
    }

    public void setNoResults(boolean areNoResults) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(((JTextField)this.command.getEditor().getEditorComponent()).getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(areNoResults ? Color.RED : this.origForeground);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public Component getIssueComponent() {
        return this.command;
    }

    String getText() {
        return ((JTextField)this.command.getEditor().getEditorComponent()).getText();
    }

    static Color getPopupBorderColor() {
        Color shadow = UIManager.getColor("controlShadow");
        return shadow != null ? shadow : Color.GRAY;
    }

    static Color getTextBackground() {
        Color textB = UIManager.getColor("TextPane.background");
        return textB != null ? textB : Color.WHITE;
    }

    static Color getResultBackground() {
        return QuickSearchComboBar.getTextBackground();
    }

    boolean isTextFieldFocusOwner() {
        return this.command.getEditor().getEditorComponent().isFocusOwner();
    }

    private class ComboEditor
    implements ComboBoxEditor {
        private final JTextField editor;
        private Issue issue;
        private boolean ignoreCommandChanges = false;
        private final ComboBoxEditor delegate;

        public ComboEditor(ComboBoxEditor delegate) {
            this.delegate = delegate;
            this.editor = (JTextField)delegate.getEditorComponent();
            this.editor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    this.textChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                    this.textChanged();
                }

                private void textChanged() {
                    if (ComboEditor.this.ignoreCommandChanges) {
                        return;
                    }
                    if (QuickSearchComboBar.this.isTextFieldFocusOwner()) {
                        if (!ComboEditor.this.editor.getText().equals("")) {
                            QuickSearchComboBar.this.command.hidePopup();
                        }
                        QuickSearchComboBar.this.displayer.maybeEvaluate(ComboEditor.this.editor.getText());
                    }
                    ComboEditor.this.setItem(null, true);
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    ComboEditor.this.commandKeyPressed(evt);
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        private void setItem(Object anObject, boolean keepText) {
            Issue oldIssue = this.issue;
            if (anObject == null) {
                this.issue = null;
                if (!keepText) {
                    this.editor.setText("");
                }
            } else if (anObject instanceof Issue) {
                this.issue = (Issue)anObject;
                this.ignoreCommandChanges = true;
                if (!keepText) {
                    this.editor.setText(PopupItem.IssueItem.getIssueDescription(this.issue));
                }
                this.ignoreCommandChanges = false;
            }
            if (oldIssue != null || this.issue != null) {
                QuickSearchComboBar.this.getChangeSupport().firePropertyChange(QuickSearchComboBar.EVT_ISSUE_CHANGED, oldIssue, this.issue);
            }
        }

        @Override
        public void setItem(Object anObject) {
            this.setItem(anObject, false);
        }

        @Override
        public Object getItem() {
            return this.issue;
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }

        private void commandKeyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 40) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    QuickSearchComboBar.this.displayer.selectNext();
                    evt.consume();
                }
            } else if (evt.getKeyCode() == 38) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    QuickSearchComboBar.this.displayer.selectPrev();
                    evt.consume();
                }
            } else if (evt.getKeyCode() == 10) {
                if (QuickSearchComboBar.this.displayer.isVisible()) {
                    evt.consume();
                    QuickSearchComboBar.this.invokeSelectedItem();
                }
            } else if (evt.getKeyCode() == 27 && QuickSearchComboBar.this.displayer.isVisible()) {
                QuickSearchComboBar.this.returnFocus();
                QuickSearchComboBar.this.displayer.clearModel();
                evt.consume();
            }
        }
    }
}

