/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.bugtracking.ui.search.FindSupport;
import org.openide.util.NbBundle;

class FindBar
extends JPanel {
    private static final int MAX_SEARCH_MODEL_SIZE = 5;
    private FindSupport support;
    private boolean initialized;
    private DefaultComboBoxModel lastSearchModel;
    private JButton closeButton;
    private JComboBox findCombo;
    private JLabel findLabel;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private JCheckBox highlightResultsChoice;
    private JCheckBox machCaseChoice;
    private JCheckBox regularExpressionChoice;
    private JCheckBox wholeWordsChoice;

    public FindBar(FindSupport support) {
        this.support = support;
        this.initComponents();
        this.lastSearchModel = new DefaultComboBoxModel();
        this.findCombo.setModel(this.lastSearchModel);
        this.findCombo.setSelectedItem("");
        this.initialized = true;
        this.addComboEditorListener();
        InputMap inputMap = this.getInputMap(1);
        String closeKey = "close";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), closeKey);
        this.getActionMap().put(closeKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindBar.this.support.cancel();
            }
        });
    }

    private void addComboEditorListener() {
        Component editor = this.findCombo.getEditor().getEditorComponent();
        if (editor instanceof JTextComponent) {
            JTextComponent tcomp = (JTextComponent)editor;
            tcomp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FindBar.this.support.updatePattern();
                }
            });
        }
    }

    String getPattern() {
        return this.findCombo.getEditor().getItem().toString();
    }

    boolean getMatchCase() {
        return this.machCaseChoice.isSelected();
    }

    boolean getWholeWords() {
        return this.wholeWordsChoice.isSelected();
    }

    boolean getRegularExpression() {
        return this.regularExpressionChoice.isSelected();
    }

    boolean getHighlightResults() {
        return this.highlightResultsChoice.isSelected();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.findCombo.requestFocusInWindow();
    }

    private void initComponents() {
        this.findLabel = new JLabel();
        this.findCombo = new JComboBox();
        this.machCaseChoice = new JCheckBox();
        this.closeButton = new JButton();
        this.wholeWordsChoice = new JCheckBox();
        this.regularExpressionChoice = new JCheckBox();
        this.highlightResultsChoice = new JCheckBox();
        this.findPreviousButton = new JButton();
        this.findNextButton = new JButton();
        this.findLabel.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.findLabel.text"));
        this.findCombo.setEditable(true);
        this.findCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.findComboActionPerformed(evt);
            }
        });
        this.machCaseChoice.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.machCaseChoice.text"));
        this.machCaseChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.machCaseChoiceActionPerformed(evt);
            }
        });
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/ui/resources/find_close.png")));
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusable(false);
        this.closeButton.setMargin(new Insets(2, 1, 0, 1));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.closeButtonActionPerformed(evt);
            }
        });
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FindBar.this.closeButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FindBar.this.closeButtonMouseExited(evt);
            }
        });
        this.wholeWordsChoice.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.wholeWordsChoice.text"));
        this.wholeWordsChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.wholeWordsChoiceActionPerformed(evt);
            }
        });
        this.regularExpressionChoice.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.regularExpressionChoice.text"));
        this.regularExpressionChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.regularExpressionChoiceActionPerformed(evt);
            }
        });
        this.highlightResultsChoice.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.highlightResultsChoice.text"));
        this.highlightResultsChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.highlightResultsChoiceActionPerformed(evt);
            }
        });
        this.findPreviousButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/ui/resources/find_previous.png")));
        this.findPreviousButton.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.findPreviousButton.text"));
        this.findPreviousButton.setBorderPainted(false);
        this.findPreviousButton.setContentAreaFilled(false);
        this.findPreviousButton.setFocusable(false);
        this.findPreviousButton.setMargin(new Insets(2, 1, 0, 1));
        this.findPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.findPreviousButtonActionPerformed(evt);
            }
        });
        this.findPreviousButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FindBar.this.findPreviousButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FindBar.this.findPreviousButtonMouseExited(evt);
            }
        });
        this.findNextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/ui/resources/find_next.png")));
        this.findNextButton.setText(NbBundle.getMessage(FindBar.class, (String)"FindBar.findNextButton.text"));
        this.findNextButton.setBorderPainted(false);
        this.findNextButton.setContentAreaFilled(false);
        this.findNextButton.setFocusable(false);
        this.findNextButton.setMargin(new Insets(2, 1, 0, 1));
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBar.this.findNextButtonActionPerformed(evt);
            }
        });
        this.findNextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FindBar.this.findNextButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FindBar.this.findNextButtonMouseExited(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.findLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findPreviousButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findNextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.machCaseChoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wholeWordsChoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regularExpressionChoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highlightResultsChoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findLabel).addComponent(this.findCombo, -2, -1, -2).addComponent(this.machCaseChoice).addComponent(this.closeButton).addComponent(this.wholeWordsChoice).addComponent(this.regularExpressionChoice).addComponent(this.highlightResultsChoice).addComponent(this.findPreviousButton).addComponent(this.findNextButton)));
    }

    private void closeButtonMouseEntered(MouseEvent evt) {
        this.processMouseEvent(evt, true);
    }

    private void closeButtonMouseExited(MouseEvent evt) {
        this.processMouseEvent(evt, false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.support.cancel();
    }

    private void findComboActionPerformed(ActionEvent evt) {
        if (this.initialized && this.isVisible()) {
            this.updateComboModel();
            this.support.findNext();
        }
    }

    private void machCaseChoiceActionPerformed(ActionEvent evt) {
        this.support.updatePattern();
    }

    private void wholeWordsChoiceActionPerformed(ActionEvent evt) {
        this.support.updatePattern();
    }

    private void regularExpressionChoiceActionPerformed(ActionEvent evt) {
        this.wholeWordsChoice.setEnabled(!this.regularExpressionChoice.isSelected());
        this.support.updatePattern();
    }

    private void highlightResultsChoiceActionPerformed(ActionEvent evt) {
        this.support.switchHighlight(this.highlightResultsChoice.isSelected());
    }

    private void findNextButtonActionPerformed(ActionEvent evt) {
        this.updateComboModel();
        this.support.findNext();
    }

    private void findPreviousButtonActionPerformed(ActionEvent evt) {
        this.updateComboModel();
        this.support.findPrevious();
    }

    private void findPreviousButtonMouseEntered(MouseEvent evt) {
        this.processMouseEvent(evt, true);
    }

    private void findPreviousButtonMouseExited(MouseEvent evt) {
        this.processMouseEvent(evt, false);
    }

    private void findNextButtonMouseEntered(MouseEvent evt) {
        this.processMouseEvent(evt, true);
    }

    private void findNextButtonMouseExited(MouseEvent evt) {
        this.processMouseEvent(evt, false);
    }

    private void processMouseEvent(MouseEvent evt, boolean over) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            JButton button = (JButton)src;
            button.setContentAreaFilled(over);
            button.setBorderPainted(over);
        }
    }

    private void updateComboModel() {
        String pattern = this.getPattern();
        int idx = -1;
        for (int i = 0; i < this.lastSearchModel.getSize(); ++i) {
            if (!pattern.equals(this.lastSearchModel.getElementAt(i))) continue;
            idx = i;
        }
        if (idx != 0) {
            if (idx != -1) {
                this.lastSearchModel.removeElementAt(idx);
            }
            this.lastSearchModel.insertElementAt(pattern, 0);
            if (this.lastSearchModel.getSize() > 5) {
                this.lastSearchModel.removeElementAt(5);
            }
            this.findCombo.setSelectedItem(pattern);
        }
    }
}

