/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.openide.util.NbBundle;

class HookImpl {
    private HookPanel panel;
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final VCSHooksConfig config;
    private String[] supportedIssueInfoVariables;
    private final String[] supportedRevisionVariables;

    HookImpl(VCSHooksConfig config, String[] supportedIssueInfoVariables, String[] supportedRevisionVariables) {
        this.config = config;
        this.supportedIssueInfoVariables = supportedIssueInfoVariables;
        this.supportedRevisionVariables = supportedRevisionVariables;
    }

    public String beforeCommit(File[] files, String msg) throws IOException {
        Repository selectedRepository = this.getSelectedRepository();
        if (files.length == 0) {
            if (selectedRepository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, selectedRepository);
            }
            LOG.warning("calling beforeCommit for zero files");
            return null;
        }
        if (selectedRepository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(files, selectedRepository);
        }
        File file = files[0];
        LOG.log(Level.FINE, "beforeCommit start for {0}", file);
        if (this.isLinkSelected()) {
            VCSHooksConfig.Format format = this.config.getIssueInfoTemplate();
            String formatString = format.getFormat();
            formatString = HookUtils.prepareFormatString(formatString, this.supportedIssueInfoVariables);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for {0}", file);
                return null;
            }
            String issueInfo = new MessageFormat(formatString).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " commit hook issue info ''{0}''", issueInfo);
            msg = format.isAbove() ? issueInfo + "\n" + msg : msg + "\n" + issueInfo;
            return msg;
        }
        return null;
    }

    public void afterCommit(File[] files, String author, String revision, Date date, String message, String hookUsageName, boolean applyPush) {
        if (this.panel == null) {
            LOG.fine("no settings for afterCommit");
            return;
        }
        if (files.length == 0) {
            LOG.warning("calling afterCommit for zero files");
            return;
        }
        File file = files[0];
        LOG.log(Level.FINE, "afterCommit start for {0}", file);
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for {0}", file);
            return;
        }
        this.config.setLink(this.isLinkSelected());
        this.config.setResolve(this.isResolveSelected());
        this.config.setAfterCommit(this.isCommitSelected());
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in afterCommit for {0}", file);
            return;
        }
        String msg = null;
        if (this.isLinkSelected()) {
            String formatString = this.config.getRevisionTemplate().getFormat();
            formatString = HookUtils.prepareFormatString(formatString, this.supportedRevisionVariables);
            msg = new MessageFormat(formatString).format(new Object[]{revision, author, date != null ? CC_DATE_FORMAT.format(date) : "", message}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " afterCommit message ''{0}''", msg);
        }
        LOG.log(Level.FINER, " commit hook message ''{0}'', resolved {1}", new Object[]{msg, this.isResolveSelected()});
        if ((this.isLinkSelected() || this.isResolveSelected()) && this.isCommitSelected()) {
            issue.addComment(msg, this.isResolveSelected());
            issue.open();
        } else if (applyPush) {
            LOG.log(Level.FINER, " commit hook message will be set after push");
            this.config.setPushAction(revision, new VCSHooksConfig.PushOperation(issue.getID(), msg, this.isResolveSelected()));
            LOG.log(Level.FINE, "schedulig issue {0} for file {1}", new Object[]{issue.getID(), file});
        }
        LOG.log(Level.FINE, "afterCommit end for {0}", file);
        VCSHooksConfig.logHookUsage(hookUsageName, this.getSelectedRepository());
    }

    public void afterPush(File[] files, String[] changesets, String hookUsageName) {
        if (files.length == 0) {
            LOG.warning("calling after push for zero files");
            return;
        }
        File file = files[0];
        LOG.log(Level.FINE, "push hook start for {0}", file);
        Repository repo = null;
        for (String changeset : changesets) {
            VCSHooksConfig.PushOperation operation = this.config.popPushAction(changeset);
            if (operation == null) {
                LOG.log(Level.FINE, " no push hook scheduled for {0}", file);
                continue;
            }
            if (repo == null && (repo = BugtrackingOwnerSupport.getInstance().getRepository(file, true)) == null) {
                LOG.log(Level.WARNING, " could not find issue tracker for {0}", file);
                break;
            }
            Issue issue = repo.getIssue(operation.getIssueID());
            if (issue == null) {
                LOG.log(Level.FINE, " no issue found with id {0}", operation.getIssueID());
                continue;
            }
            issue.addComment(operation.getMsg(), operation.isClose());
        }
        LOG.log(Level.FINE, "push hook end for {0}", file);
        VCSHooksConfig.logHookUsage(hookUsageName, this.getSelectedRepository());
    }

    public HookPanel createComponent(File[] files) {
        return this.createComponent(files, null);
    }

    public HookPanel createComponent(File[] files, Boolean afterCommit) {
        File referenceFile;
        LOG.finer("HookImpl.createComponent()");
        if (files.length == 0) {
            referenceFile = null;
            LOG.warning("creating hook component for zero files");
        } else {
            referenceFile = files[0];
        }
        this.panel = new HookPanel(this.config.getLink(), this.config.getResolve(), afterCommit != null ? afterCommit.booleanValue() : this.config.getAfterCommit());
        if (referenceFile != null) {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (File)referenceFile);
        } else {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (boolean)false);
        }
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    private void onShowFormat() {
        FormatPanel p = new FormatPanel(this.config.getRevisionTemplate(), this.config.getDefaultRevisionTemplate(), this.supportedRevisionVariables, this.config.getIssueInfoTemplate(), this.config.getDefaultIssueInfoTemplate(), this.supportedIssueInfoVariables);
        if (BugtrackingUtil.show((JPanel)p, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            this.config.setRevisionTemplate(p.getIssueFormat());
            this.config.setIssueInfoTemplate(p.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private boolean isCommitSelected() {
        return this.panel != null && this.panel.commitRadioButton.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

