/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.mobility.project.ChildKind;
import org.netbeans.api.mobility.project.ProjectChildKeyProvider;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.ConfigurationsNode;
import org.netbeans.modules.mobility.project.ui.ResourcesNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class ProjectRootNodeChildren
extends ChildFactory.Detachable<Object>
implements LookupListener,
ChangeListener,
Runnable {
    private final Map<Object, NodeList> nodeListForKey = Collections.synchronizedMap(new HashMap());
    private final J2MEProject project;
    private volatile Lookup.Result<NodeFactory> res;
    static final String FOREIGN_NODES_PATH = "Projects/org-netbeans-modules-mobility-project/Nodes";
    private Set<NodeList> lists = new HashSet<NodeList>();
    private final Object lock = new Object();
    static final Logger LOGGER = Logger.getLogger(ProjectRootNodeChildren.class.getName());
    volatile boolean cycle = false;

    ProjectRootNodeChildren(J2MEProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNotify() {
        this.cycle = false;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "J2ME Project Root Node Children for " + this.projectString() + " addNotify()");
        }
        Lookup.Result result = Lookups.forPath((String)FOREIGN_NODES_PATH).lookupResult(NodeFactory.class);
        Object object = this.lock;
        synchronized (object) {
            this.res = result;
            this.res.addLookupListener((LookupListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        HashSet<NodeList> s;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "J2ME Project Root Node Children for " + this.projectString() + " removeNotify()");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.res != null) {
                this.res.removeLookupListener((LookupListener)this);
            } else {
                LOGGER.log(Level.SEVERE, "removeNotify called twice or w/o addNotify()!");
            }
            this.res = null;
            s = new HashSet<NodeList>(this.lists);
            this.lists.clear();
        }
        for (NodeList l : s) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "J2ME Project Root Node Children for " + this.projectString() + " detach " + "listener from " + l);
            }
            l.removeChangeListener((ChangeListener)this);
            l.removeNotify();
        }
        this.nodeListForKey.clear();
    }

    protected boolean createKeys(List<Object> toPopulate) {
        boolean addForeignNodes;
        if (this.cycle) {
            RequestProcessor.getDefault().post((Runnable)this, 150);
            this.cycle = false;
            return true;
        }
        ProjectChildKeyProvider provider = (ProjectChildKeyProvider)Lookup.getDefault().lookup(ProjectChildKeyProvider.class);
        if (provider == null) {
            toPopulate.addAll(Arrays.asList(ChildKind.values()));
            addForeignNodes = true;
        } else {
            toPopulate.addAll(provider.getKeys());
            addForeignNodes = toPopulate.contains((Object)ChildKind.Foreign);
        }
        if (addForeignNodes) {
            this.addForeignNodeKeys(toPopulate);
        }
        return true;
    }

    protected Node[] createNodesForKey(Object key) {
        if (key instanceof ChildKind) {
            switch ((ChildKind)((Object)key)) {
                case Configurations: {
                    return new Node[]{this.createConfigurationsNode()};
                }
                case Resources: {
                    return new Node[]{this.createResourcesNode()};
                }
                case Sources: {
                    return this.createSourcesNodes();
                }
                case Foreign: {
                    return new Node[0];
                }
            }
            throw new AssertionError();
        }
        NodeList nl = this.nodeListForKey.get(key);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Foreign nodes created for J2ME Project " + this.projectString() + ": " + key);
        }
        if (nl != null) {
            return new Node[]{nl.node(key)};
        }
        return new Node[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addForeignNodeKeys(List<Object> toPopulate) {
        Lookup.Result<NodeFactory> lkpResult;
        Object object = this.lock;
        synchronized (object) {
            lkpResult = this.res;
        }
        if (lkpResult == null) {
            return;
        }
        this.nodeListForKey.clear();
        HashSet<NodeList> found = new HashSet<NodeList>();
        Object object2 = this.lock;
        synchronized (object2) {
            found.addAll(this.lists);
        }
        HashSet<NodeList> toRemove = new HashSet<NodeList>(this.lists);
        for (NodeFactory f : lkpResult.allInstances()) {
            NodeList nl = f.createNodes((Project)this.project);
            if (!found.contains(nl)) {
                found.add(nl);
                nl.addNotify();
                nl.addChangeListener((ChangeListener)this);
                toRemove.remove(nl);
            }
            for (Object o : nl.keys()) {
                this.nodeListForKey.put(o, nl);
                toPopulate.add(o);
            }
        }
        Object object3 = this.lock;
        synchronized (object3) {
            for (NodeList nl : toRemove) {
                nl.removeChangeListener((ChangeListener)this);
                nl.removeNotify();
            }
            this.lists.removeAll(toRemove);
            this.lists.addAll(found);
        }
    }

    private Node createConfigurationsNode() {
        return new ConfigurationsNode(this.project);
    }

    private Node createResourcesNode() {
        return new ResourcesNode(this.project, null);
    }

    private Node[] createSourcesNodes() {
        Node[] result = new Node[]{};
        Sources src = ProjectUtils.getSources((Project)this.project);
        if (src != null) {
            SourceGroup[] sg = src.getSourceGroups("java");
            result = new Node[sg.length];
            int ix = 0;
            for (SourceGroup group : sg) {
                result[ix++] = PackageView.createPackageView((SourceGroup)group);
            }
        }
        if (result.length == 0) {
            result = new Node[]{new AbstractNode(Children.LEAF)};
            result[0].setDisplayName(NbBundle.getMessage(ProjectRootNodeChildren.class, (String)"LBL_MissingSources"));
        }
        return result;
    }

    public void resultChanged(LookupEvent ev) {
        this.cycle = true;
        this.refresh(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.cycle = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Received state change from " + e.getSource() + " refereshing child nodes");
        }
        this.refresh(true);
    }

    private String projectString() {
        return this.project == null ? "null" : this.project.getProjectDirectory().getPath();
    }

    @Override
    public void run() {
        this.cycle = false;
        this.refresh(true);
    }
}

