/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.MIDletsCacheHelper;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class J2MEProjectGenerator {
    public static final Pattern IMPORT_EXCLUDES = Pattern.compile("^(.*/)?(([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)|([^/]*\\.class)|([^/]*\\.adContent)|([^/]*\\.jad)|([^/]*\\.nbattrs))$");
    public static final Pattern IMPORT_SRC_EXCLUDES = Pattern.compile("^(.*/)?(([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)|([^/]*\\.class)|([^/]*\\.adContent)|([^/]*\\.jad)|([^/]*\\.jar)|([^/]*\\.zip)|([^/]*\\.nbattrs))$");
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String EMPTY = "";
    private static final HashSet<String> KNOWN_ATTRIBUTES = new HashSet<String>(Arrays.asList("MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version", "MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"));
    private static final String PRIVATE_PREFIX = "private.";
    private static final String SRC = "src";
    private static final String NAME = "name";
    private static final String MIDLET = "MIDlet-";

    private J2MEProjectGenerator() {
    }

    public static AntProjectHelper createProjectFromSources(File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, final String sourcesLocation, final String jadLocation) throws IOException {
        return J2MEProjectGenerator.createProject(projectLocation, name, platform, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList configurations) throws IOException {
                J2MEProjectGenerator.setSourceRoot(helper, J2MEProjectGenerator.getReferenceHelper(project), sourcesLocation);
                J2MEProjectGenerator.loadJadManifest(helper, new File(jadLocation));
                J2MEProjectGenerator.fillMissingMIDlets(project, helper);
            }
        });
    }

    public static AntProjectHelper createProjectFromSuite(File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, final String suite, final String sources) throws IOException {
        return J2MEProjectGenerator.createProject(projectLocation, name, platform, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList configurations) throws IOException {
                J2MEProjectGenerator.setSourceRoot(helper, J2MEProjectGenerator.getReferenceHelper(project), sources);
                J2MEProjectGenerator.loadSettingFromSuite(helper, new File(suite));
                J2MEProjectGenerator.fillMissingMIDlets(project, helper);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(File source, File target, Pattern filter) throws IOException {
        if (J2MEProjectGenerator.isParent(source, target)) {
            return;
        }
        File[] files = source.listFiles();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (filter.matcher(file.getAbsolutePath().replace('\\', '/')).matches()) continue;
                if (file.isDirectory()) {
                    File subdir = new File(target, file.getName());
                    subdir.mkdirs();
                    J2MEProjectGenerator.copyFolder(file, subdir, filter);
                    continue;
                }
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    fis = new FileInputStream(file);
                    fos = new FileOutputStream(new File(target, file.getName()));
                    FileUtil.copy((InputStream)fis, (OutputStream)fos);
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    public static AntProjectHelper createProjectFromWtkProject(File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, final String appLocation) throws IOException {
        return J2MEProjectGenerator.createProject(projectLocation, name, platform, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList configurations) throws IOException {
                ReferenceHelper refHelper = J2MEProjectGenerator.getReferenceHelper(project);
                FileObject src = projectLocation.createFolder(J2MEProjectGenerator.SRC);
                File srcFile = FileUtil.toFile((FileObject)src);
                FileObject lib = projectLocation.createFolder("lib");
                File libFile = FileUtil.toFile((FileObject)lib);
                FileObject res = projectLocation.createFolder("res");
                File resFile = FileUtil.toFile((FileObject)res);
                J2MEProjectGenerator.copyJavaFolder(new File(appLocation, J2MEProjectGenerator.SRC), srcFile, IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder(new File(appLocation, "res"), resFile, IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder(new File(appLocation, "lib"), libFile, IMPORT_EXCLUDES);
                File jad = J2MEProjectGenerator.findWtkJadFile(appLocation);
                File mf = J2MEProjectGenerator.findWtkManifestFile(appLocation);
                J2MEProjectGenerator.loadJadAndManifest(helper, jad, mf);
                J2MEProjectGenerator.loadWTKProperties(helper, projectLocationFile);
                File[] files = libFile.listFiles();
                File[] libs = null;
                if (files == null) {
                    libs = new File[1];
                } else {
                    libs = new File[files.length + 1];
                    System.arraycopy(files, 0, libs, 1, files.length);
                }
                libs[0] = resFile;
                J2MEProjectGenerator.loadLibraries(helper, refHelper, libs);
                J2MEProjectGenerator.fillMissingMIDlets(project, helper);
            }
        });
    }

    public static AntProjectHelper duplicateProject(J2MEProject oldProject, File _projectLocation, String name, boolean copySources) throws IOException {
        FileObject projectLocation = J2MEProjectGenerator.createProjectLocation(_projectLocation);
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)projectLocation, (String)"org.netbeans.modules.kjava.j2meproject");
        AntProjectHelper oldHelper = (AntProjectHelper)oldProject.getLookup().lookup(AntProjectHelper.class);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2me-project", NAME);
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2me-project", "minimum-ant-version");
        minant.appendChild(doc.createTextNode("1.6"));
        data.appendChild(minant);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = oldHelper.getProperties("nbproject/project.properties").cloneProperties();
        EditableProperties ep2 = oldHelper.getProperties("nbproject/private/private.properties").cloneProperties();
        ep.setProperty("src.dir", SRC);
        ep.setProperty(NAME, name);
        File projDir = FileUtil.toFile((FileObject)projectLocation);
        assert (projDir != null) : "FileUtil.toFile convertion failed for: " + projectLocation;
        for (String key : ep.keySet()) {
            String newPath;
            String pValue;
            if (!key.startsWith("file.reference.") && !key.startsWith("project.") || (pValue = ep.getProperty(key)).indexOf("${") >= 0) continue;
            File f = oldHelper.resolveFile(pValue);
            if (CollocationQuery.areCollocated((File)projDir, (File)f) && (newPath = PropertyUtils.relativizeFile((File)projDir, (File)f)) != null) {
                ep.put(key, newPath);
                continue;
            }
            ep.remove((Object)key);
            ep2.put(key, f.getAbsolutePath());
        }
        h.putProperties("nbproject/project.properties", ep);
        h.putProperties("nbproject/private/private.properties", ep2);
        Project prj = ProjectManager.getDefault().findProject(projectLocation);
        ProjectConfigurationsHelper oldCfgHlp = (ProjectConfigurationsHelper)oldProject.getLookup().lookup(ProjectConfigurationsHelper.class);
        ProjectConfiguration[] cfgs = oldCfgHlp.getConfigurations().toArray(new ProjectConfiguration[0]);
        ProjectConfigurationsHelper cfgHlp = (ProjectConfigurationsHelper)prj.getLookup().lookup(ProjectConfigurationsHelper.class);
        for (int a = 0; a < cfgs.length; ++a) {
            if (oldCfgHlp.getDefaultConfiguration().equals(cfgs[a])) continue;
            cfgHlp.addConfiguration(cfgs[a].getDisplayName());
        }
        ReferenceHelper oldRefHelper = (ReferenceHelper)oldProject.getLookup().lookup(ReferenceHelper.class);
        ReferenceHelper refHelper = (ReferenceHelper)prj.getLookup().lookup(ReferenceHelper.class);
        ReferenceHelper.RawReference[] rawRef = oldRefHelper.getRawReferences();
        if (rawRef != null) {
            for (int i = 0; i < rawRef.length; ++i) {
                refHelper.addRawReference(rawRef[i]);
            }
        }
        if (prj instanceof J2MEProject) {
            ((J2MEProject)prj).hookNewProjectCreated();
        }
        FileObject src = projectLocation.createFolder(SRC);
        if (copySources) {
            J2MEProjectGenerator.copyJavaFolder(oldHelper.resolveFile(oldHelper.getStandardPropertyEvaluator().getProperty("src.dir")), FileUtil.toFile((FileObject)src), IMPORT_SRC_EXCLUDES);
        }
        J2MEProjectGenerator.refreshProject(projectLocation, src);
        ProjectManager.getDefault().saveProject(prj);
        return h;
    }

    public static AntProjectHelper createNewProject(File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, Collection<DataObject> createHelloMIDlet, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> cfgTemplates) throws IOException {
        return J2MEProjectGenerator.createNewProject(projectLocation, name, platform, createHelloMIDlet, cfgTemplates, false);
    }

    public static AntProjectHelper createNewProject(File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, Collection<DataObject> createHelloMIDlet, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> cfgTemplates, boolean library) throws IOException {
        return J2MEProjectGenerator.createProject(projectLocation, name, platform, new NewProjectGeneratorCallback(createHelloMIDlet, cfgTemplates, library));
    }

    public static AntProjectHelper createProjectFromTemplate(final FileObject template, File projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform) throws IOException {
        return J2MEProjectGenerator.createProject(projectLocation, name, platform, new ProjectGeneratorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList<String> configurations) throws IOException {
                FileObject src = null;
                if (template.getExt().endsWith("zip")) {
                    File metaInfDir;
                    File projectPropertiesFile;
                    J2MEProjectGenerator.unzip(template.getInputStream(), projectLocationFile);
                    File jadFile = Utils.findAnyFile(projectLocationFile.listFiles(), "jad");
                    if (jadFile != null) {
                        J2MEProjectGenerator.loadJadManifest(helper, jadFile);
                        jadFile.delete();
                    }
                    if ((projectPropertiesFile = new File(metaInfDir = new File(projectLocationFile, "META-INF"), "project.properties")).exists() && projectPropertiesFile.canRead()) {
                        Properties props = new Properties();
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(projectPropertiesFile);
                            props.load(fis);
                            Enumeration<Object> e = props.keys();
                            while (e.hasMoreElements()) {
                                String name = (String)e.nextElement();
                                if (!name.startsWith("configs.")) continue;
                                int i = (name = name.substring("configs.".length())).indexOf(46);
                                if (i >= 0) {
                                    name = name.substring(0, i);
                                }
                                if (configurations.contains(name)) continue;
                                configurations.add(name);
                            }
                            J2MEProjectGenerator.setProperties(helper, props);
                        }
                        finally {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        J2MEProjectGenerator.deleteAll(metaInfDir);
                    }
                    projectLocation.refresh(false);
                } else {
                    src = projectLocation.createFolder(J2MEProjectGenerator.SRC);
                }
                J2MEProjectGenerator.refreshProject(projectLocation, src);
            }
        });
    }

    public static AntProjectHelper createProject(File _projectLocation, String name, PlatformSelectionPanel.PlatformDescription platform, ProjectGeneratorCallback callback) throws IOException {
        ProjectConfigurationsHelper confs;
        FileObject projectLocation = J2MEProjectGenerator.createProjectLocation(_projectLocation);
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)projectLocation, (String)"org.netbeans.modules.kjava.j2meproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2me-project", NAME);
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2me-project", "minimum-ant-version");
        minant.appendChild(doc.createTextNode("1.6"));
        data.appendChild(minant);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        EditableProperties priv = h.getProperties("nbproject/private/private.properties");
        for (ProjectPropertiesDescriptor p : Lookup.getDefault().lookup(new Lookup.Template(ProjectPropertiesDescriptor.class)).allInstances()) {
            for (PropertyDescriptor d : p.getPropertyDescriptors()) {
                if (d.getDefaultValue() == null) continue;
                (d.isShared() ? ep : priv).setProperty(d.getName(), d.getDefaultValue());
            }
        }
        ep.setProperty("build.root.dir", "build");
        ep.setProperty("dist.root.dir", "dist");
        ep.setProperty(NAME, name);
        ep.setProperty("preprocessed.dir", "${build.dir}/preprocessed");
        ep.setProperty("build.classes.dir", "${build.dir}/compiled");
        ep.setProperty("obfuscator.srcjar", "${build.dir}/before-obfuscation.jar");
        ep.setProperty("obfuscator.destjar", "${build.dir}/obfuscated.jar");
        ep.setProperty("obfuscated.classes.dir", "${build.dir}/obfuscated");
        ep.setProperty("preverify.sources.dir", "${build.dir}/preverifysrc");
        ep.setProperty("preverify.classes.dir", "${build.dir}/preverified");
        String usablePropertyName = PropertyUtils.getUsablePropertyName((String)name);
        ep.setProperty("dist.jar", usablePropertyName + ".jar");
        ep.setProperty("dist.jad", usablePropertyName + ".jad");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/doc");
        ep.setProperty("deployment.copy.target", "deploy");
        ep.setProperty("javac.encoding", FileEncodingQuery.getDefaultEncoding().name());
        ep.setProperty("manifest.is.liblet", FALSE);
        HashMap<String, String> manifestOthers = new HashMap<String, String>();
        manifestOthers.put("MIDlet-Name", name);
        manifestOthers.put("MIDlet-Vendor", "Vendor");
        manifestOthers.put("MIDlet-Version", "1.0");
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.others", manifestOthers);
        if (platform != null) {
            ep.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)platform.platform, (J2MEPlatform.Device)platform.device, (String)platform.configuration, (String)platform.profile));
        } else {
            ep.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)J2MEProjectGenerator.findPlatform(null), null, null, null));
        }
        priv.setProperty("netbeans.user", System.getProperty("netbeans.user"));
        h.putProperties("nbproject/project.properties", ep);
        h.putProperties("nbproject/private/private.properties", priv);
        File projectLocationFile = FileUtil.toFile((FileObject)projectLocation);
        assert (projectLocationFile != null) : "FileUtil.toFile convertion failed for: " + projectLocation;
        ArrayList<String> configurations = new ArrayList<String>();
        Project prj = ProjectManager.getDefault().findProject(projectLocation);
        ProjectManager.getDefault().saveProject(prj);
        if (callback != null) {
            callback.doPostGeneration(prj, h, projectLocation, projectLocationFile, configurations);
        }
        if (!configurations.isEmpty() && (confs = (ProjectConfigurationsHelper)prj.getLookup().lookup(ProjectConfigurationsHelper.class)) != null) {
            for (int a = 0; a < configurations.size(); ++a) {
                String conf = configurations.get(a);
                confs.addConfiguration(conf);
            }
        }
        if (prj instanceof J2MEProject) {
            ((J2MEProject)prj).hookNewProjectCreated();
        }
        ProjectManager.getDefault().saveProject(prj);
        return h;
    }

    protected static void loadJadManifest(AntProjectHelper helper, File jadManifest) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        J2MEProjectGenerator.loadJadManifest(map, jadManifest);
        J2MEProjectGenerator.loadPropertiesFromMap(helper, map, map);
    }

    public static void loadJadManifest(Map<String, String> map, File jadManifest) throws IOException {
        if (!(jadManifest.exists() && jadManifest.isFile() && jadManifest.canRead())) {
            return;
        }
        String ext = jadManifest.getName();
        int index = ext.lastIndexOf(46);
        if (index >= 0) {
            ext = ext.substring(index + 1);
        }
        if ("jad".equals(ext.toLowerCase())) {
            J2MEProjectGenerator.loadJad(map, jadManifest);
        } else {
            J2MEProjectGenerator.loadManifest(map, jadManifest);
        }
    }

    protected static void loadJadAndManifest(AntProjectHelper helper, File jad, File manifest) throws IOException {
        HashMap<String, String> jadMap = new HashMap<String, String>();
        HashMap<String, String> manifestMap = new HashMap<String, String>();
        if (jad != null) {
            J2MEProjectGenerator.loadJad(jadMap, jad);
        }
        if (manifest != null) {
            J2MEProjectGenerator.loadManifest(manifestMap, manifest);
        }
        J2MEProjectGenerator.loadPropertiesFromMap(helper, jadMap.isEmpty() ? manifestMap : jadMap, manifestMap.isEmpty() ? jadMap : manifestMap);
    }

    public static void loadJadAndManifest(Map<String, String> map, File jad, File manifest) throws IOException {
        if (jad != null) {
            J2MEProjectGenerator.loadJad(map, jad);
        }
        if (manifest != null) {
            J2MEProjectGenerator.loadManifest(map, manifest);
        }
    }

    private static void removeInvalidProperties(Map<String, String> map) {
        map.remove("MIDlet-Jar-RSA-SHA1");
        map.remove("MIDlet-Jar-Size");
        map.remove("MIDlet-Jar-URL");
        map.remove("MicroEdition-Configuration");
        map.remove("MicroEdition-Profile");
        String CERTIFICATE = "MIDlet-Certificate-{0}-{1}";
        int a = 1;
        while (true) {
            int b = 1;
            while (map.remove(MessageFormat.format("MIDlet-Certificate-{0}-{1}", Integer.toString(a), Integer.toString(b))) != null) {
                ++b;
            }
            if (b <= 1) break;
            ++a;
        }
    }

    protected static void setProperties(AntProjectHelper helper, Map map) {
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ep.putAll(map);
        helper.putProperties("nbproject/project.properties", ep);
    }

    private static void loadPropertiesFromMap(AntProjectHelper helper, Map<String, String> jadMap, Map<String, String> manifestMap) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(jadMap);
        map.putAll(manifestMap);
        J2MEProjectGenerator.removeInvalidProperties(map);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        HashMap<String, String> midlets = new HashMap<String, String>();
        HashMap<String, String> apipermissions = new HashMap<String, String>();
        HashMap<String, String> pushregistry = new HashMap<String, String>();
        HashMap others = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(ep.getProperty("manifest.others"), null, null);
        HashMap<String, String> manifest = new HashMap<String, String>();
        HashMap<String, String> jad = new HashMap<String, String>();
        for (String key : map.keySet()) {
            String value;
            if (key == null || (value = map.get(key)) == null) continue;
            if ("MIDlet-Permissions".equalsIgnoreCase(key)) {
                apipermissions.put(key, value);
                continue;
            }
            if ("MIDlet-Permissions-Opt".equalsIgnoreCase(key)) {
                apipermissions.put(key, value);
                continue;
            }
            if (J2MEProjectGenerator.isNumberedProperty(key, MIDLET)) {
                midlets.put(key, value);
                continue;
            }
            if (J2MEProjectGenerator.isNumberedProperty(key, "MIDlet-Push-")) {
                pushregistry.put(key, value);
                continue;
            }
            if (!jadMap.containsKey(key) && !KNOWN_ATTRIBUTES.contains(key)) {
                manifest.put(key, value);
                continue;
            }
            if (!manifestMap.containsKey(key) && !KNOWN_ATTRIBUTES.contains(key)) {
                jad.put(key, value);
                continue;
            }
            others.put(key, value);
        }
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.midlets", midlets);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.apipermissions", apipermissions);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.pushregistry", pushregistry);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.others", others);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.jad", jad);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.manifest", manifest);
        helper.putProperties("nbproject/project.properties", ep);
    }

    private static boolean isNumberedProperty(String key, String prefix) {
        if (!key.startsWith(prefix)) {
            return false;
        }
        try {
            Integer.parseInt(key.substring(prefix.length()));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void storeManifestProperties(EditableProperties ep, String name, HashMap<String, String> map) {
        ep.setProperty(name, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(map, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJad(Map<String, String> map, File jad) throws IOException {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jad), DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            br = new BufferedReader(new FileReader(jad));
        }
        try {
            String readLine;
            while ((readLine = br.readLine()) != null) {
                int colon;
                if (EMPTY.equals(readLine) || (colon = readLine.indexOf(58)) < 0) continue;
                map.put(readLine.substring(0, colon), readLine.substring(colon + 1).trim());
            }
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadManifest(Map<String, String> map, File manifest) throws IOException {
        FileInputStream fis = new FileInputStream(manifest);
        try {
            Manifest m = new Manifest(fis);
            Iterator<Attributes> it = m.getEntries().values().iterator();
            while (it.hasNext()) {
                J2MEProjectGenerator.putAllAsStrings(map, it.next());
            }
            J2MEProjectGenerator.putAllAsStrings(map, m.getMainAttributes());
            map.remove("Manifest-Version");
            map.remove("Created-By");
        }
        finally {
            fis.close();
        }
    }

    private static void putAllAsStrings(Map<String, String> map, Attributes attrs) {
        for (Map.Entry<Object, Object> en : attrs.entrySet()) {
            map.put(en.getKey().toString(), (String)en.getValue());
        }
    }

    protected static void loadSettingFromSuite(AntProjectHelper helper, File suite) throws IOException {
        Document doc = J2MEProjectGenerator.getDocumentForSuite(suite);
        J2MEProjectGenerator.loadSettingFromSuite(helper, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocumentForSuite(File suite) throws IOException {
        if (!(suite != null && suite.exists() && suite.isFile() && suite.canRead())) {
            return null;
        }
        FileInputStream is = new FileInputStream(suite);
        Document doc = null;
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void warning(SAXParseException e) {
                }
            }, null);
        }
        catch (SAXException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEProjectGenerator.class, (String)"MSG_ProjectGen_CannotParseSuite")));
            Document document = null;
            return document;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {}
        }
        return doc;
    }

    private static void loadSettingFromSuite(AntProjectHelper helper, Document doc) throws IOException {
        if (doc == null) {
            return;
        }
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        HashMap<String, String> midlets = new HashMap<String, String>();
        HashMap<String, String> pushregistry = new HashMap<String, String>();
        HashSet<String> permission = new HashSet<String>();
        HashSet<String> permissionOpt = new HashSet<String>();
        HashMap<String, String> apipermissions = new HashMap<String, String>();
        HashMap others = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(ep.getProperty("manifest.others"), null, null);
        Profile configuration = null;
        Profile profile = null;
        Node root = doc.getFirstChild();
        if ("2.0".equals(J2MEProjectGenerator.getAttributeValue(root, "version"))) {
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if ("attribute".equalsIgnoreCase(node.getNodeName())) {
                    for (Node attributeNode = node.getFirstChild(); attributeNode != null; attributeNode = attributeNode.getNextSibling()) {
                        String name;
                        if ("midlet".equalsIgnoreCase(attributeNode.getNodeName())) {
                            String order = J2MEProjectGenerator.getAttributeValue(attributeNode, "order");
                            String clazz = J2MEProjectGenerator.getAttributeValue(attributeNode, "class");
                            String icon = J2MEProjectGenerator.getAttributeValue(attributeNode, "icon");
                            String name2 = J2MEProjectGenerator.getAttributeValue(attributeNode, NAME);
                            if (order == null || clazz == null || icon == null || name2 == null) continue;
                            midlets.put(MIDLET + order, name2 + ", " + icon + ", " + clazz);
                            continue;
                        }
                        if ("permission".equalsIgnoreCase(attributeNode.getNodeName())) {
                            name = J2MEProjectGenerator.getAttributeValue(attributeNode, NAME);
                            if (name == null) continue;
                            permission.add(name);
                            continue;
                        }
                        if ("permission-opt".equalsIgnoreCase(attributeNode.getNodeName())) {
                            name = J2MEProjectGenerator.getAttributeValue(attributeNode, NAME);
                            if (name == null) continue;
                            permissionOpt.add(name);
                            continue;
                        }
                        if ("required".equalsIgnoreCase(attributeNode.getNodeName()) || "optional".equalsIgnoreCase(attributeNode.getNodeName()) || "user".equalsIgnoreCase(attributeNode.getNodeName()) || "security".equalsIgnoreCase(attributeNode.getNodeName())) {
                            name = J2MEProjectGenerator.getAttributeValue(attributeNode, NAME);
                            String value = J2MEProjectGenerator.getAttributeValue(attributeNode, "value");
                            if (name == null || value == null) continue;
                            others.put(name, value);
                            continue;
                        }
                        if (!"push".equalsIgnoreCase(attributeNode.getNodeName())) continue;
                        String protocol = J2MEProjectGenerator.getAttributeValue(attributeNode, "protocol");
                        String host = J2MEProjectGenerator.getAttributeValue(attributeNode, "host");
                        String clazz = J2MEProjectGenerator.getAttributeValue(attributeNode, "class");
                        String order = J2MEProjectGenerator.getAttributeValue(attributeNode, "order");
                        if (protocol == null || host == null || clazz == null || order == null) continue;
                        midlets.put("MIDlet-Push-" + order, protocol + ", " + clazz + ", " + host);
                    }
                    continue;
                }
                if ("Configuration".equalsIgnoreCase(node.getNodeName())) {
                    configuration = J2MEProjectGenerator.name2profile(J2MEProjectGenerator.getAttributeValue(node, "value"));
                    continue;
                }
                if (!"Profile".equalsIgnoreCase(node.getNodeName())) continue;
                profile = J2MEProjectGenerator.name2profile(J2MEProjectGenerator.getAttributeValue(node, "value"));
            }
        }
        if (!permission.isEmpty()) {
            apipermissions.put("MIDlet-Permissions", J2MEProjectGenerator.hashMapToCommaSeparatedString(permission));
        }
        if (!permissionOpt.isEmpty()) {
            apipermissions.put("MIDlet-Permissions-Opt", J2MEProjectGenerator.hashMapToCommaSeparatedString(permissionOpt));
        }
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.midlets", midlets);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.apipermissions", apipermissions);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.pushregistry", pushregistry);
        J2MEProjectGenerator.removeInvalidProperties(others);
        J2MEProjectGenerator.storeManifestProperties(ep, "manifest.others", others);
        if (configuration != null || profile != null) {
            J2MEPlatform platform;
            Profile[] profiles = new Profile[configuration == null || profile == null ? 1 : 2];
            profiles[0] = configuration;
            if (profile != null) {
                profiles[profiles.length - 1] = profile;
            }
            if ((platform = J2MEProjectGenerator.findPlatform(profiles)) != null) {
                ep.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)platform, null, (String)configuration.toString(), (String)profile.toString()));
            }
        }
        helper.putProperties("nbproject/project.properties", ep);
    }

    private static String hashMapToCommaSeparatedString(HashSet<String> set) {
        StringBuffer res = new StringBuffer();
        boolean first = true;
        for (String o : set) {
            if (o == null) continue;
            res.append(o);
            if (!first) {
                res.append(", ");
                continue;
            }
            first = false;
        }
        return res.toString();
    }

    public static String getAttributeValue(Node node, String attr) {
        try {
            if (node == null) {
                return null;
            }
            if ((node = node.getAttributes().getNamedItem(attr)) == null) {
                return null;
            }
            return node.getNodeValue();
        }
        catch (DOMException e) {
            return null;
        }
    }

    public static File findWtkJadFile(String appLocation) {
        File[] files;
        if (appLocation == null) {
            return null;
        }
        File jad = null;
        File bin = new File(appLocation, "bin");
        if (bin.exists() && bin.isDirectory() && bin.canRead() && (jad = Utils.findSubFile(files = bin.listFiles(), new File(appLocation).getName() + ".jad")) == null) {
            jad = Utils.findAnyFile(files, "jad");
        }
        return jad;
    }

    public static File findWtkManifestFile(String appLocation) {
        File[] files;
        if (appLocation == null) {
            return null;
        }
        File mf = null;
        File bin = new File(appLocation, "bin");
        if (bin.exists() && bin.isDirectory() && bin.canRead() && (mf = Utils.findSubFile(files = bin.listFiles(), "manifest.mf")) == null) {
            mf = Utils.findAnyFile(files, "mf");
        }
        return mf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadWTKProperties(AntProjectHelper helper, File wtkProject) throws IOException {
        J2MEPlatform found;
        File propFile = new File(wtkProject, "project.properties");
        if (!propFile.exists() || !propFile.isFile()) {
            return;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            props.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        Profile configuration = J2MEProjectGenerator.wtkName2profile(props.getProperty("configuration"), "CLDC");
        if (configuration != null && (found = J2MEProjectGenerator.findPlatform(new Profile[]{configuration})) != null) {
            EditableProperties ep = helper.getProperties("nbproject/project.properties");
            ep.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)found, null, (String)configuration.toString(), null));
            helper.putProperties("nbproject/project.properties", ep);
        }
    }

    private static Profile wtkName2profile(String profile, String prefix) {
        if (profile == null) {
            return null;
        }
        if (profile.startsWith(prefix)) {
            if ((profile = profile.substring(prefix.length())).startsWith("-")) {
                profile = profile.substring(1);
            }
            profile = prefix + "-" + profile;
        }
        return J2MEProjectGenerator.name2profile(profile);
    }

    private static Profile name2profile(String name) {
        if (name == null) {
            return null;
        }
        int i = name.indexOf(45);
        try {
            if (i >= 0) {
                return new Profile(name.substring(0, i), new SpecificationVersion(name.substring(i + 1)));
            }
            return new Profile(name, new SpecificationVersion("1.0"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static J2MEPlatform findPlatform(Profile[] profiles) {
        JavaPlatform[] p = profiles != null ? JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, profiles)) : JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i] instanceof J2MEPlatform)) continue;
            return (J2MEPlatform)p[i];
        }
        return null;
    }

    private static FileObject createProjectLocation(File dir) throws IOException {
        File rootF = dir = dir.getCanonicalFile();
        while (rootF != null && !(rootF = rootF.getParentFile()).exists()) {
        }
        if (rootF == null) {
            throw new IOException("Cannot find existing parent from " + dir.toString());
        }
        FileObject dirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)rootF));
        assert (dirFO != null) : "FileObject for " + rootF + "does not exist !";
        if (rootF != dir) {
            String relName = dir.getAbsolutePath().substring(rootF.getAbsolutePath().length());
            if (relName.startsWith(File.separator)) {
                relName = relName.substring(1);
            }
            dirFO = FileUtil.createFolder((FileObject)dirFO, (String)relName);
        }
        dirFO.refresh(false);
        assert (dirFO.isFolder()) : "Not really a dir: " + dir;
        File parent = FileUtil.toFile((FileObject)dirFO);
        if (parent != null) {
            parent = parent.getParentFile();
        }
        if (parent != null) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return dirFO;
    }

    public static void copyJavaFolder(File source, File target, Pattern filter) throws IOException {
        J2MEProjectGenerator.copyJavaFolder(source, target, target, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJavaFolder(File source, File targetRoot, File target, Pattern filter) throws IOException {
        if (source == null || targetRoot == null || target == null) {
            return;
        }
        if (J2MEProjectGenerator.isParent(source, target)) {
            return;
        }
        File[] files = source.listFiles();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (filter.matcher(file.getAbsolutePath().replace('\\', '/')).matches()) continue;
                if (file.isDirectory()) {
                    File subdir = new File(target, file.getName());
                    subdir.mkdirs();
                    J2MEProjectGenerator.copyJavaFolder(file, targetRoot, subdir, filter);
                    continue;
                }
                File targetFile = new File(target, file.getName());
                if (file.getName().toLowerCase().endsWith(".java")) {
                    String classPackage;
                    block37: {
                        classPackage = null;
                        BufferedReader br = null;
                        try {
                            int end;
                            int pos;
                            String line;
                            br = new BufferedReader(new FileReader(file));
                            while (true) {
                                if ((line = br.readLine()) == null) {
                                    break block37;
                                }
                                for (pos = 0; pos < line.length() && line.charAt(pos) == ' '; ++pos) {
                                }
                                if (!line.startsWith("package", pos)) continue;
                                int tmppos = pos += "package".length();
                                while (pos < line.length() && line.charAt(pos) == ' ') {
                                    ++pos;
                                }
                                if (tmppos == pos) continue;
                                for (end = pos; end < line.length() && (Character.isJavaIdentifierPart(line.charAt(end)) || line.charAt(end) == '.'); ++end) {
                                }
                                if (end != pos && (end >= line.length() || Character.isWhitespace(line.charAt(end)) || line.charAt(end) == ';')) break;
                            }
                            classPackage = line.substring(pos, end);
                        }
                        catch (IOException e) {
                        }
                        finally {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                    if (classPackage != null && !EMPTY.equals(classPackage)) {
                        File dir = new File(targetRoot, classPackage.replace('.', File.separatorChar));
                        dir.mkdirs();
                        targetFile = new File(dir, file.getName());
                    }
                }
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    fis = new FileInputStream(file);
                    fos = new FileOutputStream(targetFile);
                    FileUtil.copy((InputStream)fis, (OutputStream)fos);
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    private static boolean isParent(File source, File target) {
        while (target != null) {
            if (source.equals(target)) {
                return true;
            }
            target = target.getParentFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unzip(InputStream source, File targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                File f = new File(targetFolder, ent.getName());
                if (ent.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(f);
                try {
                    FileUtil.copy((InputStream)zip, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    protected static void deleteAll(File directory) {
        File[] files = directory.listFiles();
        for (int a = 0; a < files.length; ++a) {
            File file = files[a];
            if (file.isDirectory()) {
                J2MEProjectGenerator.deleteAll(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    public static void loadLibraries(AntProjectHelper h, ReferenceHelper refHelper, File[] files) {
        StringBuffer libs = null;
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                if (files[a] == null || !files[a].exists()) continue;
                String name = files[a].getName().toLowerCase();
                if (files[a].isFile() && !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                if (libs != null) {
                    libs.append(File.pathSeparatorChar);
                } else {
                    libs = new StringBuffer();
                }
                libs.append(refHelper.createForeignFileReference(FileUtil.normalizeFile((File)files[a]), "anyfile"));
            }
        }
        if (libs == null) {
            return;
        }
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put("libs.classpath", libs.toString());
        h.putProperties("nbproject/project.properties", ep);
    }

    public static void copyMIDletProperty(Project project, AntProjectHelper h, String sourceClass, String targetClass) throws IOException {
        if (sourceClass == null || targetClass == null) {
            return;
        }
        ProjectConfigurationsHelper confHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        ProjectConfiguration[] confs = confHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        String defaultValue = ep.getProperty("manifest.midlets");
        HashMap map = defaultValue != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null) : new HashMap();
        J2MEProjectGenerator.copyMIDletProperty(map, sourceClass, targetClass);
        ep.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(map, null, null));
        for (int i = 0; i < confs.length; ++i) {
            String propertyValue;
            ProjectConfiguration conf = confs[i];
            String confName = conf.getDisplayName();
            String propertyName = VisualPropertySupport.translatePropertyName(confName, "manifest.midlets", false);
            if (propertyName == null || (propertyValue = ep.getProperty(propertyName)) == null) continue;
            map = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null);
            J2MEProjectGenerator.copyMIDletProperty(map, sourceClass, targetClass);
            ep.put(propertyName, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(map, null, null));
        }
        h.putProperties("nbproject/project.properties", ep);
    }

    private static void copyMIDletProperty(HashMap<String, String> map, String sourceClass, String targetClass) {
        String value;
        String newMIDlet = null;
        int a = 1;
        while ((value = map.get(MIDLET + a)) != null) {
            int index = value.lastIndexOf(44);
            if (index >= 0 && sourceClass.equals(value.substring(index + 1).trim())) {
                newMIDlet = value.substring(0, index + 1) + targetClass;
            }
            ++a;
        }
        if (newMIDlet != null) {
            map.put(MIDLET + a, newMIDlet);
        }
    }

    public static void addMIDletProperty(Project project, AntProjectHelper h, String name, String clazz, String icon) throws IOException {
        if (name == null) {
            name = EMPTY;
        }
        if (clazz == null) {
            clazz = EMPTY;
        }
        if (icon == null) {
            icon = EMPTY;
        }
        ProjectConfigurationsHelper confHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        ProjectConfiguration[] confs = confHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        String defaultValue = ep.getProperty("manifest.midlets");
        HashMap map = defaultValue != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null) : new HashMap();
        J2MEProjectGenerator.addMIDletProperty(map, name, clazz, icon);
        ep.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(map, null, null));
        for (int i = 0; i < confs.length; ++i) {
            String propertyValue;
            ProjectConfiguration conf = confs[i];
            String confName = conf.getDisplayName();
            String propertyName = VisualPropertySupport.translatePropertyName(confName, "manifest.midlets", false);
            if (propertyName == null || (propertyValue = ep.getProperty(propertyName)) == null) continue;
            map = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(defaultValue, null, null);
            J2MEProjectGenerator.addMIDletProperty(map, name, clazz, icon);
            ep.put(propertyName, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(map, null, null));
        }
        h.putProperties("nbproject/project.properties", ep);
    }

    private static void addMIDletProperty(Map<String, String> map, String name, String clazz, String icon) {
        int a = 1;
        while (map.containsKey(MIDLET + a)) {
            ++a;
        }
        map.put(MIDLET + a, name + ", " + icon + ", " + clazz);
    }

    public static void refreshProject(FileObject projectLocation, FileObject srcLocation) {
        if (projectLocation != null) {
            projectLocation.refresh(false);
        }
        if (srcLocation != null) {
            srcLocation.refresh();
        }
    }

    protected static void fillMissingMIDlets(final Project project, final AntProjectHelper helper) {
        ReferenceHelper refHelper = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
        ProjectConfigurationsHelper confHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        MIDletScanner scanner = MIDletScanner.getDefault(new J2MEProjectProperties(project, helper, refHelper, confHelper));
        final DefaultComboBoxModel midlets = new DefaultComboBoxModel();
        scanner.scan(midlets, null, null, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MIDletsCacheHelper mHelper = (MIDletsCacheHelper)project.getLookup().lookup(MIDletsCacheHelper.class);
                for (int i = 0; i < midlets.getSize(); ++i) {
                    try {
                        String midlet = (String)midlets.getElementAt(i);
                        if (mHelper.contains(midlet)) continue;
                        J2MEProjectGenerator.addMIDletProperty(project, helper, midlet.substring(midlet.lastIndexOf(46) + 1), midlet, null);
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (project instanceof J2MEProject) {
                    ((J2MEProject)project).hookNewProjectCreated();
                }
                try {
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected static void setSourceRoot(AntProjectHelper helper, ReferenceHelper refHelper, String srcRoot) {
        String ref = refHelper.createForeignFileReference(helper.resolveFile(srcRoot), "anyfile");
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ep.put("src.dir", ref);
        helper.putProperties("nbproject/project.properties", ep);
        J2MEProjectGenerator.refreshProject(helper.getProjectDirectory(), helper.resolveFileObject(srcRoot));
    }

    protected static ReferenceHelper getReferenceHelper(Project p) {
        return (ReferenceHelper)p.getLookup().lookup(ReferenceHelper.class);
    }

    private static class NewProjectGeneratorCallback
    implements ProjectGeneratorCallback,
    Runnable {
        private final Collection<DataObject> createHelloMIDlet;
        private final Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> cfgTemplates;
        private ArrayList<String> configurations;
        private File projectLocationFile;
        private FileObject projectLocation;
        private AntProjectHelper helper;
        private Project project;
        private boolean library;

        public NewProjectGeneratorCallback(Collection<DataObject> createHelloMIDlet, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> cfgTemplates, boolean library) {
            this.createHelloMIDlet = createHelloMIDlet;
            this.cfgTemplates = cfgTemplates;
            this.library = library;
        }

        @Override
        public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList<String> configurations) throws IOException {
            this.project = project;
            assert (project instanceof J2MEProject);
            this.helper = helper;
            this.projectLocation = projectLocation;
            this.projectLocationFile = projectLocationFile;
            this.configurations = configurations;
            this.run();
        }

        @Override
        public void run() {
            try {
                EditableProperties proj;
                String pr;
                FileObject src = this.projectLocation.createFolder(J2MEProjectGenerator.SRC);
                if (this.createHelloMIDlet != null) {
                    DataObject template;
                    FileObject hello = src.createFolder("hello");
                    if (hello == null) {
                        hello = src;
                    }
                    DataFolder helloFolder = DataFolder.findFolder((FileObject)hello);
                    FileObject foTemplate = FileUtil.getConfigFile((String)"Templates/MIDP/HelloMIDlet.java");
                    if (foTemplate == null) {
                        foTemplate = FileUtil.getConfigFile((String)"Templates/MIDP/Midlet.java");
                    }
                    if (foTemplate != null && (template = DataObject.find((FileObject)foTemplate)) != null) {
                        String name = template.getName();
                        if (name.endsWith(".java")) {
                            name = name.substring(0, name.length() - 5);
                        }
                        DataObject fromTemplate = template.createFromTemplate(helloFolder);
                        try {
                            fromTemplate.setValid(false);
                        }
                        catch (PropertyVetoException e) {
                            e.printStackTrace();
                        }
                        fromTemplate = DataObject.find((FileObject)fromTemplate.getPrimaryFile());
                        this.createHelloMIDlet.add(fromTemplate);
                        J2MEProjectGenerator.addMIDletProperty(this.project, this.helper, name, hello != src ? "hello." + name : name, J2MEProjectGenerator.EMPTY);
                        OpenCookie open = (OpenCookie)fromTemplate.getLookup().lookup(OpenCookie.class);
                        if (open != null) {
                            open.open();
                        }
                    }
                }
                if (this.library && (pr = (proj = this.helper.getProperties("nbproject/project.properties")).getProperty("platform.profile")) != null && pr.startsWith("MIDP-3")) {
                    HashMap<String, String> manifestOthers = new HashMap<String, String>();
                    manifestOthers.put("LIBlet-Name", proj.getProperty(J2MEProjectGenerator.NAME));
                    manifestOthers.put("LIBlet-Vendor", "Vendor");
                    manifestOthers.put("LIBlet-Version", "1.0");
                    J2MEProjectGenerator.storeManifestProperties(proj, "manifest.others", manifestOthers);
                    proj.put("manifest.is.liblet", J2MEProjectGenerator.TRUE);
                    this.helper.putProperties("nbproject/project.properties", proj);
                }
                if (this.cfgTemplates != null) {
                    EditableProperties priv = this.helper.getProperties("nbproject/private/private.properties");
                    EditableProperties proj2 = this.helper.getProperties("nbproject/project.properties");
                    for (ProjectConfigurationFactory.ConfigurationTemplateDescriptor desc : this.cfgTemplates) {
                        String cfgName = desc.getCfgName();
                        String prefix = "configs." + cfgName + '.';
                        if (this.configurations.contains(cfgName)) continue;
                        this.configurations.add(cfgName);
                        Map p = desc.getPrivateProperties();
                        if (p != null) {
                            for (Map.Entry en : p.entrySet()) {
                                if (priv.containsKey(en.getKey())) continue;
                                priv.put((String)en.getKey(), (String)en.getValue());
                            }
                        }
                        if ((p = desc.getProjectGlobalProperties()) != null) {
                            for (Map.Entry en : p.entrySet()) {
                                if (proj2.containsKey(en.getKey())) continue;
                                proj2.put((String)en.getKey(), (String)en.getValue());
                            }
                        }
                        if ((p = desc.getProjectConfigurationProperties()) == null) continue;
                        for (Map.Entry en : p.entrySet()) {
                            proj2.put(prefix + (String)en.getKey(), (String)en.getValue());
                        }
                    }
                    this.helper.putProperties("nbproject/private/private.properties", priv);
                    this.helper.putProperties("nbproject/project.properties", proj2);
                }
                J2MEProjectGenerator.refreshProject(this.projectLocation, src);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static interface ProjectGeneratorCallback {
        public void doPostGeneration(Project var1, AntProjectHelper var2, FileObject var3, File var4, ArrayList<String> var5) throws IOException;
    }
}

