/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.ServerDetails;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private AtomicBoolean isValidating = new AtomicBoolean();
    private static Pattern ILLEGAL_WINDOWS_CHARS = Pattern.compile("<|>|\\\"");

    public AddServerLocationPanel(ServerWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
        this.wizard = null;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    private void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel(this.wizardIterator);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                this.wizardIterator.setHttpPort(-1);
                AddServerLocationVisualPanel panel = (AddServerLocationVisualPanel)this.getComponent();
                AddServerLocationVisualPanel.DownloadState downloadState = panel.getDownloadState();
                if (downloadState == AddServerLocationVisualPanel.DownloadState.DOWNLOADING) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                    boolean bl = false;
                    return bl;
                }
                String locationStr = panel.getHk2HomeLocation();
                String string = locationStr = locationStr != null ? locationStr.trim() : null;
                if (locationStr == null || locationStr.length() == 0) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_BlankInstallDir"));
                    boolean bl = false;
                    return bl;
                }
                File installDir = new File(locationStr).getAbsoluteFile();
                File glassfishDir = this.getGlassfishRoot(installDir);
                File domainDir = this.getDefaultDomain(glassfishDir);
                if (!installDir.exists()) {
                    if (!AddServerLocationPanel.isLegalFolder(installDir)) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirInvalid", (Object)locationStr));
                        boolean bl = false;
                        return bl;
                    }
                    if (AddServerLocationPanel.canCreate(installDir)) {
                        if (downloadState == AddServerLocationVisualPanel.DownloadState.AVAILABLE) {
                            panel.updateMessageText(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_NewInstallDirCanBeUsed", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirDoesNotExist", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                        boolean bl = false;
                        return bl;
                    }
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_CannotCreate", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                    boolean bl = false;
                    return bl;
                }
                ServerDetails candidate = this.wizardIterator.isValidInstall(installDir, glassfishDir, this.wizard);
                if (null == candidate) {
                    String errMsg = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)FileUtil.normalizeFile((File)installDir).getPath());
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)errMsg);
                    boolean bl = false;
                    return bl;
                }
                if (!AddServerLocationPanel.isRegisterableDomain(domainDir)) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DefaultDomainInvalid", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                } else {
                    Util.readServerConfiguration(domainDir, this.wizardIterator);
                    if (installDir.equals(glassfishDir)) {
                        installDir = glassfishDir.getParentFile();
                    }
                    this.wizardIterator.setInstallRoot(installDir.getAbsolutePath());
                    this.wizardIterator.setGlassfishRoot(glassfishDir.getAbsolutePath());
                    String uri = this.wizardIterator.formatUri("localhost", this.wizardIterator.getAdminPort(), this.wizardIterator.getTargetValue(), domainDir.getParentFile().getAbsolutePath(), domainDir.getName());
                    if (-1 == this.wizardIterator.getHttpPort()) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                        boolean bl = false;
                        return bl;
                    }
                    if (-1 == this.wizardIterator.getAdminPort()) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                        boolean bl = false;
                        return bl;
                    }
                    if (this.wizardIterator.hasServer(uri)) {
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_DefaultDomainExists", (Object)AddServerLocationPanel.getSanitizedPath(installDir), (Object)"domain1"));
                        this.wizardIterator.setHttpPort(-1);
                    } else {
                        String statusText = panel.getStatusText();
                        if (statusText != null && statusText.length() > 0) {
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)statusText);
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", null);
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_NextForSpecial", (Object)((Object)candidate)));
                    }
                }
                if (installDir.equals(glassfishDir)) {
                    installDir = glassfishDir.getParentFile();
                }
                this.wizardIterator.setInstallRoot(installDir.getAbsolutePath());
                this.wizardIterator.setGlassfishRoot(glassfishDir.getAbsolutePath());
                this.wizardIterator.setDomainLocation(domainDir.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return false;
    }

    private static String getSanitizedPath(File dir) {
        return FileUtil.normalizeFile((File)dir).getPath();
    }

    private static boolean isLegalFolder(File installDir) {
        return AddServerLocationPanel.getCanonicalFile(installDir) != null && (!Utilities.isWindows() || !ILLEGAL_WINDOWS_CHARS.matcher(installDir.getPath()).find());
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            return null;
        }
    }

    static boolean canCreate(File dir) {
        if (dir.exists()) {
            return false;
        }
        while (dir != null && !dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir != null ? dir.canRead() && Utils.canWrite(dir) : false;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getHttpPort() != -1;
    }

    static boolean isRegisterableDomain(File domainDir) {
        File testFile = new File(domainDir, "logs");
        if (!testFile.exists()) {
            testFile = domainDir;
        }
        return Utils.canWrite(testFile) && Util.readServerConfiguration(domainDir, null);
    }

    private File getGlassfishRoot(File installDir) {
        File glassfishDir = new File(installDir, "glassfish");
        if (!glassfishDir.exists()) {
            glassfishDir = installDir;
        }
        return glassfishDir;
    }

    private File getDefaultDomain(File glassfishDir) {
        File domainsDir;
        File[] candidates;
        File retVal = new File(glassfishDir, "domains" + File.separator + "domain1");
        if (!AddServerLocationPanel.isRegisterableDomain(retVal) && null != (candidates = (domainsDir = new File(glassfishDir, "domains")).listFiles()) && candidates.length > 0) {
            for (File c : candidates) {
                if (!AddServerLocationPanel.isRegisterableDomain(c)) continue;
                retVal = c;
                break;
            }
        }
        return retVal;
    }
}

