/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.test.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.java.hints.declarative.test.TestParser;
import org.netbeans.modules.java.hints.declarative.test.TestPerformer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class DeclarativeHintsTestBase
extends NbTestCase {
    private final FileObject hintFile;
    private final FileObject testFile;
    private final TestParser.TestCase test;

    public DeclarativeHintsTestBase() {
        super(null);
        throw new IllegalStateException();
    }

    public DeclarativeHintsTestBase(FileObject hintFile, FileObject testFile, TestParser.TestCase test) {
        super(FileUtil.getFileDisplayName((FileObject)testFile) + "/" + test.getName());
        this.hintFile = hintFile;
        this.testFile = testFile;
        this.test = test;
    }

    protected void setUp() throws Exception {
        this.clearWorkDir();
        System.setProperty("netbeans.user", this.getWorkDir().getAbsolutePath());
        super.setUp();
    }

    public static TestSuite suite(Class<?> clazz) {
        return DeclarativeHintsTestBase.suite(clazz, ".*");
    }

    public static TestSuite suite(Class<?> clazz, String filePattern) {
        NbTestSuite result = new NbTestSuite();
        Pattern patt = Pattern.compile(filePattern);
        for (String test : DeclarativeHintsTestBase.listTests(clazz)) {
            if (!patt.matcher(test).matches()) continue;
            URL testURL = DeclarativeHintsTestBase.class.getClassLoader().getResource(test);
            DeclarativeHintsTestBase.assertNotNull((Object)testURL);
            FileObject testFO = URLMapper.findFileObject((URL)testURL);
            DeclarativeHintsTestBase.assertNotNull((Object)testFO);
            String hint = test.substring(0, test.length() - ".test".length()) + ".hint";
            URL hintURL = DeclarativeHintsTestBase.class.getClassLoader().getResource(hint);
            DeclarativeHintsTestBase.assertNotNull((Object)hintURL);
            FileObject hintFO = URLMapper.findFileObject((URL)hintURL);
            DeclarativeHintsTestBase.assertNotNull((Object)hintFO);
            try {
                for (TestParser.TestCase tc : TestParser.parse((String)testFO.asText("UTF-8"))) {
                    result.addTest((Test)new DeclarativeHintsTestBase(hintFO, testFO, tc));
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }

    protected void runTest() throws Throwable {
        Map result = TestPerformer.performTest((FileObject)this.hintFile, (FileObject)this.testFile, (TestParser.TestCase[])new TestParser.TestCase[]{this.test}, (AtomicBoolean)new AtomicBoolean());
        Collection actualResults = (Collection)result.get(this.test);
        DeclarativeHintsTestBase.assertNotNull((Object)actualResults);
        DeclarativeHintsTestBase.assertEquals(Arrays.asList(this.test.getResults()), (Object)actualResults);
    }

    private static Collection<String> listTests(Class<?> clazz) {
        File dirOrArchive = FileUtil.archiveOrDirForURL((URL)clazz.getProtectionDomain().getCodeSource().getLocation());
        DeclarativeHintsTestBase.assertTrue((boolean)dirOrArchive.exists());
        if (dirOrArchive.isFile()) {
            return DeclarativeHintsTestBase.listTestsFromJar(dirOrArchive);
        }
        LinkedList<String> result = new LinkedList<String>();
        DeclarativeHintsTestBase.listTestsFromFilesystem(dirOrArchive, "", result);
        return result;
    }

    private static Collection<String> listTestsFromJar(File archive) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            JarFile jf = new JarFile(archive);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".test")) continue;
                result.add(entry.getName());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    private static void listTestsFromFilesystem(File file, String prefix, Collection<String> output) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                DeclarativeHintsTestBase.listTestsFromFilesystem(f, (prefix.length() > 0 ? prefix + "/" : "") + f.getName(), output);
            }
        } else if (file.getName().endsWith(".test")) {
            output.add(prefix);
        }
    }
}

