/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.tomcat.TomcatIntegrationPanel;
import org.openide.util.NbBundle;

public abstract class AbstractTomcatIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final String PROFILED_TOMCAT_CONSOLE_STRING = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ProfiledTomcatConsoleString");
    private static final String MANUAL_REMOTE_STEP3_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualRemoteStep3Msg");
    private static final String MANUAL_REMOTE_STEP4_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualRemoteStep4Msg");
    private static final String MANUAL_REMOTE_STEP5_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualRemoteStep5Msg");
    private static final String MANUAL_REMOTE_STEP6_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualRemoteStep6Msg");
    private static final String PATH_TO_JVM_DIR_TEXT = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_PathToJvmDirText");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP1_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDirectDynamicStep1Msg");
    private static final String MANUAL_DIRECT_STEP2_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDirectStep2Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP3_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDirectDynamicStep3Msg");
    private static final String MANUAL_DIRECT_STEP4_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDirectStep4Msg");
    private static final String MANUAL_DYNAMIC_STEP2_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDynamicStep2Msg");
    private static final String MANUAL_DYNAMIC_STEP4_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_ManualDynamicStep4Msg");
    private static final String DYNAMIC_WARNING_MESSAGE = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_DynamicWarningMessage");
    private static final String ADDITIONAL_STEPS_STEP1_DIRECT_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsStep1DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsStep1DynamicMsg");
    private static final String ADDITIONAL_STEPS_STEP2_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP3_DIRECT_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsStep3DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsStep3DynamicPidMsg");
    private static final String ADDITIONAL_STEPS_AUTO_START_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_AdditionalStepsAutoStartMsg");
    private static final String INTEGR_REVIEW_STEP1_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_IntegrReviewStep1Msg");
    protected static final String INTEGR_REVIEW_STEP2_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_IntegrReviewStep2Msg");
    private static final String VALIDATION_DIRNOEXIST_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_PathNotExistsMsg");
    private static final String VALIDATION_HOME_INVALID_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_InvalidCatalinaHomeMsg");
    private static final String VALIDATION_BASE_INVALID_MSG = NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"TomcatIntegrationProvider_InvalidCatalinaBaseMsg");
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "rem Guess CATALINA_HOME";
    private static final String INSERTION_POINT_NOWIN_1_STRING = "# OS specific support.";
    private static final String INSERTION_POINT_2_STRING = "Get remaining unshifted";
    private static final String CATALINA_MOD_EXT_STRING = "_nbprofiler";
    private static final String CATALINA_HOME_VAR_STRING = "CATALINA_HOME";
    private static final String CATALINA_BASE_VAR_STRING = "CATALINA_BASE";
    private SettingsPersistor persistor;
    private String catalinaBase = "";

    public AbstractTomcatIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep(NbBundle.getMessage(AbstractTomcatIntegrationProvider.class, (String)"AttachWizard_LocateRequiredFilesString"), (WizardScreen)new TomcatIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "TomcatIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties settings) {
                String javaPlatform = settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", "");
                if (javaPlatform != null && javaPlatform.length() > 0) {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(javaPlatform);
                } else {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(TargetPlatformEnum.JDK5.toString());
                }
                AbstractTomcatIntegrationProvider.this.setInstallationPath(settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                AbstractTomcatIntegrationProvider.this.setCatalinaBase(settings.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", ""));
                if (AbstractTomcatIntegrationProvider.this.getInstallationPath() == null || AbstractTomcatIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setInstallationPath(AbstractTomcatIntegrationProvider.this.getDefaultInstallationPath());
                }
                if (AbstractTomcatIntegrationProvider.this.getCatalinaBase() == null || AbstractTomcatIntegrationProvider.this.getCatalinaBase().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setCatalinaBase(AbstractTomcatIntegrationProvider.this.getDefaultCatalinaBase());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties settings = new Properties();
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractTomcatIntegrationProvider.this.getTargetJava());
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractTomcatIntegrationProvider.this.getInstallationPath());
                settings.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", AbstractTomcatIntegrationProvider.this.getCatalinaBase());
                return settings;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean automation) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            hints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DIRECT_MSG, this.getModifiedScriptPath(targetOS, true)));
        } else {
            hints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG, this.getModifiedScriptPath(targetOS, true), ""));
        }
        hints.addStep(ADDITIONAL_STEPS_STEP2_MSG);
        if (attachSettings.isDirect()) {
            hints.addStep(ADDITIONAL_STEPS_STEP3_DIRECT_MSG);
        } else {
            hints.addStep(ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG);
            hints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        }
        hints.addHint(ADDITIONAL_STEPS_AUTO_START_MSG);
        return hints;
    }

    public void setCatalinaBase(String path) {
        this.catalinaBase = path;
    }

    public String getCatalinaBase() {
        return this.catalinaBase;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        hints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP1_MSG, this.getScriptPath(targetOS, true), this.getModifiedScriptPath(targetOS, true), targetOS));
        hints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + "<br>" + (this.catalinaBase != null && this.catalinaBase.length() > 0 ? IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + "<br>" : "") + (attachSettings.isDirect() ? IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())) + "<br>" : "")));
        return hints;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isRemote()) {
            return this.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings);
        }
        return this.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings);
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public ValidationResult validateCatalinaBase(String path) {
        if (path == null || path.length() == 0) {
            return new ValidationResult(true);
        }
        if (!new File(path).exists()) {
            return new ValidationResult(false, VALIDATION_DIRNOEXIST_MSG);
        }
        if (!this.validateCatalinaBasePath(path)) {
            return new ValidationResult(false, VALIDATION_BASE_INVALID_MSG);
        }
        return new ValidationResult(true);
    }

    public ValidationResult validateInstallation(String targetOS, String path) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        if (!new File(path).exists()) {
            return new ValidationResult(false, VALIDATION_DIRNOEXIST_MSG);
        }
        if (!new File(path + separator + "bin" + separator + this.getCatalinaScriptName() + ext).exists()) {
            return new ValidationResult(false, VALIDATION_HOME_INVALID_MSG);
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected abstract String getCatalinaScriptName();

    protected ScriptHeaderModifier getHeaderModifier(String targetOS) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)targetOS));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), "catalina", IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MessageFormat.format(MANUAL_DIRECT_STEP2_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()))));
        hints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MANUAL_DIRECT_STEP4_MSG);
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        return hints;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP2_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        hints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MANUAL_DYNAMIC_STEP4_MSG);
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        hints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return hints;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = new IntegrationProvider.IntegrationHints();
        hints.addStep(this.getManualRemoteStep1(targetOS));
        hints.addStep(this.getManualRemoteStep2(targetOS));
        hints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_CATALINA_HOME", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())), this.REMOTE_ABSOLUTE_PATH_HINT));
        hints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP5_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        hints.addStep(MANUAL_REMOTE_STEP6_MSG);
        hints.addHint(this.REDUCE_OVERHEAD_MSG);
        return hints;
    }

    protected String getModifiedScriptPath(String targetOS, boolean useQuotas) {
        return this.getCatalinaScriptPath(targetOS, CATALINA_MOD_EXT_STRING, useQuotas);
    }

    protected String getScriptPath(String targetOS, boolean useQuotas) {
        return this.getCatalinaScriptPath(targetOS, "", useQuotas);
    }

    protected String getWinConsoleString() {
        return PROFILED_TOMCAT_CONSOLE_STRING;
    }

    protected void generateCommands(String targetOS, Collection commandsArray) {
        commandsArray.add(this.getModifiedScriptPath(targetOS, false));
        commandsArray.add("run");
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS) && !IntegrationUtils.PLATFORM_MAC_OS.equals(targetOS)) {
            commandsArray.add(">&1");
        }
    }

    protected void modifyScriptFileForDirectAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        int insertionPoint2 = buffer.indexOf(IntegrationUtils.getScriptCommentSign((String)targetOS) + " " + INSERTION_POINT_2_STRING);
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportCatalinaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + lineBreak;
        String exportCatalinaBase = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + lineBreak;
        String exportNativeLibraries = IntegrationUtils.getAddProfilerLibrariesToPathString((String)targetOS, (String)this.getTargetJava(), (boolean)false, (boolean)false) + lineBreak;
        String exportCatalinaOpts = this.getJavaOptions(targetOS, this.getTargetJava(), commPort, ' ');
        int currentOffset = 0;
        buffer.insert(insertionPoint1 + currentOffset, exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), exportCatalinaHome);
        currentOffset += exportCatalinaHome.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            buffer.insert(insertionPoint1 + currentOffset, exportCatalinaBase);
            currentOffset += exportCatalinaBase.length();
        }
        int catalinaOptsInsertionPoint = IntegrationUtils.isWindowsPlatform((String)targetOS) ? insertionPoint2 : insertionPoint1;
        buffer.insert(catalinaOptsInsertionPoint + currentOffset, exportCatalinaOpts);
    }

    protected void modifyScriptFileForDynamicAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        String header = IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportCatalinaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + lineBreak;
        String exportCatalinaBase = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), exportCatalinaHome);
        currentOffset += exportCatalinaHome.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            buffer.insert(insertionPoint1 + currentOffset, exportCatalinaBase);
        }
    }

    private String getCatalinaScriptPath(String targetOS, String scriptPostfix, boolean useQuotas) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        String quotas = "";
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            quotas = "\"";
        }
        StringBuffer path = new StringBuffer();
        path.append(this.getInstallationPath());
        if (!this.getInstallationPath().endsWith(separator)) {
            path.append(separator);
        }
        path.append("bin").append(separator).append(this.getCatalinaScriptName()).append(scriptPostfix).append(ext);
        if (useQuotas && path.indexOf(" ") > -1) {
            path.insert(0, quotas);
            path.append(quotas);
        }
        return path.toString();
    }

    private String getDefaultCatalinaBase() {
        String catalinaBase = "";
        try {
            File catalinaBaseDir;
            String catalinaBaseEnv = System.getenv(CATALINA_BASE_VAR_STRING);
            if (catalinaBaseEnv != null && catalinaBaseEnv.length() > 1 && (catalinaBaseDir = new File(catalinaBaseEnv)).exists() && catalinaBaseDir.isDirectory()) {
                catalinaBase = catalinaBaseEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return catalinaBase;
    }

    private String getDefaultInstallationPath() {
        String catalinaHome = "";
        try {
            File catalinaHomeDir;
            String catalinaHomeEnv = System.getenv(CATALINA_HOME_VAR_STRING);
            if (catalinaHomeEnv != null && catalinaHomeEnv.length() > 1 && (catalinaHomeDir = new File(catalinaHomeEnv)).exists() && catalinaHomeDir.isDirectory()) {
                catalinaHome = catalinaHomeEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return catalinaHome;
    }

    private String getJavaOptions(String targetOS, String targetJVM, int commPort, char delimiter) {
        StringBuilder javaOpts = new StringBuilder();
        boolean nonEmptyOpts = false;
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            nonEmptyOpts = true;
            javaOpts.append("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            if (nonEmptyOpts) {
                javaOpts.append(delimiter);
            }
            nonEmptyOpts = true;
            javaOpts.append("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        String profilerOpts = IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)targetJVM, (boolean)false, (int)commPort);
        profilerOpts.replace("\\s-", delimiter + "-");
        if (nonEmptyOpts) {
            javaOpts.append(delimiter);
        }
        javaOpts.append(profilerOpts);
        return IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)javaOpts.toString()) + IntegrationUtils.getLineBreak((String)targetOS);
    }

    private boolean validateCatalinaBasePath(String path) {
        String dirSeparator = System.getProperty("file.separator");
        return new File(path + dirSeparator + "conf" + dirSeparator + "server.xml").exists();
    }
}

