/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.pub;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;
import org.netbeans.modules.mobility.editor.DocumentPreprocessor;
import org.netbeans.modules.mobility.editor.J2MENode;
import org.netbeans.modules.mobility.project.ApplicationDescriptorHandler;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;

public class J2MEDataObject
extends MultiDataObject {
    static final long serialVersionUID = 8090017233591568305L;
    private static final String MIME_TYPE = "text/x-java";
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    private J2MEEditorSupport jes;

    public J2MEDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                J2MEDataObject.this.createJavaEditorSupport().saveAs(folder, fileName);
            }
        }});
    }

    public Node createNodeDelegate() {
        return new J2MENode(this, JavaDataSupport.createJavaNode((FileObject)this.getPrimaryFile()));
    }

    protected FileObject handleRename(String name) throws IOException {
        ApplicationDescriptorHandler.getDefault().handleRename(this.getPrimaryFile(), name);
        return super.handleRename(name);
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        ApplicationDescriptorHandler.getDefault().handleMove(this.getPrimaryFile(), df.getPrimaryFile());
        return super.handleMove(df);
    }

    protected void handleDelete() throws IOException {
        ApplicationDescriptorHandler.getDefault().handleDelete(this.getPrimaryFile());
        super.handleDelete();
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{(this.isValid() ? this.getNodeDelegate() : this.createNodeDelegate()).getLookup(), new Lookup(){

            public <T> T lookup(Class<T> clazz) {
                return (T)J2MEDataObject.this.getCookie(clazz);
            }

            public <T> Lookup.Result<T> lookup(final Lookup.Template<T> template) {
                return new Lookup.Result<T>(){

                    public void addLookupListener(LookupListener l) {
                    }

                    public void removeLookupListener(LookupListener l) {
                    }

                    public Collection<? extends T> allInstances() {
                        Node.Cookie c = J2MEDataObject.this.getCookie(template.getType());
                        return c == null ? Collections.EMPTY_SET : Collections.singleton(c);
                    }
                };
            }
        }});
    }

    public Node.Cookie getCookie(Class type) {
        if (type.isAssignableFrom(J2MEEditorSupport.class)) {
            return this.createJavaEditorSupport();
        }
        return super.getCookie(type);
    }

    protected synchronized J2MEEditorSupport createJavaEditorSupport() {
        if (this.jes == null) {
            this.jes = new J2MEEditorSupport(this);
        }
        return this.jes;
    }

    public static class J2MEEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        private ProjectConfigurationsHelper pch;
        private static Method setAlreadyModified = null;
        private static DocumentPreprocessor documentPreprocessor;

        public J2MEEditorSupport(J2MEDataObject dataObject) {
            this(dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
        }

        public J2MEEditorSupport(J2MEDataObject dataObject, CloneableEditorSupport.Env env) {
            super((DataObject)dataObject, env);
            this.setMIMEType(J2MEDataObject.MIME_TYPE);
        }

        protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, final OutputStream stream) throws IOException, BadLocationException {
            if (this.pch == null) {
                Project p = FileOwnerQuery.getOwner((FileObject)this.getDataObject().getPrimaryFile());
                ProjectConfigurationsHelper projectConfigurationsHelper = this.pch = p == null ? null : (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
            }
            if (this.pch == null || !this.pch.isPreprocessorOn()) {
                this.saveFromKitToStreamHook(doc, kit, stream);
                return;
            }
            final ByteArrayOutputStream myStream = new ByteArrayOutputStream();
            this.saveFromKitToStreamHook(doc, kit, myStream);
            final String encoding = this.getEncoding().name();
            CommentingPreProcessor.Source ppSource = new CommentingPreProcessor.Source(){

                public Reader createReader() throws IOException {
                    return new StringReader(myStream.toString(encoding));
                }
            };
            CommentingPreProcessor.Destination ppDestination = new CommentingPreProcessor.Destination(){

                public void doInsert(int line, String s) {
                }

                public void doRemove(int line, int column, int length) {
                }

                public Writer createWriter(boolean validOutput) throws IOException {
                    return new OutputStreamWriter(stream, encoding);
                }
            };
            ProjectConfiguration defCfg = this.pch == null ? null : this.pch.getDefaultConfiguration();
            HashMap identifiers = new HashMap();
            if (defCfg != null) {
                identifiers.putAll(this.pch.getAbilitiesFor(defCfg));
                identifiers.put(defCfg.getDisplayName(), null);
            }
            CommentingPreProcessor cpp = new CommentingPreProcessor(ppSource, ppDestination, identifiers);
            try {
                cpp.run();
            }
            catch (PreprocessorException pe) {
                ErrorManager.getDefault().notify((Throwable)pe);
            }
        }

        protected final Charset getEncoding() {
            return FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        }

        protected void saveFromKitToStreamHook(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
            super.saveFromKitToStream(doc, kit, stream);
        }

        protected void loadFromStreamToKit(StyledDocument doc, final InputStream stream, EditorKit kit) throws IOException, BadLocationException {
            if (this.pch == null) {
                Project p = FileOwnerQuery.getOwner((FileObject)this.getDataObject().getPrimaryFile());
                ProjectConfigurationsHelper projectConfigurationsHelper = this.pch = p == null ? null : (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
            }
            if (this.pch == null || !this.pch.isPreprocessorOn()) {
                this.loadFromStreamToKitHook(doc, stream, kit);
                return;
            }
            final Charset encoding = this.getEncoding();
            CommentingPreProcessor.Source ppSource = new CommentingPreProcessor.Source(){

                public Reader createReader() throws IOException {
                    return new InputStreamReader(stream, encoding);
                }
            };
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            final OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, encoding);
            CommentingPreProcessor.Destination ppDestination = new CommentingPreProcessor.Destination(){

                public void doInsert(int line, String s) {
                }

                public void doRemove(int line, int column, int length) {
                }

                public Writer createWriter(boolean validOutput) {
                    return osw;
                }
            };
            ProjectConfiguration conf = this.pch == null ? null : this.pch.getActiveConfiguration();
            HashMap identifiers = new HashMap();
            if (conf != null) {
                identifiers.putAll(this.pch.getAbilitiesFor(conf));
                identifiers.put(conf.getDisplayName(), null);
            }
            CommentingPreProcessor cpp = new CommentingPreProcessor(ppSource, ppDestination, identifiers);
            cpp.run();
            this.loadFromStreamToKitHook(doc, new ByteArrayInputStream(out.toByteArray()), kit);
        }

        protected void loadFromStreamToKitHook(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
            super.loadFromStreamToKit(doc, stream, kit);
        }

        protected EditorKit createEditorKit() {
            if (documentPreprocessor == null) {
                documentPreprocessor = new DocumentPreprocessor();
                EditorRegistry.addPropertyChangeListener((PropertyChangeListener)documentPreprocessor);
            }
            return super.createEditorKit();
        }

        protected boolean notifyModified() {
            StyledDocument document = this.getDocument();
            if (document != null && document.getProperty("SKIP_DUCUMENT_CHANGES") != null && !this.isModified() && setAlreadyModified != null) {
                try {
                    setAlreadyModified.invoke((Object)this, Boolean.FALSE);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        public boolean close(boolean ask) {
            return super.close(ask);
        }

        static {
            try {
                setAlreadyModified = CloneableEditorSupport.class.getDeclaredMethod("setAlreadyModified", Boolean.TYPE);
                setAlreadyModified.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected static class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(J2MEDataObject obj) {
                super((DataObject)obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((J2MEDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                J2MEDataObject javaData = (J2MEDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    javaData.getCookieSet().add((Node.Cookie)this.saveCookie);
                    javaData.setModified(true);
                }
            }

            public void removeSaveCookie() {
                J2MEDataObject javaData = (J2MEDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) != null) {
                    javaData.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    javaData.setModified(false);
                }
            }

            private final class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((J2MEEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }
}

