/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class CreateDebugBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "create-debug-block-action";

    public CreateDebugBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper cfgProvider, ArrayList<PPLine> preprocessorLineList, JTextComponent target) {
        return cfgProvider != null && cfgProvider.isPreprocessorOn() && cfgProvider.getConfigurations().size() > 1 && !this.overlapsBlockBorders(target, preprocessorLineList) && !this.overlapsGuardedBlocks(target);
    }

    public String getPopupMenuText(ProjectConfigurationsHelper cfgProvider, ArrayList preprocessorLineList, JTextComponent target) {
        return NbBundle.getMessage(CreateDebugBlockAction.class, (String)"LBL_Create_Debug_Block");
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent txt) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)txt.getDocument()), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BaseDocument doc = (BaseDocument)txt.getDocument();
                    int s = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(CreateDebugBlockAction.this.getSelectionStartLine(txt) - 1));
                    int e = Utilities.getRowEnd((JTextComponent)txt, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(CreateDebugBlockAction.this.getSelectionEndLine(txt) - 1)));
                    doc.insertString(e, "\n//#enddebug", null);
                    doc.insertString(s, "//#mdebug\n", null);
                    txt.setSelectionEnd(txt.getSelectionStart());
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                RecommentAction.actionPerformed(txt);
            }
        });
    }
}

