/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class PhpDebuggerPanel
extends JPanel {
    private static final long serialVersionUID = 9465641111345L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final WatchesAndEvalListener watchesAndEvalListener;
    private JCheckBox debuggerConsoleCheckBox;
    private JLabel debuggerConsoleInfoLabel;
    private JLabel errorLabel;
    private JLabel maxChildrenLabel;
    private JTextField maxChildrenTextField;
    private JLabel maxStructuresDepthLabel;
    private JTextField maxStructuresDepthTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JCheckBox requestedUrlsCheckBox;
    private JLabel sessionIdLabel;
    private JTextField sessionIdTextField;
    private JCheckBox stopAtTheFirstLineCheckBox;
    private JCheckBox watchesAndEvalCheckBox;

    public PhpDebuggerPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.watchesAndEvalListener = new WatchesAndEvalListener(this.maxStructuresDepthTextField, this.maxChildrenTextField);
        this.init();
        this.initListeners();
    }

    private void init() {
        this.watchesAndEvalListener.enableDependentFields(this.watchesAndEvalCheckBox.isSelected());
    }

    private void initListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.sessionIdTextField.getDocument().addDocumentListener(documentListener);
        this.maxStructuresDepthTextField.getDocument().addDocumentListener(documentListener);
        this.maxChildrenTextField.getDocument().addDocumentListener(documentListener);
        this.watchesAndEvalCheckBox.addItemListener(this.watchesAndEvalListener);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(int debuggerPort) {
        this.portTextField.setText(String.valueOf(debuggerPort));
    }

    public String getSessionId() {
        return this.sessionIdTextField.getText();
    }

    public void setSessionId(String sessionId) {
        this.sessionIdTextField.setText(sessionId);
    }

    public String getMaxStructuresDepth() {
        return this.maxStructuresDepthTextField.getText();
    }

    public void setMaxStructuresDepth(int maxStructuresDepth) {
        this.maxStructuresDepthTextField.setText(String.valueOf(maxStructuresDepth));
    }

    public String getMaxChildren() {
        return this.maxChildrenTextField.getText();
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildrenTextField.setText(String.valueOf(maxChildren));
    }

    public boolean isStoppedAtTheFirstLine() {
        return this.stopAtTheFirstLineCheckBox.isSelected();
    }

    public void setStoppedAtTheFirstLine(boolean stoppedAtTheFirstLine) {
        this.stopAtTheFirstLineCheckBox.setSelected(stoppedAtTheFirstLine);
    }

    public boolean isWatchesAndEval() {
        return this.watchesAndEvalCheckBox.isSelected();
    }

    public void setWatchesAndEval(boolean watchesAndEval) {
        this.watchesAndEvalCheckBox.removeItemListener(this.watchesAndEvalListener);
        this.watchesAndEvalCheckBox.setSelected(watchesAndEval);
        this.watchesAndEvalCheckBox.addItemListener(this.watchesAndEvalListener);
    }

    public boolean isShowUrls() {
        return this.requestedUrlsCheckBox.isSelected();
    }

    public void setShowUrls(boolean showUrls) {
        this.requestedUrlsCheckBox.setSelected(showUrls);
    }

    public boolean isShowConsole() {
        return this.debuggerConsoleCheckBox.isSelected();
    }

    public void setShowConsole(boolean showConsole) {
        this.debuggerConsoleCheckBox.setSelected(showConsole);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.sessionIdLabel = new JLabel();
        this.sessionIdTextField = new JTextField();
        this.stopAtTheFirstLineCheckBox = new JCheckBox();
        this.watchesAndEvalCheckBox = new JCheckBox();
        this.maxStructuresDepthLabel = new JLabel();
        this.maxStructuresDepthTextField = new JTextField();
        this.maxChildrenLabel = new JLabel();
        this.maxChildrenTextField = new JTextField();
        this.requestedUrlsCheckBox = new JCheckBox();
        this.debuggerConsoleCheckBox = new JCheckBox();
        this.debuggerConsoleInfoLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.portLabel.text"));
        this.sessionIdLabel.setLabelFor(this.sessionIdTextField);
        Mnemonics.setLocalizedText((JLabel)this.sessionIdLabel, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.sessionIdLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.stopAtTheFirstLineCheckBox, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.stopAtTheFirstLineCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.watchesAndEvalCheckBox, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.watchesAndEvalCheckBox.text"));
        this.maxStructuresDepthLabel.setLabelFor(this.maxStructuresDepthTextField);
        Mnemonics.setLocalizedText((JLabel)this.maxStructuresDepthLabel, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.maxStructuresDepthLabel.text"));
        this.maxChildrenLabel.setLabelFor(this.maxChildrenTextField);
        Mnemonics.setLocalizedText((JLabel)this.maxChildrenLabel, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.maxChildrenLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.requestedUrlsCheckBox, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.requestedUrlsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.debuggerConsoleCheckBox, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.debuggerConsoleCheckBox.text"));
        this.debuggerConsoleInfoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.debuggerConsoleInfoLabel, (String)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.debuggerConsoleInfoLabel.text"));
        this.errorLabel.setLabelFor(this.debuggerConsoleCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portLabel).addComponent(this.sessionIdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portTextField, -2, 50, -2).addComponent(this.sessionIdTextField, -2, 176, -2))).addComponent(this.stopAtTheFirstLineCheckBox).addComponent(this.watchesAndEvalCheckBox).addComponent(this.requestedUrlsCheckBox).addComponent(this.debuggerConsoleCheckBox).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.debuggerConsoleInfoLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxStructuresDepthLabel).addComponent(this.maxChildrenLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.maxChildrenTextField).addComponent(this.maxStructuresDepthTextField, -2, 50, -2)))))).addContainerGap()));
        layout.linkSize(0, this.maxChildrenTextField, this.maxStructuresDepthTextField, this.portTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sessionIdLabel).addComponent(this.sessionIdTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.stopAtTheFirstLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.watchesAndEvalCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxStructuresDepthLabel).addComponent(this.maxStructuresDepthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxChildrenLabel).addComponent(this.maxChildrenTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.requestedUrlsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerConsoleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerConsoleInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.portTextField.AccessibleContext.accessibleDescription"));
        this.sessionIdLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.sessionIdLabel.AccessibleContext.accessibleName"));
        this.sessionIdLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.debuggerSessionIdLabel.AccessibleContext.accessibleDescription"));
        this.sessionIdTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.sessionIdTextField.AccessibleContext.accessibleName"));
        this.sessionIdTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.sessionIdTextField.AccessibleContext.accessibleDescription"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleName"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleDescription"));
        this.watchesAndEvalCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.watchesAndEvalCheckBox.AccessibleContext.accessibleName"));
        this.watchesAndEvalCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.watchesAndEvalCheckBox.AccessibleContext.accessibleDescription"));
        this.maxStructuresDepthLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxStructuresDepthLabel.AccessibleContext.accessibleName"));
        this.maxStructuresDepthLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxStructuresDepthLabel.AccessibleContext.accessibleDescription"));
        this.maxStructuresDepthTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.maxStructuresDepthTextField.AccessibleContext.accessibleName"));
        this.maxStructuresDepthTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxStructuresDepthTextField.AccessibleContext.accessibleDescription"));
        this.maxChildrenLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxChildrenLabel.AccessibleContext.accessibleName"));
        this.maxChildrenLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxChildrenLabel.AccessibleContext.accessibleDescription"));
        this.maxChildrenTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerPanel.maxChildrenTextField.AccessibleContext.accessibleName"));
        this.maxChildrenTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.maxChildrenTextField.AccessibleContext.accessibleDescription"));
        this.requestedUrlsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.requestedUrlsCheckBox.AccessibleContext.accessibleName"));
        this.requestedUrlsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.requestedUrlsCheckBox.AccessibleContext.accessibleDescription"));
        this.debuggerConsoleCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.debuggerConsoleCheckBox.AccessibleContext.accessibleName"));
        this.debuggerConsoleCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.debuggerConsoleCheckBox.AccessibleContext.accessibleDescription"));
        this.debuggerConsoleInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.debuggerConsoleInfoLabel.AccessibleContext.accessibleName"));
        this.debuggerConsoleInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.debuggerConsoleInfoLabel.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpDebuggerPanel.class, (String)"PhpDebuggerOptions.AccessibleContext.accessibleDescription"));
    }

    private static final class WatchesAndEvalListener
    implements ItemListener {
        private static boolean warningShown = false;
        private final JComponent[] dependentFields;

        WatchesAndEvalListener(JComponent ... dependentFields) {
            this.dependentFields = dependentFields;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            this.enableDependentFields(selected);
            this.showWarning(selected);
        }

        private void showWarning(boolean selected) {
            if (warningShown) {
                return;
            }
            if (selected) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpDebuggerPanel.class, (String)"MSG_WatchesAndEval"), 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
                warningShown = true;
            }
        }

        void enableDependentFields(boolean selected) {
            for (JComponent component : this.dependentFields) {
                component.setEnabled(selected);
            }
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhpDebuggerPanel.this.fireChange();
        }
    }
}

