/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.phpunit.PhpUnit33;
import org.netbeans.modules.php.project.phpunit.PhpUnitCustom;
import org.netbeans.modules.php.project.phpunit.PhpUnitImpl;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public abstract class PhpUnit
extends PhpProgram {
    protected static final Logger LOGGER = Logger.getLogger(PhpUnit.class.getName());
    public static final boolean KEEP_LOGS = Boolean.getBoolean("nb.php.phpunit.keeplogs");
    public static final String OPTIONS_SUB_PATH = "PhpUnit";
    public static final String TEST_CLASS_SUFFIX = "Test";
    private static final String TEST_FILE_SUFFIX = "Test.php";
    private static final String SUITE_CLASS_SUFFIX = "Suite";
    private static final String SUITE_FILE_SUFFIX = "Suite.php";
    private static final String REQUIRE_ONCE_TPL_START = "require_once '";
    private static final String REQUIRE_ONCE_TPL_END = "%s';";
    public static final String PARAM_VERSION = "--version";
    public static final String PARAM_FILTER = "--filter";
    public static final String PARAM_COVERAGE_LOG = "--coverage-clover";
    public static final String PARAM_SKELETON = "--skeleton-test";
    public static final String PARAM_LIST_GROUPS = "--list-groups";
    public static final String PARAM_GROUP = "--group";
    public static final String PARAM_SKELETON_OLD = "--skeleton";
    public static final String PARAM_BOOTSTRAP = "--bootstrap";
    private static final String BOOTSTRAP_FILENAME = "bootstrap%s.php";
    public static final String PARAM_CONFIGURATION = "--configuration";
    private static final String CONFIGURATION_FILENAME = "configuration%s.xml";
    public static final File XML_LOG;
    public static final File COVERAGE_LOG;
    public static final String SUITE_NAME = "NetBeansSuite";
    public static final String SUITE_RUN = "run=%s";
    private static final String SUITE_REL_PATH = "phpunit/NetBeansSuite.php";
    public static final char DIRECTORY_SEPARATOR = '/';
    public static final String DIRNAME_FILE = ".dirname(__FILE__).'/";
    public static final String REQUIRE_ONCE_REL_PART = "'.dirname(__FILE__).'/";
    public static final Pattern LINE_PATTERN;
    static final int[] UNKNOWN_VERSION;
    static final int[] MINIMAL_VERSION;
    static final int[] MINIMAL_VERSION_PHP53;
    static volatile int[] version;
    private static volatile File suite;

    PhpUnit(String command) {
        super(command);
    }

    public static File getNbSuite() {
        if (suite == null) {
            suite = InstalledFileLocator.getDefault().locate(SUITE_REL_PATH, "org.netbeans.modules.php.project", false);
        }
        return suite;
    }

    public static PhpUnit getDefault() throws PhpProgram.InvalidPhpProgramException {
        String command = PhpOptions.getInstance().getPhpUnit();
        String error = PhpUnit.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        if (PhpUnit.hasValidVersion(new PhpUnitCustom(command)) && version[0] >= MINIMAL_VERSION_PHP53[0] && version[1] >= MINIMAL_VERSION_PHP53[1]) {
            return new PhpUnitImpl(command);
        }
        return new PhpUnit33(command);
    }

    public static PhpUnit getCustom(String command) throws PhpProgram.InvalidPhpProgramException {
        String error = PhpUnit.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpUnitCustom(command);
    }

    public abstract String getXmlLogParam();

    public static boolean isRequireOnceSourceFile(String line, String filename) {
        return line.startsWith(REQUIRE_ONCE_TPL_START) && line.endsWith(String.format(REQUIRE_ONCE_TPL_END, filename));
    }

    public static boolean isTestFile(String fileName) {
        return !fileName.equals(TEST_FILE_SUFFIX) && fileName.endsWith(TEST_FILE_SUFFIX);
    }

    public static boolean isTestClass(String className) {
        return !className.equals(TEST_CLASS_SUFFIX) && className.endsWith(TEST_CLASS_SUFFIX);
    }

    public static boolean isSuiteFile(String fileName) {
        return !fileName.equals(SUITE_FILE_SUFFIX) && fileName.endsWith(SUITE_FILE_SUFFIX);
    }

    public static boolean isSuiteClass(String className) {
        return !className.equals(SUITE_CLASS_SUFFIX) && className.endsWith(SUITE_CLASS_SUFFIX);
    }

    public static boolean isTestOrSuiteFile(String fileName) {
        return PhpUnit.isTestFile(fileName) || PhpUnit.isSuiteFile(fileName);
    }

    public static boolean isTestOrSuiteClass(String className) {
        return PhpUnit.isTestClass(className) || PhpUnit.isSuiteClass(className);
    }

    public static String getTestedClass(String testOrSuiteClass) {
        assert (PhpUnit.isTestOrSuiteClass(testOrSuiteClass)) : "Not Test or Suite class: " + testOrSuiteClass;
        int lastIndexOf = -1;
        if (PhpUnit.isTestClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(TEST_CLASS_SUFFIX);
        } else if (PhpUnit.isSuiteClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(SUITE_CLASS_SUFFIX);
        }
        assert (lastIndexOf != -1);
        return testOrSuiteClass.substring(0, lastIndexOf);
    }

    public static String makeTestFile(String testedFileName) {
        return testedFileName + TEST_FILE_SUFFIX;
    }

    public static String makeTestClass(String testedClass) {
        return testedClass + TEST_CLASS_SUFFIX;
    }

    public static String makeSuiteFile(String testedFileName) {
        return testedFileName + SUITE_FILE_SUFFIX;
    }

    public static String makeSuiteClass(String testedClass) {
        return testedClass + SUITE_CLASS_SUFFIX;
    }

    public ExternalProcessBuilder getProcessBuilder() {
        return super.getProcessBuilder().workingDirectory(new File(this.getProgram()).getParentFile());
    }

    public File getWorkingDirectory(ConfigFiles configFiles, File defaultWorkingDirectory) {
        if (configFiles.configuration != null) {
            return configFiles.configuration.getParentFile();
        }
        return defaultWorkingDirectory;
    }

    public static String validateVersion(PhpUnit phpUnit) {
        if (phpUnit == null) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_NoPhpUnit");
        }
        String error = phpUnit.validate();
        if (error == null) {
            phpUnit.getVersion();
            if (version == null || version == UNKNOWN_VERSION || version[0] <= MINIMAL_VERSION[0] && version[1] < MINIMAL_VERSION[1]) {
                error = NbBundle.getMessage(PhpUnit.class, (String)"MSG_OldPhpUnit", (Object[])PhpUnit.getVersions(phpUnit));
            }
        }
        return error;
    }

    public static String validateVersion(PhpUnit phpUnit, PhpProject project) {
        String error = PhpUnit.validateVersion(phpUnit);
        if (error != null) {
            return error;
        }
        PhpLanguageOptions.PhpVersion phpVersion = ProjectPropertiesSupport.getPhpVersion(project);
        switch (phpVersion) {
            case PHP_53: {
                if (version[0] > MINIMAL_VERSION_PHP53[0] || version[1] >= MINIMAL_VERSION_PHP53[1]) break;
                error = NbBundle.getMessage(PhpUnit.class, (String)"MSG_OldPhpUnitPhp53", (Object[])PhpUnit.getVersions(phpUnit, project));
                break;
            }
            case PHP_5: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PHP version: " + (Object)((Object)phpVersion));
            }
        }
        return error;
    }

    public static boolean hasValidVersion(PhpUnit phpUnit) {
        return PhpUnit.validateVersion(phpUnit) == null;
    }

    public static boolean hasValidVersion(PhpUnit phpUnit, PhpProject project) {
        return PhpUnit.validateVersion(phpUnit, project) == null;
    }

    public static void resetVersion() {
        version = null;
    }

    private int[] getVersion() {
        if (!this.isValid()) {
            return UNKNOWN_VERSION;
        }
        if (version != null) {
            return version;
        }
        version = UNKNOWN_VERSION;
        ExternalProcessBuilder externalProcessBuilder = this.getProcessBuilder().addArgument(PARAM_VERSION);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new OutputProcessorFactory());
        String message = NbBundle.getMessage(PhpUnit.class, (String)"LBL_ValidatingPhpUnit");
        PhpUnit.execute((ExternalProcessBuilder)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)message, (String)message);
        return version;
    }

    public static String[] getVersions(PhpUnit phpUnit) {
        return PhpUnit.getVersions(phpUnit, MINIMAL_VERSION);
    }

    public static String[] getVersions(PhpUnit phpUnit, PhpProject project) {
        int[] minimalVersion = null;
        PhpLanguageOptions.PhpVersion phpVersion = ProjectPropertiesSupport.getPhpVersion(project);
        switch (phpVersion) {
            case PHP_53: {
                minimalVersion = MINIMAL_VERSION_PHP53;
                break;
            }
            case PHP_5: {
                minimalVersion = MINIMAL_VERSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PHP version: " + (Object)((Object)phpVersion));
            }
        }
        return PhpUnit.getVersions(phpUnit, minimalVersion);
    }

    private static String[] getVersions(PhpUnit phpUnit, int[] minimalVersion) {
        Integer i;
        int i$;
        int len$;
        int[] arr$;
        ArrayList<String> params = new ArrayList<String>(6);
        if (phpUnit == null || phpUnit.getVersion() == UNKNOWN_VERSION) {
            String questionMark = NbBundle.getMessage(PhpUnit.class, (String)"LBL_QuestionMark");
            params.add(questionMark);
            params.add(questionMark);
            params.add(questionMark);
        } else {
            arr$ = phpUnit.getVersion();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                params.add(String.valueOf(i));
            }
        }
        arr$ = minimalVersion;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            params.add(String.valueOf(i));
        }
        return params.toArray(new String[params.size()]);
    }

    public static ConfigFiles getConfigFiles(PhpProject project, boolean withSuite) {
        File configuration;
        LinkedList<Pair<String, File>> missingFiles = new LinkedList<Pair<String, File>>();
        File bootstrap = ProjectPropertiesSupport.getPhpUnitBootstrap(project);
        if (bootstrap != null && !bootstrap.isFile()) {
            missingFiles.add(Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_Bootstrap"), (Object)bootstrap));
            bootstrap = null;
        }
        if ((configuration = ProjectPropertiesSupport.getPhpUnitConfiguration(project)) != null && !configuration.isFile()) {
            missingFiles.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_XmlConfiguration"), (Object)configuration));
            configuration = null;
        }
        File suite = null;
        if (withSuite && (suite = ProjectPropertiesSupport.getPhpUnitSuite(project)) != null && !suite.isFile()) {
            missingFiles.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_TestSuite"), (Object)suite));
            suite = null;
        }
        PhpUnit.warnAboutMissingFiles(missingFiles);
        return new ConfigFiles(bootstrap, ProjectPropertiesSupport.usePhpUnitBootstrapForCreateTests(project), configuration, suite);
    }

    public static File getCustomSuite(PhpProject project) {
        File suite = ProjectPropertiesSupport.getPhpUnitSuite(project);
        if (suite != null && suite.isFile()) {
            return suite;
        }
        return null;
    }

    public static File createBootstrapFile(final PhpProject project) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        final FileObject configFile = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitBootstrap");
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        final File bootstrapFile = new File(PhpUnit.getBootstrapFilepath(project));
        final File[] files = new File[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dataTemplate = DataObject.find((FileObject)configFile);
                    DataObject bootstrap = dataTemplate.createFromTemplate(dataFolder, bootstrapFile.getName() + "~");
                    assert (bootstrap != null);
                    PhpUnit.moveAndAdjustBootstrap(project, FileUtil.toFile((FileObject)bootstrap.getPrimaryFile()), bootstrapFile);
                    assert (bootstrapFile.isFile());
                    files[0] = bootstrapFile;
                    PhpUnit.informAboutGeneratedFile(bootstrapFile.getName());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Cannot create PHPUnit bootstrap file", ex);
                }
            }
        });
        if (files[0] == null) {
            PhpUnit.warnAboutNotGeneratedFile(bootstrapFile.getName());
        }
        return files[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveAndAdjustBootstrap(PhpProject project, File tmpBootstrap, File finalBootstrap) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(tmpBootstrap));
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(finalBootstrap));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (line.contains("%INCLUDE_PATH%")) {
                            if (line.startsWith("//")) continue;
                            line = PhpUnit.processIncludePath(finalBootstrap, line, ProjectPropertiesSupport.getPropertyEvaluator(project).getProperty("include.path"), FileUtil.toFile((FileObject)project.getProjectDirectory()));
                        }
                        out.write(line);
                        out.newLine();
                    }
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        if (!tmpBootstrap.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete temporary file {0}", tmpBootstrap);
            tmpBootstrap.deleteOnExit();
        }
        FileUtil.refreshFor((File[])new File[]{finalBootstrap.getParentFile()});
    }

    static String processIncludePath(File bootstrap, String line, String includePath, File projectDir) {
        if (StringUtils.hasText((String)includePath)) {
            if (includePath.startsWith(":")) {
                includePath = includePath.substring(1);
            }
            StringBuilder buffer = new StringBuilder(200);
            for (String path : PropertyUtils.tokenizePath((String)includePath)) {
                File reference = PropertyUtils.resolveFile((File)projectDir, (String)path);
                buffer.append(".PATH_SEPARATOR");
                buffer.append(PhpUnit.getDirnameFile(bootstrap, reference));
            }
            includePath = buffer.toString();
        } else {
            line = "//" + line;
        }
        line = line.replace("%INCLUDE_PATH%", includePath);
        return line;
    }

    public static File createConfigurationFile(PhpProject project) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        FileObject configFile = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitConfiguration.xml");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        File configurationFile = new File(PhpUnit.getConfigurationFilepath(project));
        File file = null;
        try {
            DataObject dataTemplate = DataObject.find((FileObject)configFile);
            DataObject configuration = dataTemplate.createFromTemplate(dataFolder, configurationFile.getName().replace(".xml", ""));
            assert (configuration != null);
            file = configurationFile;
            PhpUnit.informAboutGeneratedFile(configurationFile.getName());
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot create PHPUnit configuration file", ex);
        }
        if (file == null) {
            PhpUnit.warnAboutNotGeneratedFile(configurationFile.getName());
        }
        return file;
    }

    public static void informAboutGeneratedFile(String generatedFile) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_FileGenerated", (Object)generatedFile)));
    }

    private static void warnAboutNotGeneratedFile(String file) {
        NotifyDescriptor.Message warning = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_NotGenerated", (Object)file), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)warning);
    }

    private static void warnAboutMissingFiles(List<Pair<String, File>> missingFiles) {
        if (missingFiles.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        for (Pair<String, File> pair : missingFiles) {
            buffer.append(NbBundle.getMessage(PhpUnit.class, (String)"LBL_MissingFile", (Object)pair.first, (Object)((File)pair.second).getAbsolutePath()));
            buffer.append("\n");
        }
        NotifyDescriptor.Message warning = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_MissingFiles", (Object)buffer.toString()), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)warning);
    }

    private static String getDirnameFile(File testFile, File sourceFile) {
        return PhpUnit.getRelPath(testFile, sourceFile, ".'", DIRNAME_FILE, "'");
    }

    public static String getRequireOnce(File testFile, File sourceFile) {
        return PhpUnit.getRelPath(testFile, sourceFile, "", REQUIRE_ONCE_REL_PART, "");
    }

    private static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix) {
        return PhpUnit.getRelPath(testFile, sourceFile, absolutePrefix, relativePrefix, suffix, false);
    }

    static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix, boolean forceAbsolute) {
        File parentFile = testFile.getParentFile();
        String relPath = PropertyUtils.relativizeFile((File)parentFile, (File)sourceFile);
        relPath = relPath == null || forceAbsolute ? absolutePrefix + sourceFile.getAbsolutePath() + suffix : relativePrefix + relPath + suffix;
        return relPath.replace(File.separatorChar, '/');
    }

    private static String getBootstrapFilepath(PhpProject project) {
        return PhpUnit.getFilepath(project, BOOTSTRAP_FILENAME);
    }

    private static String getConfigurationFilepath(PhpProject project) {
        return PhpUnit.getFilepath(project, CONFIGURATION_FILENAME);
    }

    private static String getFilepath(PhpProject project, String filename) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        File tests = FileUtil.toFile((FileObject)testDirectory);
        File file = null;
        int i = 0;
        while ((file = new File(tests, PhpUnit.getFilename(filename, i++))).isFile()) {
        }
        assert (!file.isFile());
        return file.getAbsolutePath();
    }

    private static String getFilename(String filename, int i) {
        return String.format(filename, i == 0 ? "" : Integer.valueOf(i));
    }

    public String validate() {
        if (!StringUtils.hasText((String)this.getProgram())) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_NoPhpUnit");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitCannotRead");
        }
        return null;
    }

    public static String validate(String command) {
        return new PhpUnitCustom(command).validate();
    }

    static {
        LINE_PATTERN = Pattern.compile("(?:.+\\(\\) )?(.+):(\\d+)");
        UNKNOWN_VERSION = new int[0];
        MINIMAL_VERSION = new int[]{3, 3, 0};
        MINIMAL_VERSION_PHP53 = new int[]{3, 4, 0};
        version = null;
        String logDirName = System.getProperty("java.io.tmpdir");
        String userLogDirName = System.getProperty("nb.php.phpunit.logdir");
        if (userLogDirName != null) {
            LOGGER.log(Level.INFO, "Custom directory for PhpUnit logs provided: {0}", userLogDirName);
            File userLogDir = new File(userLogDirName);
            if (userLogDir.isDirectory() && FileUtils.isDirectoryWritable((File)userLogDir)) {
                logDirName = userLogDirName;
            } else {
                LOGGER.log(Level.WARNING, "Directory for PhpUnit logs {0} is not writable directory", userLogDirName);
            }
        }
        LOGGER.log(Level.FINE, "Directory for PhpUnit logs: {0}", logDirName);
        XML_LOG = new File(logDirName, "nb-phpunit-log.xml");
        COVERAGE_LOG = new File(logDirName, "nb-phpunit-coverage.xml");
    }

    static final class OutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private static final Pattern PHPUNIT_VERSION = Pattern.compile("PHPUnit\\s+(\\d+)\\.(\\d+)\\.(\\d+)\\w*\\s+");

        OutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(final InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    int[] match = OutputProcessorFactory.match(line);
                    if (match != null) {
                        version = match;
                    }
                }

                public void reset() {
                    try {
                        defaultProcessor.reset();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                public void close() {
                    try {
                        defaultProcessor.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        static int[] match(String text) {
            Matcher matcher;
            assert (text != null);
            if (StringUtils.hasText((String)text) && (matcher = PHPUNIT_VERSION.matcher(text)).find()) {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                int release = Integer.parseInt(matcher.group(3));
                return new int[]{major, minor, release};
            }
            return null;
        }
    }

    public static final class ConfigFiles {
        public final File bootstrap;
        public final boolean useBootstrapForCreateTests;
        public final File configuration;
        public final File suite;

        public ConfigFiles(File bootstrap, boolean useBootstrapForCreateTests, File configuration, File suite) {
            this.bootstrap = bootstrap;
            this.useBootstrapForCreateTests = useBootstrapForCreateTests;
            this.configuration = configuration;
            this.suite = suite;
        }
    }
}

