/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class TransferFilesChooserVisual
extends JPanel {
    private static final long serialVersionUID = 8975634564231321L;
    private final TransferFilesChooserPanel filesChooserPanel;
    private final TransferFilesChooser.TransferType transferType;
    private JPanel innerPanel;
    private JPanel outerPanel;
    private JLabel selectFilesLabel;
    private JLabel selectedFilesInfoLabel;
    private JLabel warningLabel;

    public TransferFilesChooserVisual(TransferFilesChooserPanel filesChooserPanel, TransferFilesChooser.TransferType transferType) {
        assert (filesChooserPanel != null);
        assert (transferType != null);
        this.filesChooserPanel = filesChooserPanel;
        this.transferType = transferType;
        this.initComponents();
        this.innerPanel.add((Component)filesChooserPanel.getEmbeddablePanel(), "Center");
        filesChooserPanel.addChangeListener(new TransferFilesChooserPanel.TransferFilesChangeListener(){

            @Override
            public void selectedFilesChanged() {
                TransferFilesChooserVisual.this.updateSelectedFilesInfo();
            }

            @Override
            public void filterChanged() {
            }
        });
        this.updateSelectedFilesInfo();
    }

    public TransferFilesChooserPanel getEmbeddablePanel() {
        return (TransferFilesChooserPanel)this.outerPanel;
    }

    void updateSelectedFilesInfo() {
        String msgKey = null;
        int size = this.filesChooserPanel.getSelectedFiles().size();
        msgKey = size == 1 ? "LBL_FileSelected" : (this.transferType == TransferFilesChooser.TransferType.DOWNLOAD ? "LBL_FilesOrMoreSelected" : "LBL_FilesSelected");
        this.selectedFilesInfoLabel.setText(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)msgKey, (Object)size));
        this.updateWarning();
    }

    void updateWarning() {
        int size = this.filesChooserPanel.getSelectedFiles().size();
        if (size == 0) {
            this.warningLabel.setIcon(null);
            this.warningLabel.setText(" ");
        } else {
            String msgKey = null;
            switch (this.transferType) {
                case DOWNLOAD: {
                    msgKey = "LBL_WarnDownload";
                    break;
                }
                case UPLOAD: {
                    msgKey = "LBL_WarnUpload";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown transfer type: " + (Object)((Object)this.transferType));
                }
            }
            this.warningLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/info_icon.png")));
            this.warningLabel.setText(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)msgKey));
        }
    }

    private void initComponents() {
        this.selectFilesLabel = new JLabel();
        this.outerPanel = new EmbeddablePanel(this.filesChooserPanel);
        this.innerPanel = new JPanel();
        this.selectedFilesInfoLabel = new JLabel();
        this.warningLabel = new JLabel();
        this.selectFilesLabel.setLabelFor(this.outerPanel);
        Mnemonics.setLocalizedText((JLabel)this.selectFilesLabel, (String)NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.selectFilesLabel.text"));
        this.innerPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.selectedFilesInfoLabel, (String)"DUMMY");
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)"DUMMY");
        GroupLayout outerPanelLayout = new GroupLayout(this.outerPanel);
        this.outerPanel.setLayout(outerPanelLayout);
        outerPanelLayout.setHorizontalGroup(outerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerPanelLayout.createSequentialGroup().addComponent(this.selectedFilesInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 402, Short.MAX_VALUE).addComponent(this.warningLabel)).addComponent(this.innerPanel, -1, 500, Short.MAX_VALUE));
        outerPanelLayout.setVerticalGroup(outerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerPanelLayout.createSequentialGroup().addComponent(this.innerPanel, -1, 305, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectedFilesInfoLabel).addComponent(this.warningLabel))));
        this.innerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.innerPanel.AccessibleContext.accessibleName"));
        this.innerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.innerPanel.AccessibleContext.accessibleDescription"));
        this.selectedFilesInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.selectedFilesInfoLabel.AccessibleContext.accessibleName"));
        this.selectedFilesInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.selectedFilesInfoLabel.AccessibleContext.accessibleDescription"));
        this.warningLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.warningLabel.AccessibleContext.accessibleName"));
        this.warningLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.warningLabel.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectFilesLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectFilesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outerPanel, -1, -1, Short.MAX_VALUE)));
        this.selectFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.selectFilesLabel.AccessibleContext.accessibleName"));
        this.selectFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.selectFilesLabel.AccessibleContext.accessibleDescription"));
        this.outerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.outerPanel.AccessibleContext.accessibleName"));
        this.outerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.outerPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilesChooserVisual.class, (String)"TransferFilesChooserVisual.AccessibleContext.accessibleDescription"));
    }

    private static final class EmbeddablePanel
    extends TransferFilesChooserPanel {
        private static final long serialVersionUID = 646546111000L;
        private final TransferFilesChooserPanel delegate;

        public EmbeddablePanel(TransferFilesChooserPanel delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        @Override
        public void addChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
            this.delegate.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
            this.delegate.removeChangeListener(listener);
        }

        @Override
        public Set<TransferFile> getSelectedFiles() {
            return this.delegate.getSelectedFiles();
        }

        @Override
        public TransferFilesChooserPanel getEmbeddablePanel() {
            throw new IllegalStateException();
        }

        @Override
        public boolean hasAnyTransferableFiles() {
            return this.delegate.hasAnyTransferableFiles();
        }
    }
}

