/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

final class RemoteTransferFile
extends TransferFile {
    private static final Logger LOGGER = Logger.getLogger(RemoteTransferFile.class.getName());
    private final RemoteFile file;
    private final RemoteClientImplementation remoteClient;

    public RemoteTransferFile(RemoteFile file, TransferFile parent, RemoteClientImplementation remoteClient) {
        super(parent, remoteClient.getBaseRemoteDirectory());
        this.file = file;
        this.remoteClient = remoteClient;
        if (file == null) {
            throw new NullPointerException("Remote file cannot be null");
        }
        if (remoteClient == null) {
            throw new NullPointerException("Remote client cannot be null");
        }
        if (!this.baseDirectory.startsWith("/")) {
            throw new IllegalArgumentException("Base directory '" + this.baseDirectory + "' must start with '" + "/" + "'");
        }
        String parentDirectory = this.getParentDirectory();
        if (!parentDirectory.startsWith("/")) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must start with '" + "/" + "'");
        }
        RemoteTransferFile.checkParentDirectory(this.baseDirectory, parentDirectory);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Absolute remote path \"{0}\" -> remote path \"{1}\" (base directory \"{2}\")", new Object[]{this.getAbsolutePath(), this.getRemotePath(), this.baseDirectory});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getName();
        }
    }

    @Override
    public String getRemotePath() {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.equals(this.baseDirectory)) {
            return ".";
        }
        String relativePath = absolutePath.substring(this.baseDirectory.length());
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring("/".length());
        }
        return relativePath;
    }

    @Override
    protected Collection<TransferFile> fetchChildren() {
        try {
            return this.remoteClient.listFiles(this);
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.INFO, "Error while getting children for " + this, ex);
            RemoteUtils.processRemoteException(ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getSizeImpl() {
        if (this.isFile()) {
            RemoteFile remoteFile = this.file;
            synchronized (remoteFile) {
                return this.file.getSize();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFile() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLink() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getTimestampImpl() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getParentDirectory() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return RemoteUtils.sanitizeDirectoryPath(this.file.getParentDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAbsolutePath() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            String parentDirectory = this.getParentDirectory();
            if (!parentDirectory.endsWith("/")) {
                parentDirectory = parentDirectory + "/";
            }
            return parentDirectory + this.getName();
        }
    }

    static void checkParentDirectory(String baseDirectory, String parentDirectory) {
        boolean root = baseDirectory.equals("/");
        if (root && !parentDirectory.startsWith("/") || !root && !(parentDirectory + "/").startsWith(baseDirectory + "/")) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must be underneath base directory '" + baseDirectory + "'");
        }
    }
}

