/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

final class LocalTransferFile
extends TransferFile {
    private final File file;
    private final boolean forceDirectory;

    LocalTransferFile(File file, TransferFile parent, String baseDirectory, boolean forceDirectory) {
        super(parent, baseDirectory);
        this.file = file;
        this.forceDirectory = forceDirectory;
        if (file == null) {
            throw new NullPointerException("Local file cannot be null");
        }
        if (!file.getAbsolutePath().startsWith(baseDirectory)) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' must be underneath base directory '" + baseDirectory + "'");
        }
        if (forceDirectory && file.isFile()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' can't be forced as a directory since it is a file");
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getRemotePath() {
        String absolutePath = this.file.getAbsolutePath();
        if (absolutePath.equals(this.baseDirectory)) {
            return ".";
        }
        String remotePath = absolutePath.substring(this.baseDirectory.length() + File.separator.length());
        if (File.separator.equals("/")) {
            return remotePath;
        }
        return remotePath.replace(File.separator, "/");
    }

    @Override
    protected Collection<TransferFile> fetchChildren() {
        return Collections.emptyList();
    }

    @Override
    protected long getSizeImpl() {
        if (this.isFile()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public boolean isDirectory() {
        if (this.file.exists()) {
            boolean directory = this.file.isDirectory();
            if (this.forceDirectory && !directory && this.file.isFile()) assert (false) : "File forced as directory but is regular existing file";
            return directory;
        }
        return this.forceDirectory;
    }

    @Override
    public boolean isFile() {
        if (this.file.exists()) {
            boolean isFile = this.file.isFile();
            if (isFile && this.forceDirectory) assert (false) : "File forced as directory but is regular existing file";
            return isFile;
        }
        return !this.forceDirectory;
    }

    @Override
    public boolean isLink() {
        return FileUtils.isDirectoryLink((File)this.file);
    }

    @Override
    protected long getTimestampImpl() {
        return TimeUnit.SECONDS.convert(this.file.lastModified(), TimeUnit.MILLISECONDS);
    }
}

