/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.DiffTopComponent;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.util.ClientCheckSupport;
import org.netbeans.modules.subversion.util.Context;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class DiffAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Diff";
    }

    @Override
    protected int getFileEnabledStatus() {
        return this.getDirectoryEnabledStatus();
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    protected String iconResource() {
        return "org/netbeans/modules/subversion/resources/icons/diff.png";
    }

    public static void diff(Context ctx, int type, String contextName, boolean initialStatusRefreshDisabled) {
        MultiDiffPanel panel = new MultiDiffPanel(ctx, type, contextName, initialStatusRefreshDisabled);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
        tc.open();
        tc.requestActive();
    }

    public static void diff(File file, String rev1, String rev2) {
        MultiDiffPanel panel = new MultiDiffPanel(file, rev1, rev2, false);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }

    public static void diff(File file, ISVNStatus status) {
        MultiDiffPanel panel = new MultiDiffPanel(file, status);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        ClientCheckSupport.getInstance().runInAWTIfAvailable(ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

            @Override
            public void run() {
                Context ctx = DiffAction.this.getContext(nodes);
                String contextName = DiffAction.this.getContextDisplayName(nodes);
                DiffAction.diff(ctx, SvnModuleConfig.getDefault().getLastUsedModificationContext(), contextName, DiffAction.isSvnNodes(nodes));
            }
        });
    }

    private static boolean isSvnNodes(Node[] nodes) {
        boolean fromSubversionView = true;
        for (Node node : nodes) {
            if (node instanceof SyncFileNode) continue;
            fromSubversionView = false;
            break;
        }
        return fromSubversionView;
    }
}

