/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.NetworkSettings;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnConfigFiles {
    private static SvnConfigFiles instance;
    private Ini svnServers = null;
    private Ini config = null;
    private static final String UNIX_CONFIG_DIR = ".subversion/";
    private static final String GROUPS_SECTION = "groups";
    private static final String GLOBAL_SECTION = "global";
    private static final String WINDOWS_USER_APPDATA;
    private static final String WINDOWS_CONFIG_DIR;
    private static final String WINDOWS_GLOBAL_CONFIG_DIR;
    private static final List<String> DEFAULT_GLOBAL_IGNORES;
    private String recentUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SvnConfigFiles() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Subversion.class.getClassLoader());
        try {
            Config.getGlobal().setEscape(false);
            this.config = this.copyConfigFileToIDEConfigDir("config", new ConfigIniFilePatcher());
            this.svnServers = this.loadSystemIniFile("servers");
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static synchronized SvnConfigFiles getInstance() {
        String t9yUserConfigPath = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (t9yUserConfigPath != null && t9yUserConfigPath.length() > 0) {
            instance = null;
        }
        if (instance == null) {
            instance = new SvnConfigFiles();
        }
        return instance;
    }

    public void reset() {
        this.recentUrl = null;
    }

    public void storeSvnServersSettings(SVNUrl url, SvnClientFactory.ConnectionType connType) {
        assert (url != null) : "can't do anything for a null host";
        if (!(url.getProtocol().startsWith("http") || url.getProtocol().startsWith("https") || url.getProtocol().startsWith("svn+"))) {
            return;
        }
        boolean changes = false;
        Ini nbServers = new Ini();
        Profile.Section nbGlobalSection = nbServers.add(GLOBAL_SECTION);
        String repositoryUrl = url.toString();
        boolean bl = changes = !repositoryUrl.equals(this.recentUrl);
        if (changes) {
            RepositoryConnection rc = SvnModuleConfig.getDefault().getRepositoryConnection(repositoryUrl);
            if (rc != null && url.getProtocol().startsWith("svn+")) {
                if (connType == SvnClientFactory.ConnectionType.svnkit) {
                    this.setExternalCommand("ssh", rc.getSshPortNumber() > 0 ? "ssh -p " + rc.getSshPortNumber() + " -l user -pw password" : "");
                } else {
                    this.setExternalCommand(SvnUtils.getTunnelName(url.getProtocol()), rc.getExternalCommand());
                }
            }
            if (url.getProtocol().startsWith("https")) {
                this.setSSLCert(rc, nbGlobalSection);
            }
            this.setProxy(url, nbGlobalSection);
            this.storeIni(nbServers, "servers");
            this.recentUrl = url.toString();
        }
    }

    private boolean setSSLCert(RepositoryConnection rc, Profile.Section nbGlobalSection) {
        String certPassword;
        if (rc == null) {
            return true;
        }
        String certFile = rc.getCertFile();
        if (certFile == null || certFile.equals("")) {
            return true;
        }
        char[] certPasswordChars = rc.getCertPassword();
        String string = certPassword = certPasswordChars == null ? "" : new String(certPasswordChars);
        if (certPassword.equals("")) {
            return true;
        }
        nbGlobalSection.put((Object)"ssl-client-cert-file", (Object)certFile);
        nbGlobalSection.put((Object)"ssl-client-cert-password", (Object)certPassword);
        return true;
    }

    private boolean setProxy(SVNUrl url, Profile.Section nbGlobalSection) {
        String host = SvnUtils.ripUserFromHost(url.getHost());
        Profile.Section svnGlobalSection = (Profile.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        URI uri = null;
        try {
            uri = new URI(url.toString());
        }
        catch (URISyntaxException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
            return true;
        }
        String proxyHost = NetworkSettings.getProxyHost((URI)uri);
        if (proxyHost != null && proxyHost.length() > 0) {
            String proxyPort = NetworkSettings.getProxyPort((URI)uri);
            assert (proxyPort != null);
            nbGlobalSection.put((Object)"http-proxy-host", (Object)proxyHost);
            nbGlobalSection.put((Object)"http-proxy-port", (Object)proxyPort);
            String username = NetworkSettings.getAuthenticationUsername((URI)uri);
            if (username != null) {
                String password = this.getProxyPassword(NetworkSettings.getKeyForAuthenticationPassword((URI)uri));
                nbGlobalSection.put((Object)"http-proxy-username", (Object)username);
                nbGlobalSection.put((Object)"http-proxy-password", (Object)password);
            }
        }
        this.mergeNonProxyKeys(host, svnGlobalSection, nbGlobalSection);
        return true;
    }

    private void mergeNonProxyKeys(String host, Profile.Section svnGlobalSection, Profile.Section nbGlobalSection) {
        Profile.Section svnHostGroup;
        if (svnGlobalSection != null) {
            this.mergeNonProxyKeys(svnGlobalSection, nbGlobalSection);
        }
        if ((svnHostGroup = this.getServerGroup(host)) != null) {
            this.mergeNonProxyKeys(svnHostGroup, nbGlobalSection);
        }
    }

    private void mergeNonProxyKeys(Profile.Section source, Profile.Section target) {
        for (String key : source.keySet()) {
            if (this.isProxyConfigurationKey(key)) continue;
            target.put((Object)key, source.get((Object)key));
        }
    }

    public void setExternalCommand(String tunnelName, String command) {
        if (command == null) {
            return;
        }
        if (Utilities.isWindows()) {
            command = command.replace("\\", "/");
        }
        Profile.Section tunnels = this.getSection(this.config, "tunnels", true);
        tunnels.put((Object)tunnelName, (Object)command);
        this.storeIni(this.config, "config");
    }

    public String getExternalCommand(String tunnelName) {
        Profile.Section tunnels = this.getSection(this.config, "tunnels", true);
        String cmd = (String)tunnels.get((Object)tunnelName);
        return cmd != null ? cmd : "";
    }

    private Profile.Section getSection(Ini ini, String key, boolean create) {
        Profile.Section section = (Profile.Section)ini.get((Object)key);
        if (section == null) {
            return ini.add(key);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIni(Ini ini, String iniFile) {
        FilterOutputStream bos = null;
        try {
            File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + iniFile));
            file.getParentFile().mkdirs();
            bos = FileUtils.createOutputStream((File)file);
            ini.store((OutputStream)bos);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, null, ex);
                }
            }
        }
    }

    public List<String> getGlobalIgnores() {
        String ignores;
        Profile.Section miscellany = (Profile.Section)this.config.get((Object)"miscellany");
        if (miscellany != null && (ignores = (String)miscellany.get((Object)"global-ignores")) != null && ignores.trim().length() > 0) {
            return SvnConfigFiles.parseGlobalIgnores(ignores);
        }
        return DEFAULT_GLOBAL_IGNORES;
    }

    public String getClientCertFile(String host) {
        return this.getMergeValue("ssl-client-cert-file", host);
    }

    public String getClientCertPassword(String host) {
        return this.getMergeValue("ssl-client-cert-password", host);
    }

    private String getMergeValue(String key, String host) {
        Profile.Section group = this.getServerGroup(host);
        if (group != null) {
            return (String)group.get((Object)key);
        }
        group = (Profile.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (group != null) {
            return (String)group.get((Object)key);
        }
        return null;
    }

    private static List<String> parseGlobalIgnores(String ignores) {
        StringTokenizer st = new StringTokenizer(ignores, " ");
        ArrayList<String> ret = new ArrayList<String>(10);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry.equals("")) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static String getUserConfigPath() {
        String t9yUserConfigPath = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (t9yUserConfigPath != null && t9yUserConfigPath.length() > 0) {
            return t9yUserConfigPath;
        }
        if (Utilities.isUnix()) {
            String path = System.getProperty("user.home");
            return path + "/" + UNIX_CONFIG_DIR;
        }
        if (Utilities.isWindows()) {
            return WINDOWS_CONFIG_DIR;
        }
        return "";
    }

    public static String getNBConfigPath() {
        String t9yNbConfigPath = System.getProperty("netbeans.t9y.svn.nb.config.path");
        if (t9yNbConfigPath != null && t9yNbConfigPath.length() > 0) {
            return t9yNbConfigPath;
        }
        String nbHome = Places.getUserDirectory().getAbsolutePath();
        return nbHome + "/config/svn/config/";
    }

    private Profile.Section getServerGroup(String host) {
        if (host == null || host.equals("")) {
            return null;
        }
        Profile.Section groups = (Profile.Section)this.svnServers.get((Object)GROUPS_SECTION);
        if (groups != null) {
            for (String key : groups.keySet()) {
                String value = (String)groups.get((Object)key);
                if (value == null || (value = value.trim()) == null || !this.match(value, host)) continue;
                return (Profile.Section)this.svnServers.get((Object)key);
            }
        }
        return null;
    }

    private boolean match(String value, String host) {
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            value = values[i].trim();
            if (value.equals("*") || value.equals(host)) {
                return true;
            }
            int idx = value.indexOf("*");
            if (idx <= -1 || !this.matchSegments(value, host)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSegments(String value, String host) {
        value = value.replace(".", "\\.");
        value = value.replace("*", ".*");
        Matcher m = Pattern.compile(value).matcher(host);
        return m.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ini copyConfigFileToIDEConfigDir(String fileName, IniFilePatcher patcher) {
        Ini systemIniFile = this.loadSystemIniFile(fileName);
        patcher.patch(systemIniFile);
        File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + File.separatorChar + fileName));
        FilterOutputStream bos = null;
        try {
            file.getParentFile().mkdirs();
            bos = FileUtils.createOutputStream((File)file);
            systemIniFile.store((OutputStream)bos);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, null, ex);
                }
            }
        }
        return systemIniFile;
    }

    private Ini loadSystemIniFile(String fileName) {
        String filePath = SvnConfigFiles.getUserConfigPath() + "/" + fileName;
        File file = FileUtil.normalizeFile((File)new File(filePath));
        Ini system = null;
        try {
            system = new Ini((Reader)new FileReader(file));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, system file not loaded: " + filePath, ex);
        }
        if (system == null) {
            system = new Ini();
            Subversion.LOG.warning("Could not load the file " + filePath + ". Falling back on svn defaults.");
        }
        Ini global = null;
        try {
            global = new Ini((Reader)new FileReader(SvnConfigFiles.getGlobalConfigPath() + "/" + fileName));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, global file not loaded: " + SvnConfigFiles.getGlobalConfigPath() + "/" + fileName, ex);
        }
        if (global != null) {
            this.merge(global, system);
        }
        return system;
    }

    private void merge(Ini source, Ini target) {
        for (String sectionName : source.keySet()) {
            Profile.Section sourceSection = (Profile.Section)source.get((Object)sectionName);
            Profile.Section targetSection = (Profile.Section)target.get((Object)sectionName);
            if (targetSection == null) {
                targetSection = target.add(sectionName);
            }
            for (String key : sourceSection.keySet()) {
                if (targetSection.containsKey((Object)key)) continue;
                targetSection.put((Object)key, sourceSection.get((Object)key));
            }
        }
    }

    private boolean isProxyConfigurationKey(String key) {
        return key.equals("http-proxy-host") || key.equals("http-proxy-port") || key.equals("http-proxy-username") || key.equals("http-proxy-password") || key.equals("http-proxy-exceptions");
    }

    private static String getGlobalConfigPath() {
        if (Utilities.isUnix()) {
            return "/etc/subversion";
        }
        if (Utilities.isWindows()) {
            return WINDOWS_GLOBAL_CONFIG_DIR;
        }
        return "";
    }

    private static String getAPPDATA() {
        String appdata = "";
        if (Utilities.isWindows()) {
            appdata = System.getenv("APPDATA");
        }
        return appdata != null ? appdata : "";
    }

    private static String getGlobalAPPDATA() {
        if (Utilities.isWindows()) {
            String appdataPath;
            String globalProfile = System.getenv("ALLUSERSPROFILE");
            if (globalProfile == null || globalProfile.trim().equals("")) {
                globalProfile = "";
            }
            if ((appdataPath = WINDOWS_USER_APPDATA) == null || appdataPath.equals("")) {
                return "";
            }
            return SvnConfigFiles.getWinUserAppdata(appdataPath, globalProfile);
        }
        return "";
    }

    private static String getWinUserAppdata(String appdataPath, String globalProfile) {
        appdataPath = SvnConfigFiles.trimBackslash(appdataPath);
        globalProfile = SvnConfigFiles.trimBackslash(globalProfile);
        String appdata = "";
        int idx = appdataPath.lastIndexOf("\\");
        if (idx > -1) {
            appdata = appdataPath.substring(idx + 1);
            if (appdata.trim().equals("")) {
                int previdx = appdataPath.lastIndexOf("\\", idx);
                if (idx > -1) {
                    appdata = appdataPath.substring(previdx + 1, idx);
                }
            }
        } else {
            return "";
        }
        if (globalProfile.endsWith("\\")) {
            globalProfile = globalProfile.substring(0, globalProfile.length() - 1);
        }
        return globalProfile + "/" + appdata;
    }

    private static String trimBackslash(String appdataPath) {
        if (appdataPath.endsWith("\\")) {
            appdataPath = appdataPath.substring(0, appdataPath.length() - 1);
        }
        return appdataPath;
    }

    private String getProxyPassword(String key) {
        char[] pwd = KeyringSupport.read((String)key, null);
        return pwd == null ? "" : new String(pwd);
    }

    static {
        WINDOWS_USER_APPDATA = SvnConfigFiles.getAPPDATA();
        WINDOWS_CONFIG_DIR = WINDOWS_USER_APPDATA + "\\Subversion";
        WINDOWS_GLOBAL_CONFIG_DIR = SvnConfigFiles.getGlobalAPPDATA() + "\\Subversion";
        DEFAULT_GLOBAL_IGNORES = SvnConfigFiles.parseGlobalIgnores("*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store");
    }

    private class ConfigIniFilePatcher
    implements IniFilePatcher {
        private ConfigIniFilePatcher() {
        }

        @Override
        public void patch(Ini file) {
            Profile.Section auth = (Profile.Section)file.get((Object)"auth");
            if (auth == null) {
                auth = file.add("auth");
            }
            auth.put((Object)"store-auth-creds", (Object)"yes");
            auth.put((Object)"store-passwords", (Object)"no");
            auth.put((Object)"password-stores", (Object)"");
        }
    }

    private static interface IniFilePatcher {
        public void patch(Ini var1);
    }
}

