/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLKeyException;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Cancellable;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(SvnClientInvocationHandler.class.getName());
    protected static final String GET_SINGLE_STATUS = "getSingleStatus";
    protected static final String GET_STATUS = "getStatus";
    protected static final String GET_INFO_FROM_WORKING_COPY = "getInfoFromWorkingCopy";
    protected static final String CANCEL_OPERATION = "cancel";
    private static final HashSet<String> PARALLELIZABLE_METHODS = new HashSet<String>(Arrays.asList("setConfigDirectory", "getSvnUrl", "addNotifyListener", "getIgnoredPatterns", "getStatus", "removeNotifyListener"));
    private static final Object semaphor = new Object();
    private final ISVNClientAdapter adapter;
    private final SvnClientDescriptor desc;
    private Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;
    private static boolean metricsAlreadyLogged = false;
    private final SvnClientFactory.ConnectionType connectionType;

    public SvnClientInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions, SvnClientFactory.ConnectionType connType) {
        assert (adapter != null);
        assert (desc != null);
        this.adapter = adapter;
        this.desc = desc;
        this.support = support;
        this.handledExceptions = handledExceptions;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException ex) {
                    Subversion.LOG.log(Level.SEVERE, null, ex);
                    return false;
                }
                return true;
            }
        };
        this.connectionType = connType;
    }

    private static String print(Object[] args) {
        if (args == null || args.length == 0) {
            return "no parameters";
        }
        StringBuilder sb = new StringBuilder();
        for (Object a : args) {
            sb.append("\n  ");
            if (a == null) {
                sb.append("null");
            } else {
                sb.append(a.toString());
                sb.append(" : ");
                sb.append(a.getClass().getName());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        List<File> files;
        boolean fsReadOnlyAction = this.isFSWrittingCommand(method);
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "~~~ SVN: invoking ''{0}'' with {1}", new Object[]{method.getName(), SvnClientInvocationHandler.print(args)});
            }
            Callable<Object> c = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    if (SvnClientInvocationHandler.this.parallelizable(method, args)) {
                        return SvnClientInvocationHandler.this.invokeMethod(method, args);
                    }
                    Object object = semaphor;
                    synchronized (object) {
                        return SvnClientInvocationHandler.this.invokeMethod(method, args);
                    }
                }
            };
            if (fsReadOnlyAction) {
                Object v = c.call();
                return v;
            }
            files = this.getFileParameters(args);
            if (files.size() > 0) {
                Object object = IndexingBridge.getInstance().runWithoutIndexing((Callable)c, files.toArray(new File[files.size()]));
                return object;
            }
            Object v = c.call();
            return v;
        }
        catch (Exception e) {
            block26: {
                if (!this.handleException((SvnClient)proxy, e, method.getName())) break block26;
                files = this.invoke(proxy, method, args);
                return files;
            }
            try {
                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof SVNClientException) {
                    throw t;
                }
                throw ite;
            }
            catch (SSLKeyException ex) {
                if (ex.getCause() instanceof InvalidKeyException) {
                    InvalidKeyException ike = (InvalidKeyException)ex.getCause();
                    if (ike.getMessage().toLowerCase().equals("illegal key size or default parameters")) {
                        SvnClientExceptionHandler.handleInvalidKeyException(ike);
                    }
                    Object var8_17 = null;
                    return var8_17;
                }
                throw ex;
            }
            catch (Throwable t) {
                Throwable c;
                if (t instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                if (t instanceof SVNClientException && (c = t.getCause()) instanceof IOException && (c = c.getCause()) instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                c = t.getCause();
                if (c != null) {
                    String exMessage = c.getMessage();
                    if (c instanceof InterruptedException || exMessage != null && SvnClientExceptionHandler.isOperationCancelled(exMessage)) {
                        throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                    }
                }
                if (this.support != null && this.support.isCanceled()) {
                    Subversion.LOG.log(Level.FINE, null, t);
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throw t;
            }
        }
        finally {
            if (fsReadOnlyAction) {
                Subversion.getInstance().getRefreshHandler().refresh();
            }
        }
    }

    private List<File> getFileParameters(Object[] args) {
        LinkedList<File> files = new LinkedList<File>();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof File) {
                    files.add((File)arg);
                    continue;
                }
                if (!(arg instanceof File[])) continue;
                File[] fs = (File[])arg;
                files.addAll(Arrays.asList(fs));
            }
        }
        return files;
    }

    private boolean isFSWrittingCommand(Method method) {
        return !method.getName().equals("update") && !method.getName().equals("revert") && !method.getName().equals("switchToUrl") && !method.getName().equals("remove") && !method.getName().equals("mkdir") && !method.getName().equals("checkout") && !method.getName().equals("copy") && !method.getName().equals("move") && !method.getName().equals("merge");
    }

    private void logClientInvoked() {
        if (metricsAlreadyLogged) {
            return;
        }
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException e) {
            return;
        }
        String client = null;
        if (SvnClientFactory.isCLI()) {
            client = "CLI";
        } else if (SvnClientFactory.isJavaHl()) {
            client = "JAVAHL";
        } else if (SvnClientFactory.isSvnKit()) {
            client = "SVNKIT";
        } else {
            Subversion.LOG.warning("Unknown client type!");
        }
        if (client != null) {
            Utils.logVCSClientEvent((String)"SVN", (String)client);
        }
        metricsAlreadyLogged = true;
    }

    private boolean parallelizable(Method method, Object[] args) {
        return this.isLocalReadCommand(method, args) || this.isCancelCommand(method, args) || PARALLELIZABLE_METHODS.contains(method.getName());
    }

    protected boolean isLocalReadCommand(Method method, Object[] args) {
        String methodName = method.getName();
        return methodName.equals(GET_SINGLE_STATUS) || methodName.equals(GET_INFO_FROM_WORKING_COPY) || method.getName().equals(GET_STATUS) && method.getParameterTypes().length == 3;
    }

    protected boolean isCancelCommand(Method method, Object[] args) {
        String methodName = method.getName();
        return Cancellable.class.isAssignableFrom(method.getDeclaringClass()) && methodName.equals(CANCEL_OPERATION);
    }

    protected Object invokeMethod(Method proxyMethod, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(proxyMethod, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handle(Method proxyMethod, Object[] args) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Class<?>[] parameters = proxyMethod.getParameterTypes();
        Class<?> declaringClass = proxyMethod.getDeclaringClass();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null || !(arg instanceof SVNUrl)) continue;
                try {
                    args[i] = SvnUtils.decodeAndEncodeUrl((SVNUrl)arg);
                    continue;
                }
                catch (MalformedURLException ex) {
                    Subversion.LOG.log(Level.INFO, "Url: " + arg, ex);
                }
            }
        }
        if (ISVNClientAdapter.class.isAssignableFrom(declaringClass)) {
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            if (this.desc != null && this.desc.getSvnUrl() != null) {
                SvnConfigFiles.getInstance().storeSvnServersSettings(this.desc.getSvnUrl(), this.connectionType);
                if (!this.parallelizable(proxyMethod, args) && !"getInfo".equals(proxyMethod.getName())) {
                    Utils.logVCSExternalRepository((String)"SVN", (String)this.desc.getSvnUrl().toString());
                }
            }
        } else {
            if (Cancellable.class.isAssignableFrom(declaringClass)) {
                return this.cancellable.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.cancellable, args);
            }
            if (!SvnClientDescriptor.class.isAssignableFrom(declaringClass)) return this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
            if (this.desc == null) throw new NoSuchMethodException(proxyMethod.getName());
            return this.desc.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.desc, args);
        }
        this.logClientInvoked();
        Object ret = this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
        if (this.support == null) return ret;
        this.support.setCancellableDelegate(null);
        return ret;
    }

    private boolean handleException(SvnClient client, Throwable t, String methodName) throws Throwable {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (!(t instanceof SVNClientException)) {
            throw t;
        }
        SvnClientExceptionHandler eh = new SvnClientExceptionHandler((SVNClientException)t, this.adapter, client, this.desc, this.handledExceptions, this.connectionType);
        eh.setMethod(methodName);
        return eh.handleException();
    }
}

