/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;

public class MatcherUtilities {
    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern) {
        return MatcherUtilities.matches(ctx, variable, pattern, null, null, null);
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern, boolean fillInVariablesHack) {
        return MatcherUtilities.matches(ctx, variable, pattern, ctx.getVariables(), ctx.getMultiVariables(), ctx.getVariableNames());
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern, Map<String, TreePath> outVariables, Map<String, Collection<? extends TreePath>> outMultiVariables, Map<String, String> outVariables2Names) {
        Scope s = Utilities.constructScope(ctx.getInfo(), Collections.<String, TypeMirror>emptyMap());
        Tree patternTree = Utilities.parseAndAttribute(ctx.getInfo(), pattern, s);
        TreePath patternTreePath = new TreePath(new TreePath(ctx.getInfo().getCompilationUnit()), patternTree);
        HashMap<String, TreePath> variables = new HashMap<String, TreePath>(ctx.getVariables());
        HashMap<String, Collection<? extends TreePath>> multiVariables = new HashMap<String, Collection<? extends TreePath>>(ctx.getMultiVariables());
        HashMap<String, String> variables2Names = new HashMap<String, String>(ctx.getVariableNames());
        if (CopyFinder.isDuplicate(ctx.getInfo(), patternTreePath, variable, true, variables, multiVariables, variables2Names, true, Collections.<VariableElement>emptySet(), new AtomicBoolean(), CopyFinder.Options.ALLOW_VARIABLES_IN_PATTERN)) {
            MatcherUtilities.outVariables(outVariables, variables, ctx.getVariables());
            MatcherUtilities.outVariables(outMultiVariables, multiVariables, ctx.getMultiVariables());
            MatcherUtilities.outVariables(outVariables2Names, variables2Names, ctx.getVariableNames());
            return true;
        }
        return false;
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull Collection<? extends TreePath> variable, @NonNull String pattern, Map<String, TreePath> outVariables, Map<String, Collection<? extends TreePath>> outMultiVariables, Map<String, String> outVariables2Names) {
        List<Tree> patternTrees;
        Scope s = Utilities.constructScope(ctx.getInfo(), Collections.<String, TypeMirror>emptyMap());
        Tree patternTree = Utilities.parseAndAttribute(ctx.getInfo(), pattern, s);
        if (Utilities.isFakeBlock(patternTree)) {
            List<? extends StatementTree> statements = ((BlockTree)patternTree).getStatements();
            patternTrees = statements.subList(1, statements.size() - 1);
        } else {
            patternTrees = Collections.singletonList(patternTree);
        }
        if (variable.size() != patternTrees.size()) {
            return false;
        }
        HashMap<String, TreePath> variables = new HashMap<String, TreePath>(ctx.getVariables());
        HashMap<String, Collection<? extends TreePath>> multiVariables = new HashMap<String, Collection<? extends TreePath>>(ctx.getMultiVariables());
        HashMap<String, String> variables2Names = new HashMap<String, String>(ctx.getVariableNames());
        Iterator<? extends TreePath> variableIt = variable.iterator();
        Iterator<Tree> patternTreesIt = patternTrees.iterator();
        while (variableIt.hasNext() && patternTreesIt.hasNext()) {
            TreePath patternTreePath = new TreePath(new TreePath(ctx.getInfo().getCompilationUnit()), patternTreesIt.next());
            if (CopyFinder.isDuplicate(ctx.getInfo(), patternTreePath, variableIt.next(), true, variables, multiVariables, variables2Names, true, Collections.<VariableElement>emptySet(), new AtomicBoolean(), CopyFinder.Options.ALLOW_VARIABLES_IN_PATTERN)) continue;
            return false;
        }
        if (variableIt.hasNext() == patternTreesIt.hasNext()) {
            MatcherUtilities.outVariables(outVariables, variables, ctx.getVariables());
            MatcherUtilities.outVariables(outMultiVariables, multiVariables, ctx.getMultiVariables());
            MatcherUtilities.outVariables(outVariables2Names, variables2Names, ctx.getVariableNames());
            return true;
        }
        return false;
    }

    private static <T> void outVariables(Map<String, T> outMap, Map<String, T> currentValues, Map<String, T> origValues) {
        if (outMap == null) {
            return;
        }
        for (String key : origValues.keySet()) {
            currentValues.remove(key);
        }
        outMap.putAll(currentValues);
    }
}

