/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.openide.util.NbPreferences;

public class Configuration {
    private String displayName;
    private String id;

    Configuration(String id, String displayName) {
        this.displayName = displayName;
        this.id = id;
        Preferences prefs = NbPreferences.forModule(this.getClass()).node(this.id());
        prefs.put("display.name", displayName);
    }

    public List<HintMetadata> getHints(Map<? extends HintMetadata, ? extends Iterable<? extends HintDescription>> allHints) {
        ArrayList<HintMetadata> hints = new ArrayList<HintMetadata>();
        for (HintMetadata hintMetadata : allHints.keySet()) {
            Preferences prefs;
            if (!HintsSettings.isEnabled(hintMetadata, prefs = RulesManager.getPreferences(hintMetadata.id, this.id()))) continue;
            hints.add(hintMetadata);
        }
        return Collections.unmodifiableList(hints);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String id() {
        return this.id;
    }

    public void setDisplayName(String displayName) {
        Preferences oldPrefs = NbPreferences.forModule(this.getClass()).node(this.id());
        oldPrefs.put("display.name", displayName);
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public void enable(String hintId) {
        RulesManager.getPreferences(hintId, this.id()).putBoolean("enabled", true);
    }
}

