/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.refactoring;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.batch.BatchSearch;
import org.netbeans.modules.java.hints.jackpot.impl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.jackpot.impl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public abstract class AbstractApplyHintsRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
ProgressHandleWrapper.ProgressHandleAbstraction {
    private final AbstractRefactoring refactoring;
    protected final AtomicBoolean cancel = new AtomicBoolean();
    private int lastWorkDone;

    protected AbstractApplyHintsRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }

    protected final Problem messagesToProblem(Collection<MessageImpl> problems) throws IllegalStateException {
        Problem current = null;
        for (MessageImpl problem : problems) {
            Problem p = new Problem(problem.kind == HintContext.MessageKind.ERROR, problem.text);
            if (current != null) {
                p.setNext(current);
            }
            current = p;
        }
        return current;
    }

    protected Collection<MessageImpl> performApplyPattern(Iterable<? extends HintDescription> pattern, BatchSearch.Scope scope, RefactoringElementsBag refactoringElements) {
        ProgressHandleWrapper w = new ProgressHandleWrapper(this, 30, 70);
        BatchSearch.BatchResult candidates = BatchSearch.findOccurrences(pattern, scope, w);
        LinkedList<MessageImpl> problems = new LinkedList<MessageImpl>(candidates.problems);
        Collection<ModificationResult> res = BatchUtilities.applyFixes(candidates, w, this.cancel, problems);
        refactoringElements.registerTransaction(JavaRefactoringPlugin.createTransaction(new LinkedList<ModificationResult>(res)));
        for (ModificationResult mr : res) {
            for (FileObject file : mr.getModifiedFileObjects()) {
                for (ModificationResult.Difference d : mr.getDifferences(file)) {
                    refactoringElements.add(this.refactoring, (RefactoringElementImplementation)DiffElement.create((ModificationResult.Difference)d, (FileObject)file, (ModificationResult)mr));
                }
            }
        }
        w.finish();
        return problems;
    }

    protected final void prepareElements(BatchSearch.BatchResult candidates, ProgressHandleWrapper w, final RefactoringElementsBag refactoringElements, final boolean verify, List<MessageImpl> problems) {
        if (verify) {
            BatchSearch.getVerifiedSpans(candidates, w, new BatchSearch.VerifiedSpansCallBack(){

                @Override
                public void groupStarted() {
                }

                @Override
                public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                    LinkedList<PositionBounds> spans = new LinkedList<PositionBounds>();
                    for (ErrorDescription errorDescription : hints) {
                        spans.add(errorDescription.getRange());
                    }
                    refactoringElements.addAll(AbstractApplyHintsRefactoringPlugin.this.refactoring, Utilities.createRefactoringElementImplementation(r.getResolvedFile(), spans, verify));
                    return true;
                }

                @Override
                public void groupFinished() {
                }

                @Override
                public void cannotVerifySpan(BatchSearch.Resource r) {
                    refactoringElements.addAll(AbstractApplyHintsRefactoringPlugin.this.refactoring, Utilities.createRefactoringElementImplementation(r.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(r), verify));
                }
            }, problems, this.cancel);
        } else {
            int[] parts = new int[candidates.getResources().size()];
            int index = 0;
            for (Collection<? extends BatchSearch.Resource> collection : candidates.getResources()) {
                parts[index++] = collection.size();
            }
            ProgressHandleWrapper inner = w.startNextPartWithEmbedding(parts);
            for (Collection<? extends BatchSearch.Resource> collection : candidates.getResources()) {
                inner.startNextPart(collection.size());
                for (BatchSearch.Resource resource : collection) {
                    refactoringElements.addAll(this.refactoring, Utilities.createRefactoringElementImplementation(resource.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(resource), verify));
                    inner.tick();
                }
            }
        }
    }

    private static List<PositionBounds> prepareSpansFor(BatchSearch.Resource r) {
        return Utilities.prepareSpansFor(r.getResolvedFile(), r.getCandidateSpans());
    }

    @Override
    public void start(int totalWork) {
        this.fireProgressListenerStart(-1, totalWork);
        this.lastWorkDone = 0;
    }

    @Override
    public void progress(int currentWorkDone) {
        while (this.lastWorkDone < currentWorkDone) {
            this.fireProgressListenerStep(currentWorkDone);
            ++this.lastWorkDone;
        }
    }

    @Override
    public void progress(String message) {
    }

    @Override
    public void finish() {
        this.fireProgressListenerStop();
    }
}

