/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.BulkSearch;
import org.netbeans.modules.java.hints.jackpot.impl.pm.Pattern;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.Trigger;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HintsInvoker {
    private final Map<String, Long> timeLog = new HashMap<String, Long>();
    private final CompilationInfo info;
    private final int caret;
    private final int from;
    private final int to;
    private final boolean bulkMode;
    private final AtomicBoolean cancel;
    private static final boolean logTimeSpentInHints = Boolean.getBoolean("java.HintsInvoker.time.in.hints");
    private final Map<String, Long> hint2SpentTime = new HashMap<String, Long>();

    public HintsInvoker(CompilationInfo info, AtomicBoolean cancel) {
        this(info, false, cancel);
    }

    public HintsInvoker(CompilationInfo info, boolean bulkMode, AtomicBoolean cancel) {
        this(info, -1, -1, -1, bulkMode, cancel);
    }

    public HintsInvoker(CompilationInfo info, int caret, AtomicBoolean cancel) {
        this(info, caret, -1, -1, false, cancel);
    }

    public HintsInvoker(CompilationInfo info, int from, int to, AtomicBoolean cancel) {
        this(info, -1, from, to, false, cancel);
    }

    private HintsInvoker(CompilationInfo info, int caret, int from, int to, boolean bulkMode, AtomicBoolean cancel) {
        this.info = info;
        this.caret = caret;
        this.from = from;
        this.to = to;
        this.bulkMode = bulkMode;
        this.cancel = cancel;
    }

    public List<ErrorDescription> computeHints(CompilationInfo info) {
        return this.computeHints(info, new TreePath(info.getCompilationUnit()));
    }

    private List<ErrorDescription> computeHints(CompilationInfo info, TreePath startAt) {
        LinkedList descs = new LinkedList();
        HashMap<HintMetadata, Collection<? extends HintDescription>> allHints = new HashMap<HintMetadata, Collection<? extends HintDescription>>(RulesManager.getInstance().allHints);
        long elementBasedStart = System.currentTimeMillis();
        LinkedList<HintDescription> elementBased = new LinkedList<HintDescription>();
        RulesManager.computeElementBasedHintsXXX(info, this.cancel, elementBased);
        allHints.putAll(org.netbeans.modules.java.hints.jackpot.impl.refactoring.Utilities.sortByMetadata(elementBased));
        long elementBasedEnd = System.currentTimeMillis();
        this.timeLog.put("Computing Element Based Hints", elementBasedEnd - elementBasedStart);
        for (Map.Entry e : allHints.entrySet()) {
            Preferences pref;
            HintMetadata m = (HintMetadata)e.getKey();
            if (!HintsSettings.isEnabled(m)) continue;
            if (this.caret != -1) {
                if (m.kind == HintMetadata.Kind.SUGGESTION) {
                    descs.addAll((Collection)e.getValue());
                    continue;
                }
                pref = RulesManager.getPreferences(m.id, HintsSettings.getCurrentProfileId());
                if (HintsSettings.getSeverity(m, pref) != AbstractHint.HintSeverity.CURRENT_LINE_WARNING) continue;
                descs.addAll((Collection)e.getValue());
                continue;
            }
            if (m.kind != HintMetadata.Kind.HINT || HintsSettings.getSeverity(m, pref = RulesManager.getPreferences(m.id, HintsSettings.getCurrentProfileId())) == AbstractHint.HintSeverity.CURRENT_LINE_WARNING) continue;
            descs.addAll((Collection)e.getValue());
        }
        List<ErrorDescription> errors = HintsInvoker.join(this.computeHints(info, startAt, descs, new LinkedList()));
        this.dumpTimeSpentInHints();
        return errors;
    }

    public List<ErrorDescription> computeHints(CompilationInfo info, Iterable<? extends HintDescription> hints) {
        return this.computeHints(info, hints, new LinkedList());
    }

    public List<ErrorDescription> computeHints(CompilationInfo info, Iterable<? extends HintDescription> hints, Collection<? super MessageImpl> problems) {
        return HintsInvoker.join(this.computeHints(info, new TreePath(info.getCompilationUnit()), hints, problems));
    }

    public Map<HintDescription, List<ErrorDescription>> computeHints(CompilationInfo info, TreePath startAt, Iterable<? extends HintDescription> hints, Collection<? super MessageImpl> problems) {
        HashMap<Class, List<HintDescription>> triggerKind2Hints = new HashMap<Class, List<HintDescription>>();
        for (Class<? extends Trigger> clazz : Trigger.TRIGGER_KINDS) {
            triggerKind2Hints.put(clazz, new ArrayList());
        }
        for (HintDescription hintDescription : hints) {
            List sorted = (List)triggerKind2Hints.get(hintDescription.getTrigger().getClass());
            sorted.add(hintDescription);
        }
        if (this.caret != -1) {
            TreePath tp = info.getTreeUtilities().pathFor(this.caret);
            return this.computeSuggestions(info, tp, triggerKind2Hints, problems);
        }
        if (this.from != -1 && this.to != -1) {
            return this.computeHintsInSpan(info, triggerKind2Hints, problems);
        }
        return this.computeHintsImpl(info, startAt, triggerKind2Hints, problems);
    }

    private Map<HintDescription, List<ErrorDescription>> computeHintsImpl(CompilationInfo info, TreePath startAt, Map<Class, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        this.timeLog.put("[C] Kind Based Hints", Long.valueOf(kindBasedHints.size()));
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            new ScannerImpl(info, this.cancel, HintsInvoker.sortByKinds(kindBasedHints), problems).scan(startAt, errors);
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", kindEnd - kindStart);
        }
        List<HintDescription> patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class);
        this.timeLog.put("[C] Pattern Based Hints", Long.valueOf(patternBasedHints.size()));
        long patternStart = System.currentTimeMillis();
        Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
        Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
        long bulkPatternStart = System.currentTimeMillis();
        BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(info, patternTests.keySet());
        long bulkPatternEnd = System.currentTimeMillis();
        this.timeLog.put("Bulk Pattern preparation", bulkPatternEnd - bulkPatternStart);
        long bulkStart = System.currentTimeMillis();
        Map<String, Collection<TreePath>> occurringPatterns = BulkSearch.getDefault().match(info, startAt, bulkPattern, this.timeLog);
        long bulkEnd = System.currentTimeMillis();
        this.timeLog.put("Bulk Search", bulkEnd - bulkStart);
        HintsInvoker.mergeAll(errors, this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems));
        long patternEnd = System.currentTimeMillis();
        this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        return errors;
    }

    private Map<HintDescription, List<ErrorDescription>> computeHintsInSpan(CompilationInfo info, Map<Class, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        List<HintDescription> patternBasedHints;
        TreePath path = info.getTreeUtilities().pathFor((this.from + this.to) / 2);
        while (path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), path.getLeaf());
            int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), path.getLeaf());
            if (start <= this.from && end >= this.to) break;
            path = path.getParentPath();
        }
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            new ScannerImpl(info, this.cancel, HintsInvoker.sortByKinds(kindBasedHints), problems).scan(path, errors);
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", kindEnd - kindStart);
        }
        if (!(patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class)).isEmpty()) {
            long patternStart = System.currentTimeMillis();
            Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
            Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
            long bulkStart = System.currentTimeMillis();
            BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(info, patternTests.keySet());
            Map<String, Collection<TreePath>> occurringPatterns = BulkSearch.getDefault().match(info, path, bulkPattern, this.timeLog);
            long bulkEnd = System.currentTimeMillis();
            this.timeLog.put("Bulk Search", bulkEnd - bulkStart);
            HintsInvoker.mergeAll(errors, this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems));
            long patternEnd = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        }
        if (path != null) {
            HintsInvoker.mergeAll(errors, this.computeSuggestions(info, path, triggerKind2Hints, problems));
        }
        return errors;
    }

    private Map<HintDescription, List<ErrorDescription>> computeSuggestions(CompilationInfo info, TreePath workOn, Map<Class, List<HintDescription>> triggerKind2Hints, Collection<? super MessageImpl> problems) {
        List<HintDescription> patternBasedHints;
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        List<HintDescription> kindBasedHints = triggerKind2Hints.get(Trigger.Kinds.class);
        if (!kindBasedHints.isEmpty()) {
            long kindStart = System.currentTimeMillis();
            Map<Tree.Kind, List<HintDescription>> hints = HintsInvoker.sortByKinds(kindBasedHints);
            for (TreePath proc = workOn; proc != null; proc = proc.getParentPath()) {
                new ScannerImpl(info, this.cancel, hints, problems).scanDoNotGoDeeper(proc, errors);
            }
            long kindEnd = System.currentTimeMillis();
            this.timeLog.put("Kind Based Suggestions", kindEnd - kindStart);
        }
        if (!(patternBasedHints = triggerKind2Hints.get(Trigger.PatternDescription.class)).isEmpty()) {
            long patternStart = System.currentTimeMillis();
            Map<Trigger.PatternDescription, List<HintDescription>> patternHints = HintsInvoker.sortByPatterns(patternBasedHints);
            Map<String, List<Trigger.PatternDescription>> patternTests = HintsInvoker.computePatternTests(patternHints);
            HashSet<TreePath> paths = new HashSet<TreePath>();
            for (TreePath tp = workOn; tp != null; tp = tp.getParentPath()) {
                paths.add(tp);
            }
            HashMap<String, Collection<TreePath>> occurringPatterns = new HashMap<String, Collection<TreePath>>();
            for (String p : patternTests.keySet()) {
                occurringPatterns.put(p, paths);
            }
            HintsInvoker.mergeAll(errors, this.doComputeHints(info, occurringPatterns, patternTests, patternHints, problems));
            long patternEnd = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", patternEnd - patternStart);
        }
        return errors;
    }

    public Map<HintDescription, List<ErrorDescription>> doComputeHints(CompilationInfo info, Map<String, Collection<TreePath>> occurringPatterns, Map<String, List<Trigger.PatternDescription>> patterns, Map<Trigger.PatternDescription, List<HintDescription>> patternHints) throws IllegalStateException {
        return this.doComputeHints(info, occurringPatterns, patterns, patternHints, new LinkedList());
    }

    private static Map<Tree.Kind, List<HintDescription>> sortByKinds(List<HintDescription> kindBasedHints) {
        EnumMap<Tree.Kind, List<HintDescription>> result = new EnumMap<Tree.Kind, List<HintDescription>>(Tree.Kind.class);
        for (HintDescription hd : kindBasedHints) {
            for (Tree.Kind kind : ((Trigger.Kinds)hd.getTrigger()).getKinds()) {
                ArrayList<HintDescription> hints = (ArrayList<HintDescription>)result.get((Object)kind);
                if (hints == null) {
                    hints = new ArrayList<HintDescription>();
                    result.put(kind, hints);
                }
                hints.add(hd);
            }
        }
        return result;
    }

    private static Map<Trigger.PatternDescription, List<HintDescription>> sortByPatterns(List<HintDescription> kindBasedHints) {
        HashMap<Trigger.PatternDescription, List<HintDescription>> result = new HashMap<Trigger.PatternDescription, List<HintDescription>>();
        for (HintDescription hd : kindBasedHints) {
            ArrayList<HintDescription> hints = (ArrayList<HintDescription>)result.get((Trigger.PatternDescription)hd.getTrigger());
            if (hints == null) {
                hints = new ArrayList<HintDescription>();
                result.put((Trigger.PatternDescription)hd.getTrigger(), hints);
            }
            hints.add(hd);
        }
        return result;
    }

    public static Map<String, List<Trigger.PatternDescription>> computePatternTests(Map<Trigger.PatternDescription, List<HintDescription>> patternHints) {
        HashMap<String, List<Trigger.PatternDescription>> patternTests = new HashMap<String, List<Trigger.PatternDescription>>();
        for (Map.Entry<Trigger.PatternDescription, List<HintDescription>> e : patternHints.entrySet()) {
            String p = e.getKey().getPattern();
            LinkedList<Trigger.PatternDescription> descs = (LinkedList<Trigger.PatternDescription>)patternTests.get(p);
            if (descs == null) {
                descs = new LinkedList<Trigger.PatternDescription>();
                patternTests.put(p, descs);
            }
            descs.add(e.getKey());
        }
        return patternTests;
    }

    private Map<HintDescription, List<ErrorDescription>> doComputeHints(CompilationInfo info, Map<String, Collection<TreePath>> occurringPatterns, Map<String, List<Trigger.PatternDescription>> patterns, Map<Trigger.PatternDescription, List<HintDescription>> patternHints, Collection<? super MessageImpl> problems) throws IllegalStateException {
        HashMap<HintDescription, List<ErrorDescription>> errors = new HashMap<HintDescription, List<ErrorDescription>>();
        for (Map.Entry<String, Collection<TreePath>> occ : occurringPatterns.entrySet()) {
            block1: for (Trigger.PatternDescription d : patterns.get(occ.getKey())) {
                HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
                for (Map.Entry<String, String> e : d.getConstraints().entrySet()) {
                    TypeMirror designedType = Hacks.parseFQNType(info, e.getValue());
                    if (designedType == null || designedType.getKind() == TypeKind.ERROR) continue block1;
                    constraints.put(e.getKey(), designedType);
                }
                Pattern p = Pattern.compile(info, occ.getKey(), constraints, d.getImports());
                TreePath toplevel = new TreePath(info.getCompilationUnit());
                TreePath patt = new TreePath(toplevel, p.getPattern());
                for (TreePath candidate : occ.getValue()) {
                    CopyFinder.VariableAssignments verified = CopyFinder.computeVariables(info, patt, candidate, this.cancel, p.getConstraints());
                    if (verified == null) continue;
                    HashSet<? extends String> suppressedWarnings = new HashSet<String>(Utilities.findSuppressedWarnings(info, candidate));
                    for (HintDescription hd : patternHints.get(d)) {
                        Collection<? extends ErrorDescription> workerErrors;
                        HintMetadata hm = hd.getMetadata();
                        HintContext c = new HintContext(info, hm, candidate, verified.variables, verified.multiVariables, verified.variables2Names, constraints, problems, this.bulkMode, this.cancel);
                        if (!Collections.disjoint(suppressedWarnings, hm.suppressWarnings) || (workerErrors = this.runHint(hd, c)) == null) continue;
                        HintsInvoker.merge(errors, hd, workerErrors);
                    }
                }
            }
        }
        return errors;
    }

    public Map<String, Long> getTimeLog() {
        return this.timeLog;
    }

    static boolean isInGuarded(CompilationInfo info, TreePath tree) {
        if (info == null) {
            return false;
        }
        try {
            Document doc = info.getDocument();
            if (doc instanceof GuardedDocument) {
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree.getLeaf());
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree.getLeaf());
                GuardedDocument gdoc = (GuardedDocument)doc;
                MarkBlockChain guardedBlockChain = gdoc.getGuardedBlockChain();
                if (guardedBlockChain.compareBlock(start, end) == 4129) {
                    return true;
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends ErrorDescription> runHint(HintDescription hd, HintContext ctx) {
        long start = System.nanoTime();
        try {
            Collection<? extends ErrorDescription> collection = hd.getWorker().createErrors(ctx);
            return collection;
        }
        finally {
            long end = System.nanoTime();
            this.reportSpentTime(hd.getMetadata().id, end - start);
        }
    }

    public static <K, V> Map<K, List<V>> merge(Map<K, List<V>> to, K key, Collection<? extends V> value) {
        List<V> toColl = to.get(key);
        if (toColl == null) {
            toColl = new LinkedList<V>();
            to.put(key, toColl);
        }
        toColl.addAll(value);
        return to;
    }

    public static <K, V> Map<K, List<V>> mergeAll(Map<K, List<V>> to, Map<? extends K, ? extends Collection<? extends V>> what) {
        for (Map.Entry<K, Collection<V>> e : what.entrySet()) {
            List<V> toColl = to.get(e.getKey());
            if (toColl == null) {
                toColl = new LinkedList<V>();
                to.put(e.getKey(), toColl);
            }
            toColl.addAll(e.getValue());
        }
        return to;
    }

    public static List<ErrorDescription> join(Map<?, ? extends List<? extends ErrorDescription>> errors) {
        LinkedList<ErrorDescription> result = new LinkedList<ErrorDescription>();
        for (Map.Entry<?, List<ErrorDescription>> e : errors.entrySet()) {
            result.addAll((Collection<ErrorDescription>)e.getValue());
        }
        return result;
    }

    private void reportSpentTime(String id, long nanoTime) {
        if (!logTimeSpentInHints) {
            return;
        }
        Long prev = this.hint2SpentTime.get(id);
        if (prev == null) {
            prev = 0L;
        }
        this.hint2SpentTime.put(id, prev + nanoTime);
    }

    private void dumpTimeSpentInHints() {
        if (!logTimeSpentInHints) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> l = new ArrayList<Map.Entry<String, Long>>(this.hint2SpentTime.entrySet());
        Collections.sort(l, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return (int)Math.signum(o1.getValue() - o2.getValue());
            }
        });
        for (Map.Entry entry : l) {
            System.err.println((String)entry.getKey() + "=" + String.format("%3.2f", (double)((Long)entry.getValue()).longValue() / 1000000.0));
        }
    }

    private final class ScannerImpl
    extends CancellableTreePathScanner<Void, Map<HintDescription, List<ErrorDescription>>> {
        private final Stack<Set<String>> suppresWarnings;
        private final CompilationInfo info;
        private final FileObject file;
        private final ProcessingEnvironment env;
        private final Map<Tree.Kind, List<HintDescription>> hints;
        private final Collection<? super MessageImpl> problems;

        public ScannerImpl(CompilationInfo info, AtomicBoolean cancel, Map<Tree.Kind, List<HintDescription>> hints, Collection<? super MessageImpl> problems) {
            super(cancel);
            this.suppresWarnings = new Stack();
            this.info = info;
            this.file = null;
            this.env = null;
            this.hints = hints;
            this.problems = problems;
        }

        public ScannerImpl(FileObject file, ProcessingEnvironment env, Map<Tree.Kind, List<HintDescription>> hints, Collection<? super MessageImpl> problems) {
            super(new AtomicBoolean());
            this.suppresWarnings = new Stack();
            this.info = null;
            this.file = file;
            this.env = env;
            this.hints = hints;
            this.problems = problems;
        }

        private void runAndAdd(TreePath path, List<HintDescription> rules, Map<HintDescription, List<ErrorDescription>> d) {
            if (rules != null && !HintsInvoker.isInGuarded(this.info, path)) {
                block0: for (HintDescription hd : rules) {
                    if (this.isCanceled()) {
                        return;
                    }
                    HintMetadata hm = hd.getMetadata();
                    for (String string : hm.suppressWarnings) {
                        if (this.suppresWarnings.empty() || !this.suppresWarnings.peek().contains(string)) continue;
                        continue block0;
                    }
                    HintContext c = new HintContext(this.info, hm, path, Collections.<String, TreePath>emptyMap(), Collections.<String, Collection<TreePath>>emptyMap(), Collections.<String, String>emptyMap(), Collections.<String, TypeMirror>emptyMap(), new ArrayList(), HintsInvoker.this.bulkMode, HintsInvoker.this.cancel);
                    Collection collection = HintsInvoker.this.runHint(hd, c);
                    if (collection == null) continue;
                    HintsInvoker.merge(d, hd, collection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(Tree tree, Map<HintDescription, List<ErrorDescription>> p) {
            if (tree == null) {
                return null;
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind k = tree.getKind();
            boolean b = this.pushSuppressWarrnings(tp);
            try {
                this.runAndAdd(tp, this.hints.get((Object)k), p);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(tree, p);
                return void_;
            }
            finally {
                if (b) {
                    this.suppresWarnings.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(TreePath path, Map<HintDescription, List<ErrorDescription>> p) {
            Tree.Kind k = path.getLeaf().getKind();
            boolean b = this.pushSuppressWarrnings(path);
            try {
                this.runAndAdd(path, this.hints.get((Object)k), p);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(path, p);
                return void_;
            }
            finally {
                if (b) {
                    this.suppresWarnings.pop();
                }
            }
        }

        public void scanDoNotGoDeeper(TreePath path, Map<HintDescription, List<ErrorDescription>> p) {
            Tree.Kind k = path.getLeaf().getKind();
            this.runAndAdd(path, this.hints.get((Object)k), p);
        }

        private boolean pushSuppressWarrnings(TreePath path) {
            switch (path.getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case METHOD: 
                case VARIABLE: {
                    Set<String> current = this.suppresWarnings.size() == 0 ? null : this.suppresWarnings.peek();
                    HashSet<String> nju = current == null ? new HashSet<String>() : new HashSet<String>(current);
                    Element e = this.getTrees().getElement(path);
                    if (e != null) {
                        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                            String name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                            if (!"java.lang.SuppressWarnings".equals(name)) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                                Object value;
                                if (!"value".equals(entry.getKey().getSimpleName().toString()) || !((value = entry.getValue().getValue()) instanceof List)) continue;
                                for (Object av : (List)value) {
                                    Object wname;
                                    if (!(av instanceof AnnotationValue) || !((wname = ((AnnotationValue)av).getValue()) instanceof String)) continue;
                                    nju.add((String)wname);
                                }
                            }
                        }
                    }
                    this.suppresWarnings.push(nju);
                    return true;
                }
            }
            return false;
        }

        private Trees getTrees() {
            return this.info != null ? this.info.getTrees() : Trees.instance(this.env);
        }
    }
}

