/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class FinalizeNotProtected {
    public static ErrorDescription hint(HintContext ctx) {
        Set<Modifier> modifiers;
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree tree = (MethodTree)tp.getLeaf();
        if (Util.isFinalize(tree) && (modifiers = tree.getModifiers().getFlags()).contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName(ctx, tp, NbBundle.getMessage(FinalizeNotProtected.class, (String)"TXT_FinalizeNotProtected"), JavaFix.toEditorFix(new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()))), FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath(), "FinalizeNotProtected"));
        }
        return null;
    }

    static class FixImpl
    extends JavaFix {
        FixImpl(TreePathHandle handle) {
            super(handle);
            assert (handle != null);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(FinalizeNotProtected.class, (String)"FIX_FinalizeNotProtected_MakePublic");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, boolean canShowUI) {
            Tree tree = tp.getLeaf();
            if (tree.getKind() != Tree.Kind.METHOD) {
                return;
            }
            TreeMaker tm = wc.getTreeMaker();
            wc.rewrite((Tree)((MethodTree)tree).getModifiers(), (Tree)tm.addModifiersModifier(tm.removeModifiersModifier(((MethodTree)tree).getModifiers(), Modifier.PUBLIC), Modifier.PROTECTED));
        }
    }
}

