/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;

public final class CreateElementUtilities {
    private static final Set<Tree.Kind> STOP_LOOKING_FOR_METHOD = EnumSet.of(Tree.Kind.METHOD, new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.COMPILATION_UNIT});

    private CreateElementUtilities() {
    }

    public static List<? extends TypeMirror> resolveType(Set<ElementKind> types, CompilationInfo info, TreePath currentPath, Tree unresolved, int offset, TypeMirror[] typeParameterBound, int[] numTypeParameters) {
        switch (currentPath.getLeaf().getKind()) {
            case METHOD: {
                return CreateElementUtilities.computeMethod(types, info, currentPath, typeParameterBound, unresolved, offset);
            }
            case MEMBER_SELECT: {
                return CreateElementUtilities.computeMemberSelect(types, info, currentPath, unresolved, offset);
            }
            case ASSIGNMENT: {
                return CreateElementUtilities.computeAssignment(types, info, currentPath, unresolved, offset);
            }
            case ENHANCED_FOR_LOOP: {
                return CreateElementUtilities.computeEnhancedForLoop(types, info, currentPath, unresolved, offset);
            }
            case ARRAY_ACCESS: {
                return CreateElementUtilities.computeArrayAccess(types, info, currentPath, unresolved, offset);
            }
            case VARIABLE: {
                return CreateElementUtilities.computeVariableDeclaration(types, info, currentPath, unresolved, offset);
            }
            case ASSERT: {
                return CreateElementUtilities.computeAssert(types, info, currentPath, unresolved, offset);
            }
            case PARENTHESIZED: {
                return CreateElementUtilities.computeParenthesis(types, info, currentPath, unresolved, offset);
            }
            case DO_WHILE_LOOP: {
                return CreateElementUtilities.computePrimitiveType(types, info, ((DoWhileLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case FOR_LOOP: {
                return CreateElementUtilities.computePrimitiveType(types, info, ((ForLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case IF: {
                return CreateElementUtilities.computePrimitiveType(types, info, ((IfTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case WHILE_LOOP: {
                return CreateElementUtilities.computePrimitiveType(types, info, ((WhileLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case SYNCHRONIZED: {
                return CreateElementUtilities.computeReferenceType(types, info, ((SynchronizedTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Object");
            }
            case THROW: {
                return CreateElementUtilities.computeReferenceType(types, info, ((ThrowTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Exception");
            }
            case INSTANCE_OF: {
                return CreateElementUtilities.computeReferenceType(types, info, ((InstanceOfTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Object");
            }
            case SWITCH: {
                return CreateElementUtilities.computePrimitiveType(types, info, ((SwitchTree)currentPath.getLeaf()).getExpression(), unresolved, TypeKind.INT);
            }
            case EXPRESSION_STATEMENT: {
                return Collections.singletonList(info.getTypes().getNoType(TypeKind.VOID));
            }
            case RETURN: {
                return CreateElementUtilities.computeReturn(types, info, currentPath, unresolved, offset);
            }
            case TYPE_PARAMETER: {
                return CreateElementUtilities.computeTypeParameter(types, info, currentPath, unresolved, offset);
            }
            case PARAMETERIZED_TYPE: {
                return CreateElementUtilities.computeParametrizedType(types, info, currentPath, unresolved, offset, typeParameterBound, numTypeParameters);
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return CreateElementUtilities.computeClass(types, info, currentPath, unresolved, offset);
            }
            case CONDITIONAL_EXPRESSION: {
                return CreateElementUtilities.computeConditionalExpression(types, info, currentPath, unresolved, offset);
            }
            case NEW_ARRAY: {
                return CreateElementUtilities.computeNewArray(types, info, currentPath, unresolved, offset);
            }
            case METHOD_INVOCATION: {
                return CreateElementUtilities.computeMethodInvocation(types, info, currentPath, unresolved, offset);
            }
            case NEW_CLASS: {
                return CreateElementUtilities.computeNewClass(types, info, currentPath, unresolved, offset);
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                return CreateElementUtilities.computeUnary(types, info, currentPath, unresolved, offset);
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return CreateElementUtilities.computeBinaryOperator(types, info, currentPath, unresolved, offset);
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                return null;
            }
            case ARRAY_TYPE: {
                return CreateElementUtilities.computeArrayType(types, info, currentPath, unresolved, offset);
            }
            case IMPORT: {
                return CreateElementUtilities.computeImport(types, info, currentPath, unresolved, offset);
            }
            case BLOCK: 
            case BREAK: 
            case CATCH: 
            case COMPILATION_UNIT: 
            case CONTINUE: 
            case IDENTIFIER: 
            case TYPE_CAST: 
            case TRY: 
            case EMPTY_STATEMENT: 
            case PRIMITIVE_TYPE: 
            case LABELED_STATEMENT: 
            case MODIFIERS: 
            case ERRONEOUS: 
            case OTHER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                return null;
            }
            case CASE: 
            case ANNOTATION: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                return null;
            }
        }
        return null;
    }

    private static List<? extends TypeMirror> computeBinaryOperator(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        BinaryTree bt = (BinaryTree)parent.getLeaf();
        TreePath typeToResolve = null;
        if (bt.getLeftOperand() == error) {
            typeToResolve = new TreePath(parent, bt.getRightOperand());
        }
        if (bt.getRightOperand() == error) {
            typeToResolve = new TreePath(parent, bt.getLeftOperand());
        }
        types.add(ElementKind.PARAMETER);
        types.add(ElementKind.LOCAL_VARIABLE);
        types.add(ElementKind.FIELD);
        return typeToResolve != null ? Collections.singletonList(info.getTrees().getTypeMirror(typeToResolve)) : null;
    }

    private static List<? extends TypeMirror> computeMethod(Set<ElementKind> types, CompilationInfo info, TreePath parent, TypeMirror[] typeParameterBound, Tree error, int offset) {
        List<? extends ExpressionTree> throwList;
        MethodTree mt = (MethodTree)parent.getLeaf();
        if (mt.getReturnType() == error) {
            types.add(ElementKind.CLASS);
            types.add(ElementKind.INTERFACE);
            types.add(ElementKind.ENUM);
        }
        if ((throwList = mt.getThrows()) != null && !throwList.isEmpty()) {
            for (ExpressionTree expressionTree : throwList) {
                if (expressionTree != error) continue;
                types.add(ElementKind.CLASS);
                typeParameterBound[0] = info.getElements().getTypeElement("java.lang.Exception").asType();
                break;
            }
        }
        if (mt.getBody() == null) {
            return null;
        }
        try {
            Document doc = info.getDocument();
            if (doc != null) {
                int n = org.netbeans.modules.java.editor.semantic.Utilities.findBodyStart((Tree)parent.getLeaf(), (CompilationUnitTree)info.getCompilationUnit(), (SourcePositions)info.getTrees().getSourcePositions(), (Document)doc);
                int bodyEnd = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), parent.getLeaf());
                types.add(ElementKind.PARAMETER);
                types.add(ElementKind.LOCAL_VARIABLE);
                types.add(ElementKind.FIELD);
                if (n <= offset && offset <= bodyEnd) {
                    return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.INFO, ex.getMessage(), ex);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMemberSelect(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        MemberSelectTree ms = (MemberSelectTree)parent.getLeaf();
        TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
        if (jlObject != null && !"class".equals(ms.getIdentifier().toString())) {
            types.add(ElementKind.FIELD);
            types.add(ElementKind.CLASS);
            return Collections.singletonList(jlObject.asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeAssignment(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        AssignmentTree at = (AssignmentTree)parent.getLeaf();
        TypeMirror type = null;
        if (at.getVariable() == error && (type = info.getTrees().getTypeMirror(new TreePath(parent, at.getExpression()))) != null && (type = Utilities.convertIfAnonymous(type)).getKind() == TypeKind.EXECUTABLE) {
            type = ((ExecutableType)type).getReturnType();
        }
        if (at.getExpression() == error) {
            type = info.getTrees().getTypeMirror(new TreePath(parent, at.getVariable()));
        }
        if (type == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "offset=" + offset);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + error);
                ErrorHintsProvider.ERR.log(1, "type=null");
            }
            return null;
        }
        types.add(ElementKind.PARAMETER);
        types.add(ElementKind.LOCAL_VARIABLE);
        types.add(ElementKind.FIELD);
        return Collections.singletonList(type);
    }

    private static List<? extends TypeMirror> computeEnhancedForLoop(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        EnhancedForLoopTree efl = (EnhancedForLoopTree)parent.getLeaf();
        if (efl.getExpression() != error) {
            return null;
        }
        TypeMirror argument = info.getTrees().getTypeMirror(new TreePath(new TreePath(parent, efl.getVariable()), efl.getVariable().getType()));
        if (argument == null) {
            return null;
        }
        if (argument.getKind().isPrimitive()) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getArrayType(argument));
        }
        TypeElement iterable = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterable == null) {
            return null;
        }
        types.add(ElementKind.PARAMETER);
        types.add(ElementKind.LOCAL_VARIABLE);
        types.add(ElementKind.FIELD);
        return Collections.singletonList(info.getTypes().getDeclaredType(iterable, argument));
    }

    private static List<? extends TypeMirror> computeArrayAccess(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ArrayAccessTree aat = (ArrayAccessTree)parent.getLeaf();
        if (aat.getExpression() == error) {
            TreePath parentParent = parent.getParentPath();
            List<? extends TypeMirror> upperTypes = CreateElementUtilities.resolveType(types, info, parentParent, aat, offset, null, null);
            if (upperTypes == null) {
                return null;
            }
            ArrayList<ArrayType> arrayTypes = new ArrayList<ArrayType>();
            block3: for (TypeMirror typeMirror : upperTypes) {
                if (typeMirror == null) continue;
                switch (typeMirror.getKind()) {
                    case VOID: 
                    case EXECUTABLE: 
                    case WILDCARD: 
                    case PACKAGE: {
                        continue block3;
                    }
                }
                arrayTypes.add(info.getTypes().getArrayType(typeMirror));
            }
            if (arrayTypes.isEmpty()) {
                return null;
            }
            return arrayTypes;
        }
        if (aat.getIndex() == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeVariableDeclaration(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        VariableTree vt = (VariableTree)parent.getLeaf();
        if (vt.getInitializer() == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTrees().getTypeMirror(new TreePath(parent, vt.getType())));
        }
        TreePath context = parent.getParentPath();
        if (vt.getType() != error || context == null) {
            return null;
        }
        switch (context.getLeaf().getKind()) {
            case ENHANCED_FOR_LOOP: {
                ExpressionTree iterableTree = ((EnhancedForLoopTree)context.getLeaf()).getExpression();
                TreePath iterablePath = new TreePath(context, iterableTree);
                TypeMirror type = Utilities.getIterableGenericType(info, iterablePath);
                types.add(ElementKind.LOCAL_VARIABLE);
                return Collections.singletonList(type);
            }
        }
        types.add(ElementKind.CLASS);
        return Collections.emptyList();
    }

    private static List<? extends TypeMirror> computeAssert(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        AssertTree at = (AssertTree)parent.getLeaf();
        types.add(ElementKind.PARAMETER);
        types.add(ElementKind.LOCAL_VARIABLE);
        types.add(ElementKind.FIELD);
        if (at.getCondition() == error) {
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (at.getDetail() == error) {
            return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParenthesis(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ParenthesizedTree pt = (ParenthesizedTree)parent.getLeaf();
        if (pt.getExpression() != error) {
            return null;
        }
        TreePath parentParent = parent.getParentPath();
        List<? extends TypeMirror> upperTypes = CreateElementUtilities.resolveType(types, info, parentParent, pt, offset, null, null);
        if (upperTypes == null) {
            return null;
        }
        return upperTypes;
    }

    private static List<? extends TypeMirror> computeConditionalExpression(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ConditionalExpressionTree cet = (ConditionalExpressionTree)parent.getLeaf();
        if (cet.getCondition() == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (cet.getTrueExpression() == error || cet.getFalseExpression() == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return CreateElementUtilities.resolveType(types, info, parent.getParentPath(), cet, offset, null, null);
        }
        return null;
    }

    private static List<? extends TypeMirror> computePrimitiveType(Set<ElementKind> types, CompilationInfo info, Tree expression, Tree error, TypeKind kind) {
        if (expression == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(kind));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReferenceType(Set<ElementKind> types, CompilationInfo info, Tree expression, Tree error, String type) {
        if (expression == error) {
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getElements().getTypeElement(type).asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeImport(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ImportTree tree = (ImportTree)parent.getLeaf();
        if (tree.getQualifiedIdentifier() == error) {
            types.add(ElementKind.ANNOTATION_TYPE);
            types.add(ElementKind.CLASS);
            types.add(ElementKind.ENUM);
            types.add(ElementKind.INTERFACE);
            return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeUnary(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        UnaryTree tree = (UnaryTree)parent.getLeaf();
        if (tree.getExpression() == error) {
            List<? extends TypeMirror> parentTypes = CreateElementUtilities.resolveType(types, info, parent.getParentPath(), tree, offset, null, null);
            if (parentTypes != null) {
                if (parentTypes.size() != 1) {
                    return parentTypes;
                }
                if (parentTypes.get(0).getKind() != TypeKind.VOID) {
                    return parentTypes;
                }
            }
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReturn(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ReturnTree rt = (ReturnTree)parent.getLeaf();
        if (rt.getExpression() == error) {
            TreePath method = CreateElementUtilities.findMethod(parent);
            if (method == null) {
                return null;
            }
            Element el = info.getTrees().getElement(method);
            if (el == null || el.getKind() != ElementKind.METHOD) {
                return null;
            }
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(((ExecutableElement)el).getReturnType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeTypeParameter(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        TypeParameterTree tpt = (TypeParameterTree)parent.getLeaf();
        for (Tree tree : tpt.getBounds()) {
            if (tree != error) continue;
            types.add(ElementKind.CLASS);
            return null;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParametrizedType(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset, TypeMirror[] typeParameterBound, int[] numTypeParameters) {
        ParameterizedTypeTree ptt = (ParameterizedTypeTree)parent.getLeaf();
        if (ptt.getType() == error) {
            Tree gpt = parent.getParentPath().getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)gpt.getKind()) && ((ClassTree)gpt).getExtendsClause() == ptt) {
                types.add(ElementKind.CLASS);
            } else if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)gpt.getKind()) && ((ClassTree)gpt).getImplementsClause().contains(ptt)) {
                types.add(ElementKind.INTERFACE);
            } else {
                types.add(ElementKind.CLASS);
                types.add(ElementKind.INTERFACE);
            }
            if (numTypeParameters != null) {
                numTypeParameters[0] = ptt.getTypeArguments().size();
            }
            return null;
        }
        TypeMirror resolved = info.getTrees().getTypeMirror(parent);
        DeclaredType resolvedDT = null;
        if (resolved != null && resolved.getKind() == TypeKind.DECLARED) {
            resolvedDT = (DeclaredType)resolved;
        }
        int index = 0;
        for (Tree tree : ptt.getTypeArguments()) {
            if (tree == error) {
                List<? extends TypeMirror> typeArguments;
                if (resolvedDT != null && typeParameterBound != null && (typeArguments = ((DeclaredType)resolvedDT.asElement().asType()).getTypeArguments()).size() > index) {
                    typeParameterBound[0] = ((TypeVariable)typeArguments.get(index)).getUpperBound();
                }
                types.add(ElementKind.CLASS);
                return null;
            }
            ++index;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeClass(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ClassTree ct = (ClassTree)parent.getLeaf();
        if (ct.getExtendsClause() == error) {
            types.add(ElementKind.CLASS);
            return null;
        }
        for (Tree tree : ct.getImplementsClause()) {
            if (tree != error) continue;
            types.add(ElementKind.INTERFACE);
            return null;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeNewArray(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        NewArrayTree nat = (NewArrayTree)parent.getLeaf();
        if (nat.getType() == error) {
            types.add(ElementKind.CLASS);
            types.add(ElementKind.ENUM);
            types.add(ElementKind.INTERFACE);
            return null;
        }
        for (ExpressionTree expressionTree : nat.getDimensions()) {
            if (expressionTree != error) continue;
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.INT));
        }
        for (ExpressionTree expressionTree : nat.getInitializers()) {
            if (expressionTree != error) continue;
            TypeMirror whole = info.getTrees().getTypeMirror(parent);
            if (whole == null || whole.getKind() != TypeKind.ARRAY) {
                return null;
            }
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(((ArrayType)whole).getComponentType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMethodInvocation(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        MethodInvocationTree nat = (MethodInvocationTree)parent.getLeaf();
        boolean errorInRealArguments = false;
        for (ExpressionTree expressionTree : nat.getArguments()) {
            errorInRealArguments |= expressionTree == error;
        }
        if (errorInRealArguments) {
            TypeMirror[] proposedType = new TypeMirror[1];
            int[] nArray = new int[1];
            ExecutableElement ee = org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)parent, (TypeMirror[])proposedType, (int[])nArray);
            if (ee == null) {
                return null;
            }
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(proposedType[0]);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeNewClass(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        NewClassTree nct = (NewClassTree)parent.getLeaf();
        boolean errorInRealArguments = false;
        for (ExpressionTree expressionTree : nct.getArguments()) {
            errorInRealArguments |= expressionTree == error;
        }
        if (errorInRealArguments) {
            TypeMirror[] proposedType = new TypeMirror[1];
            int[] nArray = new int[1];
            ExecutableElement ee = org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)parent, (TypeMirror[])proposedType, (int[])nArray);
            if (ee == null) {
                return null;
            }
            types.add(ElementKind.PARAMETER);
            types.add(ElementKind.LOCAL_VARIABLE);
            types.add(ElementKind.FIELD);
            return Collections.singletonList(proposedType[0]);
        }
        Tree id = nct.getIdentifier();
        if (id.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            id = ((ParameterizedTypeTree)id).getType();
        }
        if (id == error) {
            return CreateElementUtilities.resolveType(EnumSet.noneOf(ElementKind.class), info, parent.getParentPath(), nct, offset, null, null);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeArrayType(Set<ElementKind> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        types.add(ElementKind.CLASS);
        return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
    }

    private static TreePath findMethod(TreePath tp) {
        while (!STOP_LOOKING_FOR_METHOD.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
            return tp;
        }
        return null;
    }
}

