/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class CollectionRemove {
    static final String SUPPRESS_WARNING_KEY = "element-type-mismatch";
    static final String WARN_FOR_CASTABLE_KEY = "warn-for-castable";
    static final boolean WARN_FOR_CASTABLE_DEFAULT = true;
    private static final Pattern SPLIT = Pattern.compile("(.+)\\.([^.]+)\\((.*)\\)");

    public static List<ErrorDescription> collectionRemove(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Collection.remove(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> collectionContains(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Collection.contains(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapRemove(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.remove(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapGet(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.get(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsKey(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.containsKey(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsValue(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.containsValue(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 1);
    }

    private static List<ErrorDescription> run(HintContext ctx, String checkMethod, String checkAgainst, int ... parameterMapping) {
        DeclaredType site;
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree select = mit.getMethodSelect();
        TreePath method = new TreePath(ctx.getPath(), select);
        Element el = ctx.getInfo().getTrees().getElement(method);
        if (el == null || el.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement invoked = (ExecutableElement)el;
        TypeElement owner = (TypeElement)invoked.getEnclosingElement();
        LinkedList<ErrorDescription> result = new LinkedList<ErrorDescription>();
        ExecutableElement toCheckAgainst = CollectionRemove.resolveMethod(ctx.getInfo(), checkAgainst);
        if (toCheckAgainst == null) {
            return null;
        }
        block0 : switch (select.getKind()) {
            case MEMBER_SELECT: {
                TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(method, ((MemberSelectTree)select).getExpression()));
                if (tm != null && tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                    site = (DeclaredType)tm;
                    break;
                }
                site = null;
                break;
            }
            case IDENTIFIER: {
                for (Scope s = ctx.getInfo().getTrees().getScope(ctx.getPath()); s != null; s = s.getEnclosingScope()) {
                    for (ExecutableElement ee : ElementFilter.methodsIn(ctx.getInfo().getElements().getAllMembers(s.getEnclosingClass()))) {
                        if (ee != toCheckAgainst && !ctx.getInfo().getElements().overrides(ee, toCheckAgainst, owner)) continue;
                        site = (DeclaredType)s.getEnclosingClass().asType();
                        break block0;
                    }
                }
                site = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (site == null) {
            return null;
        }
        ExecutableType againstType = (ExecutableType)ctx.getInfo().getTypes().asMemberOf(site, toCheckAgainst);
        assert (parameterMapping.length % 2 == 0);
        for (int cntr = 0; cntr < parameterMapping.length; cntr += 2) {
            String warningKey;
            TypeMirror actualParam = ctx.getInfo().getTrees().getTypeMirror(new TreePath(ctx.getPath(), mit.getArguments().get(parameterMapping[cntr + 0])));
            TypeMirror designedType = org.netbeans.modules.java.hints.errors.Utilities.resolveCapturedType(ctx.getInfo(), againstType.getParameterTypes().get(parameterMapping[cntr + 1]));
            if (designedType.getKind() == TypeKind.WILDCARD && (designedType = ((WildcardType)designedType).getExtendsBound()) == null) {
                designedType = ctx.getInfo().getElements().getTypeElement("java.lang.Object").asType();
            }
            if (ctx.getInfo().getTypes().isAssignable(actualParam, designedType)) continue;
            if (CollectionRemove.compatibleTypes(ctx.getInfo(), actualParam, designedType)) {
                warningKey = "HINT_SuspiciousCall";
                if (!ctx.getPreferences().getBoolean(WARN_FOR_CASTABLE_KEY, true)) {
                    continue;
                }
            } else {
                warningKey = "HINT_SuspiciousCallIncompatibleTypes";
            }
            ExecutableElement checkMethodElement = CollectionRemove.resolveMethod(ctx.getInfo(), checkMethod);
            ExecutableElement enclosingMethod = CollectionRemove.findEnclosingMethod(ctx.getInfo(), ctx.getPath());
            if (enclosingMethod != null && checkMethodElement != null && ctx.getInfo().getElements().overrides(enclosingMethod, checkMethodElement, (TypeElement)checkMethodElement.getEnclosingElement())) continue;
            String semiFQN = checkMethod.substring(0, checkMethod.indexOf(40));
            String warning = NbBundle.getMessage(CollectionRemove.class, (String)warningKey, (Object)semiFQN, (Object)Utilities.getTypeName((CompilationInfo)ctx.getInfo(), (TypeMirror)actualParam, (boolean)false), (Object)Utilities.getTypeName((CompilationInfo)ctx.getInfo(), (TypeMirror)designedType, (boolean)false));
            result.add(ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), warning, new Fix[0]));
        }
        return result;
    }

    private static boolean compatibleTypes(CompilationInfo info, TypeMirror type1, TypeMirror type2) {
        type1 = info.getTypes().erasure(type1);
        type2 = info.getTypes().erasure(type2);
        return info.getTypeUtilities().isCastable(type1, type2);
    }

    private static ExecutableElement resolveMethod(CompilationInfo info, String name) {
        Matcher m = SPLIT.matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        String className = m.group(1);
        String methodName = m.group(2);
        String paramsSpec = m.group(3);
        TypeElement te = info.getElements().getTypeElement(className);
        if (te == null) {
            return null;
        }
        String[] paramList = paramsSpec.split(",");
        LinkedList<TypeMirror> params = new LinkedList<TypeMirror>();
        TypeElement topLevel = (TypeElement)info.getTopLevelElements().get(0);
        for (String t : paramList) {
            params.add(info.getTreeUtilities().parseType(t, topLevel));
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(te.getEnclosedElements())) {
            if (!methodName.equals(ee.getSimpleName().toString()) || ee.getParameters().size() != params.size()) continue;
            Iterator designed = params.iterator();
            boolean found = true;
            for (VariableElement variableElement : ee.getParameters()) {
                if (info.getTypes().isSameType(info.getTypes().erasure(variableElement.asType()), (TypeMirror)designed.next())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return ee;
        }
        return null;
    }

    private static ExecutableElement findEnclosingMethod(CompilationInfo info, TreePath path) {
        Element el;
        while (path != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.METHOD) {
            path = path.getParentPath();
        }
        if (path != null && path.getLeaf().getKind() == Tree.Kind.METHOD && (el = info.getTrees().getElement(path)) != null && el.getKind() == ElementKind.METHOD) {
            return (ExecutableElement)el;
        }
        return null;
    }

    public static final class CollectionRemoveCustomizerImpl
    extends OneCheckboxCustomizerProvider {
        public CollectionRemoveCustomizerImpl() {
            super(NbBundle.getMessage(CollectionRemove.class, (String)"LBL_CollectionRemoveCustomizer.warnForCastable"), NbBundle.getMessage(CollectionRemove.class, (String)"TP_CollectionRemoveCustomizer.warnForCastable"), CollectionRemove.WARN_FOR_CASTABLE_KEY, true);
        }
    }
}

