/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ThreadsTableModel
implements TableModel,
Constants {
    private Vector listeners = new Vector();
    private Map<JPDAThread, Integer> refreshingThreads;
    private Map<JPDAThread, ThreadStateChangeListener> threadStateChangeListeners = new WeakHashMap<JPDAThread, ThreadStateChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).getOriginalThread();
        }
        if (row instanceof JPDAThreadGroup) {
            if ("ThreadState".equals(columnID)) {
                return "";
            }
            if ("ThreadSuspended".equals(columnID)) {
                JPDAThreadGroup group = (JPDAThreadGroup)row;
                JPDAThread[] threads = group.getThreads();
                boolean suspended = true;
                for (JPDAThread t : threads) {
                    if (t.isSuspended()) continue;
                    suspended = false;
                    break;
                }
                return suspended;
            }
        }
        if (row instanceof JPDAThread) {
            JPDAThread t = (JPDAThread)row;
            if ("ThreadState".equals(columnID)) {
                int state = t.getState();
                ThreadsTableModel suspended = this;
                synchronized (suspended) {
                    if (this.refreshingThreads == null) {
                        this.refreshingThreads = new WeakHashMap<JPDAThread, Integer>();
                        new ThreadStateChangeRefresher(this, this.refreshingThreads);
                    }
                    this.refreshingThreads.put(t, state);
                }
                String description = ThreadsTableModel.getThreadStateDescription(state);
                if (description != null) {
                    return description;
                }
            } else if ("ThreadSuspended".equals(columnID)) {
                ThreadsTableModel threadsTableModel = this;
                synchronized (threadsTableModel) {
                    if (!this.threadStateChangeListeners.containsKey(t)) {
                        this.threadStateChangeListeners.put(t, new ThreadStateChangeListener(this, t));
                    }
                }
                return t.isSuspended();
            }
        }
        throw new UnknownTypeException(row);
    }

    private static String getThreadStateDescription(int state) {
        switch (state) {
            case 3: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_OnMonitor");
            }
            case 5: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_NotStarted");
            }
            case 1: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Running");
            }
            case 2: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Sleeping");
            }
            case -1: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Unknown");
            }
            case 4: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Waiting");
            }
            case 0: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Zombie");
            }
        }
        ErrorManager.getDefault().log(16, "Unknown thread state: " + state);
        return null;
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).getOriginalThread();
        }
        if (row instanceof JPDAThreadGroup) {
            if ("ThreadState".equals(columnID)) {
                return true;
            }
            if ("ThreadSuspended".equals(columnID)) {
                return false;
            }
        }
        if (row instanceof JPDAThread) {
            if ("ThreadState".equals(columnID)) {
                return true;
            }
            if ("ThreadSuspended".equals(columnID)) {
                return false;
            }
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof MonitorModel.ThreadWithBordel) {
            row = ((MonitorModel.ThreadWithBordel)row).getOriginalThread();
        }
        if (row instanceof JPDAThreadGroup && "ThreadSuspended".equals(columnID)) {
            if (((Boolean)value).booleanValue()) {
                ((JPDAThreadGroup)row).suspend();
            } else {
                ((JPDAThreadGroup)row).resume();
            }
            this.fireTableValueChanged(row, "ThreadSuspended");
            return;
        }
        if (row instanceof JPDAThread && "ThreadSuspended".equals(columnID)) {
            if (value.equals(Boolean.TRUE)) {
                ((JPDAThread)row).suspend();
            } else {
                ((JPDAThread)row).resume();
            }
            this.fireTableValueChanged(row, "ThreadSuspended");
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTableValueChanged(Object o, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, o, propertyName));
        }
    }

    private void fireNodeChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        }
    }

    private static class ThreadStateChangeRefresher
    implements Runnable {
        private WeakReference<ThreadsTableModel> tmRef;
        private Map<JPDAThread, Integer> threads;
        private RequestProcessor.Task refreshTask;

        public ThreadStateChangeRefresher(ThreadsTableModel tm, Map<JPDAThread, Integer> threads) {
            this.tmRef = new WeakReference<ThreadsTableModel>(tm);
            this.threads = threads;
            this.refreshTask = new RequestProcessor("Threads Refresh", 1).create((Runnable)this);
            this.refreshTask.schedule(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<JPDAThread, Integer> threadStates;
            ThreadsTableModel tm = (ThreadsTableModel)this.tmRef.get();
            if (tm == null) {
                return;
            }
            long time = System.currentTimeMillis();
            Map<JPDAThread, Integer> map = this.threads;
            synchronized (map) {
                threadStates = new HashMap<JPDAThread, Integer>(this.threads);
            }
            for (JPDAThread t : threadStates.keySet()) {
                int state = t.getState();
                if (state == (Integer)threadStates.get(t)) continue;
                tm.fireTableValueChanged(t, "ThreadState");
            }
            time = System.currentTimeMillis() - time;
            if (time < 0L) {
                time = 10L;
            } else if (time > 100L) {
                time = 100L;
            }
            this.refreshTask.schedule(100 * (int)time + 200);
        }
    }

    private static class ThreadStateChangeListener
    implements PropertyChangeListener {
        private WeakReference<ThreadsTableModel> tmRef;
        private JPDAThread t;

        public ThreadStateChangeListener(ThreadsTableModel tm, JPDAThread t) {
            this.tmRef = new WeakReference<ThreadsTableModel>(tm);
            this.t = t;
            ((Customizer)t).addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ThreadsTableModel tm = (ThreadsTableModel)this.tmRef.get();
            if (tm == null) {
                ((Customizer)this.t).removePropertyChangeListener(this);
                return;
            }
            tm.fireNodeChanged(this.t);
            for (JPDAThreadGroup tg = this.t.getParentThreadGroup(); tg != null; tg = tg.getParentThreadGroup()) {
                tm.fireTableValueChanged(tg, "ThreadSuspended");
            }
        }
    }
}

