/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.Map;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;

public final class AttachSettings {
    public static final String PROP_ATTACH_DIRECT = "profiler.attach.direct";
    public static final String PROP_ATTACH_REMOTE = "profiler.attach.remote";
    public static final String PROP_ATTACH_DYNAMIC_JDK16 = "profiler.attach.dynamic.jdk16";
    public static final String PROP_ATTACH_HOST = "profiler.attach.host";
    public static final String PROP_ATTACH_PORT = "profiler.attach.port";
    public static final String PROP_ATTACH_TARGET_TYPE = "profiler.attach.target.type";
    public static final String PROP_ATTACH_SERVER_TYPE = "profiler.attach.server.type";
    public static final String PROP_ATTACH_HOST_OS = "profiler.attach.host.os";
    private String host = "";
    private String hostOS;
    private String hostOS_dbl = this.hostOS = "";
    private String host_dbl = this.host;
    private String remoteHostOS = "";
    private String serverType;
    private String serverType_dbl = this.serverType = "";
    private String targetType;
    private String targetType_dbl = this.targetType = "";
    private boolean direct = true;
    private boolean direct_dbl = this.direct = true;
    private boolean dynamic16;
    private boolean dynamic16_dbl = this.dynamic16 = false;
    private boolean remote = false;
    private boolean remote_dbl = this.remote = false;
    private int pid;
    private int pid_dbl = this.pid = -1;
    private int transientPort;
    private int transientPort_dbl = this.transientPort = -1;

    public AttachSettings() {
        this.hostOS = IntegrationUtils.getLocalPlatform(-1);
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDynamic16(boolean dynamic) {
        this.dynamic16 = dynamic;
    }

    public boolean isDynamic16() {
        return this.dynamic16;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException();
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setHostOS(String hostOS) {
        this.hostOS = hostOS != null ? hostOS : (this.remote ? this.remoteHostOS : IntegrationUtils.getLocalPlatform(-1));
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPort(int port) {
        this.transientPort = port;
    }

    public int getPort() {
        if (this.transientPort != -1) {
            return this.transientPort;
        }
        return Profiler.getDefault().getGlobalProfilingSettings().getPortNo();
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void applySettings(ProfilerEngineSettings sharedSettings) {
        sharedSettings.setPortNo(this.getPort());
        if (this.remote) {
            sharedSettings.setRemoteHost(this.host);
        } else {
            sharedSettings.setRemoteHost("");
        }
    }

    public boolean commit() {
        boolean dirty = false;
        if (this.direct != this.direct_dbl) {
            dirty = true;
            this.direct_dbl = this.direct;
        }
        if (this.remote != this.remote_dbl) {
            dirty = true;
            this.remote_dbl = this.remote;
        }
        if (this.dynamic16 != this.dynamic16_dbl) {
            dirty = true;
            this.dynamic16_dbl = this.dynamic16;
        }
        if (this.host_dbl == null || !this.host.equalsIgnoreCase(this.host_dbl)) {
            dirty = true;
            this.host_dbl = this.host;
        }
        if (this.transientPort_dbl != this.transientPort) {
            dirty = true;
            this.transientPort_dbl = this.transientPort;
        }
        if (this.targetType_dbl == null || !this.targetType.equalsIgnoreCase(this.targetType_dbl)) {
            dirty = true;
            this.targetType_dbl = this.targetType;
        }
        if (this.serverType_dbl == null || !this.serverType.equalsIgnoreCase(this.serverType_dbl)) {
            dirty = true;
            this.serverType_dbl = this.serverType;
        }
        if (this.hostOS_dbl == null || !this.hostOS.equalsIgnoreCase(this.hostOS_dbl)) {
            dirty = true;
            this.hostOS_dbl = this.hostOS;
        }
        return dirty;
    }

    public void copyInto(AttachSettings as) {
        as.direct = this.direct;
        as.direct_dbl = this.direct_dbl;
        as.remote = this.remote;
        as.remote_dbl = this.remote_dbl;
        as.dynamic16 = this.dynamic16;
        as.dynamic16_dbl = this.dynamic16_dbl;
        as.pid = this.pid;
        as.pid_dbl = this.pid_dbl;
        as.host = this.host;
        as.host_dbl = this.host_dbl;
        as.targetType = this.targetType;
        as.targetType_dbl = this.targetType_dbl;
        as.serverType = this.serverType;
        as.serverType_dbl = this.serverType_dbl;
        as.hostOS = this.hostOS;
        as.hostOS_dbl = this.hostOS_dbl;
        as.remoteHostOS = this.remoteHostOS;
    }

    public String debug() {
        return this.toString();
    }

    public void load(Map props) {
        this.direct = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_DIRECT, "true"));
        this.remote = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_REMOTE, "false"));
        this.dynamic16 = Boolean.valueOf(ProfilingSettings.getProperty(props, PROP_ATTACH_DYNAMIC_JDK16, "false"));
        this.host = ProfilingSettings.getProperty(props, PROP_ATTACH_HOST, "");
        this.targetType = ProfilingSettings.getProperty(props, PROP_ATTACH_TARGET_TYPE, "");
        this.serverType = ProfilingSettings.getProperty(props, PROP_ATTACH_SERVER_TYPE, "");
        this.remoteHostOS = ProfilingSettings.getProperty(props, PROP_ATTACH_HOST_OS, IntegrationUtils.getLocalPlatform(-1));
    }

    public void store(Map props) {
        props.put(PROP_ATTACH_DIRECT, Boolean.toString(this.direct));
        props.put(PROP_ATTACH_REMOTE, Boolean.toString(this.remote));
        props.put(PROP_ATTACH_DYNAMIC_JDK16, Boolean.toString(this.dynamic16));
        props.put(PROP_ATTACH_HOST, this.host);
        props.put(PROP_ATTACH_TARGET_TYPE, this.targetType);
        props.put(PROP_ATTACH_SERVER_TYPE, this.serverType);
        props.put(PROP_ATTACH_HOST_OS, this.hostOS);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("target type =").append(this.targetType);
        sb.append("\n");
        sb.append("server type =").append(this.serverType);
        sb.append("\n");
        sb.append("remote =").append(this.remote);
        sb.append("\n");
        sb.append("direct =").append(this.direct);
        sb.append("\n");
        sb.append("dynamic JDK16 =").append(this.dynamic16);
        sb.append("\n");
        sb.append("pid =").append(this.pid);
        sb.append("\n");
        sb.append("host =").append(this.host);
        sb.append("\n");
        sb.append("host os =").append(this.hostOS);
        sb.append("\n");
        sb.append("transient port =").append(this.transientPort);
        sb.append("\n");
        return sb.toString();
    }
}

