/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.DTD2HtmlTag;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzerElements;
import org.netbeans.editor.ext.html.parser.SyntaxTreeBuilder;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ParseException;
import org.netbeans.editor.ext.html.parser.spi.DefaultHtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HelpItem;
import org.netbeans.editor.ext.html.parser.spi.HtmlModel;
import org.netbeans.editor.ext.html.parser.spi.HtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlParser;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttribute;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagType;
import org.netbeans.editor.ext.html.parser.spi.NamedCharRef;
import org.openide.util.Lookup;

public class DefaultHtmlParser
implements HtmlParser {
    private static final String PARSER_NAME = String.format("Legacy html4 parser (%s) ", DefaultHtmlParser.class);
    private static final Map<HtmlVersion, Collection<HtmlTag>> ALL_TAGS_MAP = new EnumMap<HtmlVersion, Collection<HtmlTag>>(HtmlVersion.class);

    private static synchronized Collection<HtmlTag> getAllTags(HtmlVersion version) {
        Collection<HtmlTag> value = ALL_TAGS_MAP.get((Object)version);
        if (value == null) {
            DTD dtd = version.getDTD();
            assert (dtd != null);
            List all = dtd.getElementList("");
            value = new ArrayList<HtmlTag>();
            for (DTD.Element e : all) {
                value.add(DTD2HtmlTag.getTagForElement(dtd, e));
            }
            ALL_TAGS_MAP.put(version, value);
        }
        return value;
    }

    @Override
    public boolean canParse(HtmlVersion version) {
        return version == HtmlVersion.HTML32 || version == HtmlVersion.HTML40_STRICT || version == HtmlVersion.HTML40_TRANSATIONAL || version == HtmlVersion.HTML40_FRAMESET || version == HtmlVersion.HTML41_STRICT || version == HtmlVersion.HTML41_TRANSATIONAL || version == HtmlVersion.HTML41_FRAMESET || version == HtmlVersion.XHTML10_STICT || version == HtmlVersion.XHTML10_TRANSATIONAL || version == HtmlVersion.XHTML10_FRAMESET || version == HtmlVersion.XHTML11;
    }

    @Override
    public HtmlParseResult parse(HtmlSource source, final HtmlVersion version, Lookup lookup) throws ParseException {
        assert (this.canParse(version));
        SyntaxAnalyzerElements elements = (SyntaxAnalyzerElements)lookup.lookup(SyntaxAnalyzerElements.class);
        assert (elements != null);
        AstNode root = SyntaxTreeBuilder.makeTree(source, version, elements.items());
        return new DefaultHtmlParseResult(source, root, Collections.emptyList(), version){

            @Override
            public HtmlModel model() {
                return new Html4Model(version);
            }

            @Override
            public Collection<HtmlTag> getPossibleOpenTags(AstNode context) {
                return DTD2HtmlTag.convert(version.getDTD(), AstNodeUtils.getPossibleOpenTagElements(context));
            }

            @Override
            public Map<HtmlTag, AstNode> getPossibleEndTags(AstNode context) {
                Collection<AstNode> possibleEndTags = AstNodeUtils.getPossibleEndTagElements(context);
                LinkedHashMap<HtmlTag, AstNode> result = new LinkedHashMap<HtmlTag, AstNode>();
                for (AstNode node : possibleEndTags) {
                    if (node.getDTDElement() != null) {
                        result.put(DTD2HtmlTag.getTagForElement(version.getDTD(), node.getDTDElement()), node);
                        continue;
                    }
                    result.put(new UnknownHtmlTag(node.name()), node);
                }
                return result;
            }
        };
    }

    @Override
    public HtmlModel getModel(HtmlVersion version) {
        if (!this.canParse(version)) {
            throw new IllegalArgumentException(String.format("The parser doesn't suppport the requested html version %s!", new Object[]{version}));
        }
        return new Html4Model(version);
    }

    @Override
    public String getName() {
        return PARSER_NAME;
    }

    private static class UnknownHtmlTag
    implements HtmlTag {
        private String name;

        public UnknownHtmlTag(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<HtmlTagAttribute> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public HtmlTagAttribute getAttribute(String name) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean hasOptionalOpenTag() {
            return false;
        }

        @Override
        public boolean hasOptionalEndTag() {
            return false;
        }

        @Override
        public HtmlTagType getTagClass() {
            return HtmlTagType.HTML;
        }

        @Override
        public Collection<HtmlTag> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public HelpItem getHelp() {
            return null;
        }
    }

    private static class Html4Model
    implements HtmlModel {
        private HtmlVersion version;

        public Html4Model(HtmlVersion version) {
            this.version = version;
        }

        @Override
        public Collection<HtmlTag> getAllTags() {
            return DefaultHtmlParser.getAllTags(this.version);
        }

        @Override
        public HtmlTag getTag(String tagName) {
            DTD.Element element = this.version.getDTD().getElement(tagName);
            if (element == null) {
                return null;
            }
            return DTD2HtmlTag.getTagForElement(this.version.getDTD(), element);
        }

        public Collection<NamedCharRef> getNamedCharacterReferences() {
            return this.version.getDTD().getCharRefList("");
        }

        @Override
        public String getModelId() {
            return "html4model";
        }
    }
}

