/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.wizard;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.wizard.AvailableProvidersPanel;
import org.netbeans.modules.server.ui.wizard.ServerWizardPanel;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class AddServerInstanceWizard
extends WizardDescriptor {
    public static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    public static final String PROP_SERVER_INSTANCE_WIZARD = "ServInstWizard_server";
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private AddServerInstanceWizardIterator iterator;
    private ServerWizardPanel chooser;
    private static final Logger LOGGER = Logger.getLogger(AddServerInstanceWizard.class.getName());
    private ServerRegistry registry;

    private AddServerInstanceWizard(ServerRegistry registry) {
        this(new AddServerInstanceWizardIterator(registry));
        this.registry = registry;
        this.putProperty(PROP_AUTO_WIZARD_STYLE, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_DISPLAYED, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_NUMBERED, Boolean.TRUE);
        if (registry.isCloud()) {
            this.setTitle(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ACIW_Title"));
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ACIW_TitleFormat")));
        } else {
            this.setTitle(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Title"));
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_TitleFormat")));
        }
        this.initialize();
    }

    private AddServerInstanceWizard(AddServerInstanceWizardIterator iterator) {
        super((WizardDescriptor.Iterator)iterator);
        this.iterator = iterator;
    }

    public static ServerInstance showAddServerInstanceWizard() {
        return AddServerInstanceWizard.showAddServerInstanceWizard(ServerRegistry.getInstance());
    }

    public static ServerInstance showAddCloudInstanceWizard() {
        return AddServerInstanceWizard.showAddServerInstanceWizard(ServerRegistry.getCloudInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerInstance showAddServerInstanceWizard(ServerRegistry registry) {
        Set instantiatedObjects;
        Collection providers = Lookups.forPath((String)registry.getPath()).lookupAll(ServerWizardProvider.class);
        if (providers.isEmpty()) {
            JRadioButton[] ready = AddServerInstanceWizard.listAvailableProviders(registry.getPath());
            if (registry.isCloud()) {
                String close = NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoCloudPlugins_Close");
                DialogDescriptor descriptor = new DialogDescriptor((Object)NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoCloudPlugins_Text"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoCloudPlugins_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                return null;
            }
            if (ready.length == 0) {
                String close = NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Close");
                DialogDescriptor descriptor = new DialogDescriptor((Object)NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Text"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                return null;
            }
            Action a = null;
            if (ready.length == 1) {
                a = (Action)ready[0].getClientProperty("action");
            } else {
                AvailableProvidersPanel available = new AvailableProvidersPanel(ready);
                DialogDescriptor descriptor = new DialogDescriptor((Object)available, NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, null, 0, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    a = (Action)available.getSelected().getClientProperty("action");
                }
            }
            if (a != null) {
                a.actionPerformed(new ActionEvent(a, 0, "noui"));
            } else {
                return null;
            }
        }
        AddServerInstanceWizard wizard = new AddServerInstanceWizard(registry);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizard);
        try {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"ACSD_Add_Server_Instance"));
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        if (wizard.getValue() == WizardDescriptor.FINISH_OPTION && (instantiatedObjects = wizard.getInstantiatedObjects()) != null && instantiatedObjects.size() > 0) {
            Object result = instantiatedObjects.iterator().next();
            if (result instanceof ServerInstance) {
                return (ServerInstance)result;
            }
            LOGGER.log(Level.WARNING, "Some localized warning");
            return null;
        }
        return null;
    }

    public void setErrorMessage(String message) {
        this.putProperty(PROP_ERROR_MESSAGE, message);
    }

    protected void updateState() {
        super.updateState();
        String[] contentData = this.getContentData();
        if (contentData != null) {
            this.putProperty(PROP_CONTENT_DATA, contentData);
            this.putProperty(PROP_CONTENT_SELECTED_INDEX, this.getContentSelectedIndex());
        }
    }

    static JRadioButton[] listAvailableProviders(String path) {
        ArrayList<JRadioButton> res = new ArrayList<JRadioButton>();
        for (Action a : Utilities.actionsForPath((String)(path + "/Actions"))) {
            Object msg;
            if (a == null || !((msg = a.getValue("wizardMessage")) instanceof String)) continue;
            JRadioButton button = new JRadioButton((String)msg);
            button.putClientProperty("action", a);
            res.add(button);
        }
        return res.toArray(new JRadioButton[0]);
    }

    private ServerWizardPanel getChooser() {
        if (this.chooser == null) {
            this.chooser = new ServerWizardPanel(this.registry);
        }
        return this.chooser;
    }

    private String[] getContentData() {
        String[] firstContentData = AddServerInstanceWizard.getFirstPanelContentData(this.registry.isCloud());
        if (this.iterator.current().equals(this.getChooser())) {
            return firstContentData;
        }
        JComponent component = (JComponent)this.iterator.current().getComponent();
        String[] componentContentData = (String[])component.getClientProperty(PROP_CONTENT_DATA);
        if (componentContentData == null) {
            return firstContentData;
        }
        String[] contentData = new String[componentContentData.length + 1];
        contentData[0] = firstContentData[0];
        System.arraycopy(componentContentData, 0, contentData, 1, componentContentData.length);
        return contentData;
    }

    private int getContentSelectedIndex() {
        if (this.iterator.current().equals(this.getChooser())) {
            return 0;
        }
        JComponent component = (JComponent)this.iterator.current().getComponent();
        Integer componentIndex = (Integer)component.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
        if (componentIndex != null) {
            return componentIndex + 1;
        }
        return 1;
    }

    private static String[] getFirstPanelContentData(boolean cloud) {
        if (cloud) {
            return new String[]{NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ACIW_ChooseServer"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ACIW_Ellipsis")};
        }
        return new String[]{NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_ChooseServer"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Ellipsis")};
    }

    private static class AddServerInstanceWizardIterator
    implements WizardDescriptor.AsynchronousInstantiatingIterator {
        private final Map<ServerWizardProvider, WizardDescriptor.InstantiatingIterator> iterators = new HashMap<ServerWizardProvider, WizardDescriptor.InstantiatingIterator>();
        private WizardDescriptor.InstantiatingIterator iterator;
        private AddServerInstanceWizard wd;
        public boolean showingChooser = true;
        private ServerRegistry registry;

        public AddServerInstanceWizardIterator(ServerRegistry registry) {
            this.registry = registry;
        }

        public String name() {
            return null;
        }

        public WizardDescriptor.Panel current() {
            if (this.showingChooser) {
                return this.wd.getChooser();
            }
            if (this.iterator != null) {
                return this.iterator.current();
            }
            return null;
        }

        public boolean hasNext() {
            if (this.showingChooser) {
                return true;
            }
            if (this.iterator != null) {
                return this.iterator.hasNext();
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.showingChooser;
        }

        public void nextPanel() {
            if (this.iterator == null) {
                this.iterator = this.getServerIterator();
            } else if (!this.showingChooser) {
                this.iterator.nextPanel();
            }
            this.showingChooser = false;
        }

        public void previousPanel() {
            if (this.iterator.hasPrevious()) {
                this.iterator.previousPanel();
            } else {
                this.showingChooser = true;
                this.iterator = null;
            }
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void uninitialize(WizardDescriptor wizard) {
        }

        public void initialize(WizardDescriptor wizard) {
            this.wd = (AddServerInstanceWizard)wizard;
            this.wd.putProperty(AddServerInstanceWizard.PROP_CONTENT_DATA, AddServerInstanceWizard.getFirstPanelContentData(this.registry.isCloud()));
        }

        public Set instantiate() throws IOException {
            if (this.iterator != null) {
                return this.iterator.instantiate();
            }
            return null;
        }

        private WizardDescriptor.InstantiatingIterator getServerIterator() {
            ServerWizardProvider server = this.getSelectedWizard();
            if (server == null) {
                return null;
            }
            WizardDescriptor.InstantiatingIterator iterator = this.iterators.get(server);
            if (iterator != null) {
                return iterator;
            }
            iterator = server.getInstantiatingIterator();
            iterator.initialize((WizardDescriptor)this.wd);
            this.iterators.put(server, iterator);
            return iterator;
        }

        public ServerWizardProvider getSelectedWizard() {
            return (ServerWizardProvider)this.wd.getProperty(AddServerInstanceWizard.PROP_SERVER_INSTANCE_WIZARD);
        }
    }
}

