/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

public class LexerUtils {
    public static int getLineOffset(CharSequence text, int offset) throws BadLocationException {
        if (text == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > text.length()) {
            throw new BadLocationException("The given offset is out of bounds <0, " + text.length() + ">", offset);
        }
        int line = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                throw new IllegalArgumentException("The input text cannot contain carriage return char \\r");
            }
            if (i == offset) {
                return line;
            }
            if (c != '\n') continue;
            ++line;
        }
        return line;
    }

    public static Token followsToken(TokenSequence ts, TokenId searchedId, boolean backwards, boolean repositionBack, TokenId ... skipIds) {
        return LexerUtils.followsToken(ts, Collections.singletonList(searchedId), backwards, repositionBack, skipIds);
    }

    public static Token followsToken(TokenSequence ts, Collection<? extends TokenId> searchedIds, boolean backwards, boolean repositionBack, TokenId ... skipIds) {
        List<TokenId> skip = Arrays.asList(skipIds);
        int index = ts.index();
        while (backwards ? ts.movePrevious() : ts.moveNext()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (searchedIds.contains(id)) {
                if (repositionBack) {
                    int idx = ts.moveIndex(index);
                    boolean moved = ts.moveNext();
                    assert (idx == 0 && moved);
                }
                return token;
            }
            if (skip.contains(id)) continue;
            break;
        }
        return null;
    }

    public static TokenSequence getJoinedTokenSequence(Document doc, int offset, Language language) {
        return LexerUtils.getTokenSequence(doc, offset, language, true);
    }

    public static TokenSequence getTokenSequence(Document doc, int offset, Language language, boolean joined) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        while (ts.moveNext() || ts.movePrevious()) {
            if (ts.language() == language) {
                return ts;
            }
            if ((ts = ts.embeddedJoined()) == null) break;
            ts.move(offset);
        }
        return null;
    }

    public static boolean equals(CharSequence text1, CharSequence text2, boolean ignoreCase, boolean optimized) {
        if (text1.length() != text2.length()) {
            return false;
        }
        for (int i = 0; i < text1.length(); ++i) {
            char ch2;
            char ch1 = ignoreCase && !optimized ? Character.toLowerCase(text1.charAt(i)) : text1.charAt(i);
            char c = ch2 = ignoreCase ? Character.toLowerCase(text2.charAt(i)) : text2.charAt(i);
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence text1, CharSequence prefix, boolean ignoreCase, boolean optimized) {
        if (text1.length() < prefix.length()) {
            return false;
        }
        return LexerUtils.equals(text1.subSequence(0, prefix.length()), prefix, ignoreCase, optimized);
    }
}

