/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.lexer;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.cnd.api.script.MakefileTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

final class MakefileLexer
implements Lexer<MakefileTokenId> {
    private static final Map<String, MakefileTokenId> SPECIAL_TOKENS = new HashMap<String, MakefileTokenId>();
    private static final Set<MakefileTokenId> ALL;
    private static final Set<MakefileTokenId> NONE;
    private static final Set<MakefileTokenId> ENDEF;
    private final LexerRestartInfo<MakefileTokenId> info;
    private State state;

    private static void addSpecialTokens(MakefileTokenId tokenId, String ... tokens) {
        for (String token : tokens) {
            SPECIAL_TOKENS.put(token, tokenId);
        }
    }

    MakefileLexer(LexerRestartInfo<MakefileTokenId> info) {
        this.info = info;
        this.state = info.state() == null ? State.AT_LINE_START : State.values()[(Integer)info.state()];
    }

    public Token<MakefileTokenId> nextToken() {
        Token<MakefileTokenId> token;
        block0 : switch (this.state) {
            case AT_LINE_START: {
                token = this.readToken(true, true, true, false, ALL);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        break block0;
                    }
                    case TAB: {
                        this.state = State.AFTER_TAB_OR_SEMICOLON;
                        break block0;
                    }
                    case DEFINE: {
                        this.state = State.IN_DEFINE;
                        break block0;
                    }
                    case EQUALS: 
                    case COLON_EQUALS: 
                    case PLUS_EQUALS: {
                        this.state = State.AFTER_EQUALS;
                        break block0;
                    }
                    case COLON: {
                        this.state = State.AFTER_COLON;
                        break block0;
                    }
                    case SEMICOLON: {
                        throw new IllegalStateException("Internal error");
                    }
                }
                this.state = State.AFTER_LINE_START;
                break;
            }
            case AFTER_LINE_START: {
                token = this.readToken(false, true, true, false, ALL);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.AT_LINE_START;
                        break block0;
                    }
                    case EQUALS: 
                    case COLON_EQUALS: 
                    case PLUS_EQUALS: {
                        this.state = State.AFTER_EQUALS;
                        break block0;
                    }
                    case COLON: {
                        this.state = State.AFTER_COLON;
                        break block0;
                    }
                    case TAB: 
                    case SEMICOLON: {
                        throw new IllegalStateException("Internal error");
                    }
                }
                break;
            }
            case AFTER_TAB_OR_SEMICOLON: {
                token = this.readTokenInShell(true);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.AT_LINE_START;
                        break block0;
                    }
                    case SHELL: 
                    case MACRO: {
                        this.state = State.IN_SHELL;
                        break block0;
                    }
                    case WHITESPACE: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Internal error");
            }
            case IN_SHELL: {
                token = this.readTokenInShell(false);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.AT_LINE_START;
                        break block0;
                    }
                    case SHELL: 
                    case MACRO: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Internal error");
            }
            case IN_DEFINE: {
                token = this.readToken(false, false, false, false, NONE);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.IN_DEFINE_AT_LINE_START;
                        break block0;
                    }
                }
                break;
            }
            case IN_DEFINE_AT_LINE_START: {
                token = this.readToken(false, false, false, false, ENDEF);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case ENDEF: {
                        this.state = State.AFTER_LINE_START;
                        break block0;
                    }
                    case NEW_LINE: {
                        this.state = State.IN_DEFINE_AT_LINE_START;
                        break block0;
                    }
                }
                this.state = State.IN_DEFINE;
                break;
            }
            case AFTER_EQUALS: {
                token = this.readToken(false, false, false, false, NONE);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.AT_LINE_START;
                        break block0;
                    }
                    case TAB: 
                    case EQUALS: 
                    case COLON_EQUALS: 
                    case PLUS_EQUALS: 
                    case COLON: 
                    case SEMICOLON: {
                        throw new IllegalStateException("Internal error");
                    }
                }
                break;
            }
            case AFTER_COLON: {
                token = this.readToken(false, false, false, true, NONE);
                if (token == null) break;
                switch ((MakefileTokenId)token.id()) {
                    case NEW_LINE: {
                        this.state = State.AT_LINE_START;
                        break block0;
                    }
                    case SEMICOLON: {
                        this.state = State.AFTER_TAB_OR_SEMICOLON;
                        break block0;
                    }
                    case TAB: 
                    case EQUALS: 
                    case COLON_EQUALS: 
                    case PLUS_EQUALS: 
                    case COLON: {
                        throw new IllegalStateException("Internal error");
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        return token;
    }

    public Object state() {
        return this.state == State.AT_LINE_START ? null : Integer.valueOf(this.state.ordinal());
    }

    public void release() {
    }

    private Token<MakefileTokenId> readToken(boolean wantTab, boolean wantColon, boolean wantEquals, boolean wantSemicolon, Set<MakefileTokenId> allowedSpecial) {
        LexerInput input = this.info.input();
        TokenFactory factory = this.info.tokenFactory();
        switch (input.read()) {
            case -1: {
                return null;
            }
            case 9: {
                if (wantTab) {
                    return factory.createToken((TokenId)MakefileTokenId.TAB);
                }
                MakefileLexer.consumeWhitespace(input);
                return factory.createToken((TokenId)MakefileTokenId.WHITESPACE);
            }
            case 32: {
                MakefileLexer.consumeWhitespace(input);
                return factory.createToken((TokenId)MakefileTokenId.WHITESPACE);
            }
            case 35: {
                MakefileLexer.consumeAnythingTillEndOfLine(input, false);
                return factory.createToken((TokenId)MakefileTokenId.COMMENT);
            }
            case 13: {
                input.consumeNewline();
                return factory.createToken((TokenId)MakefileTokenId.NEW_LINE);
            }
            case 10: {
                return factory.createToken((TokenId)MakefileTokenId.NEW_LINE);
            }
            case 36: {
                return MakefileLexer.readMacro(input, (TokenFactory<MakefileTokenId>)factory);
            }
            case 58: {
                if (input.read() == 61 && wantEquals) {
                    return factory.createToken((TokenId)MakefileTokenId.COLON_EQUALS);
                }
                if (wantColon) {
                    input.backup(1);
                    return factory.createToken((TokenId)MakefileTokenId.COLON);
                }
                this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
                return factory.createToken((TokenId)MakefileTokenId.BARE);
            }
            case 43: {
                if (input.read() == 61 && wantEquals) {
                    return factory.createToken((TokenId)MakefileTokenId.PLUS_EQUALS);
                }
                input.backup(1);
                this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
                return factory.createToken((TokenId)MakefileTokenId.BARE);
            }
            case 61: {
                if (wantEquals) {
                    return factory.createToken((TokenId)MakefileTokenId.EQUALS);
                }
                this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
                return factory.createToken((TokenId)MakefileTokenId.BARE);
            }
            case 59: {
                if (wantSemicolon) {
                    return factory.createToken((TokenId)MakefileTokenId.SEMICOLON);
                }
                this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
                return factory.createToken((TokenId)MakefileTokenId.BARE);
            }
            case 92: {
                if (0 < MakefileLexer.consumeNewline(input)) {
                    return factory.createToken((TokenId)MakefileTokenId.ESCAPED_NEW_LINE);
                }
                MakefileLexer.consumeEscape(input);
                this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
                return factory.createToken((TokenId)MakefileTokenId.BARE);
            }
        }
        this.consumeBare(input, wantColon, wantEquals, wantSemicolon);
        return MakefileLexer.createBareOrSpecial(((Object)input.readText()).toString(), (TokenFactory<MakefileTokenId>)factory, allowedSpecial);
    }

    private void consumeBare(LexerInput input, boolean wantColon, boolean wantEquals, boolean wantSemicolon) {
        block9: while (true) {
            switch (input.read()) {
                case 9: 
                case 32: {
                    input.backup(1);
                    return;
                }
                case 58: {
                    if (wantColon) {
                        input.backup(1);
                        return;
                    }
                    if (!wantEquals || input.read() != 61) continue block9;
                    input.backup(2);
                    return;
                }
                case 43: {
                    if (!wantEquals || input.read() != 61) continue block9;
                    input.backup(2);
                    return;
                }
                case 61: {
                    if (!wantEquals) break;
                    input.backup(1);
                    return;
                }
                case 59: {
                    if (!wantSemicolon) break;
                    input.backup(1);
                    return;
                }
                case 92: {
                    int consumed = MakefileLexer.consumeNewline(input);
                    if (0 < consumed) {
                        input.backup(1 + consumed);
                        return;
                    }
                    MakefileLexer.consumeEscape(input);
                    break;
                }
                case -1: 
                case 10: 
                case 13: 
                case 35: 
                case 36: {
                    input.backup(1);
                    return;
                }
            }
        }
    }

    private Token<MakefileTokenId> readTokenInShell(boolean wantWhitespace) {
        LexerInput input = this.info.input();
        TokenFactory factory = this.info.tokenFactory();
        switch (input.read()) {
            case 36: {
                return MakefileLexer.readMacro(input, (TokenFactory<MakefileTokenId>)factory);
            }
            case 9: 
            case 32: {
                if (!wantWhitespace) break;
                MakefileLexer.consumeWhitespace(input);
                return factory.createToken((TokenId)MakefileTokenId.WHITESPACE);
            }
        }
        input.backup(1);
        if (MakefileLexer.consumeAnythingTillEndOfLine(input, true)) {
            return factory.createToken((TokenId)MakefileTokenId.SHELL);
        }
        if (0 < MakefileLexer.consumeNewline(input)) {
            return factory.createToken((TokenId)MakefileTokenId.NEW_LINE);
        }
        return null;
    }

    private static void consumeEscape(LexerInput input) {
        block0 : switch (input.read()) {
            case 58: {
                switch (input.read()) {
                    case 61: {
                        input.backup(2);
                        break block0;
                    }
                }
                input.backup(1);
                break;
            }
            case 9: 
            case 32: 
            case 35: {
                return;
            }
            default: {
                input.backup(1);
            }
        }
    }

    private static boolean consumeWhitespace(LexerInput input) {
        int consumed = 0;
        block3: while (true) {
            switch (input.read()) {
                case 9: 
                case 32: {
                    ++consumed;
                    continue block3;
                }
            }
            break;
        }
        input.backup(1);
        return 0 < consumed;
    }

    private static boolean consumeAnythingTillEndOfLine(LexerInput input, boolean wantMacro) {
        int consumed = 0;
        block5: while (true) {
            switch (input.read()) {
                case -1: 
                case 10: 
                case 13: {
                    input.backup(1);
                    return 0 < consumed;
                }
                case 92: {
                    consumed += 1 + MakefileLexer.consumeNewline(input);
                    continue block5;
                }
                case 36: {
                    if (!wantMacro) continue block5;
                    input.backup(1);
                    return 0 < consumed;
                }
            }
            ++consumed;
        }
    }

    private static int consumeNewline(LexerInput input) {
        if (input.consumeNewline()) {
            return 1;
        }
        if (input.read() == 13 && input.consumeNewline()) {
            return 2;
        }
        input.backup(1);
        return 0;
    }

    private static Token<MakefileTokenId> readMacro(LexerInput input, TokenFactory<MakefileTokenId> factory) {
        if (MakefileLexer.consumeMacro(input)) {
            return factory.createToken((TokenId)MakefileTokenId.MACRO);
        }
        return factory.createToken((TokenId)MakefileTokenId.MACRO, input.readLength(), PartType.START);
    }

    private static boolean consumeMacro(LexerInput input) {
        switch (input.read()) {
            case 40: {
                return MakefileLexer.consumeMacroBody(input, ')');
            }
            case 123: {
                return MakefileLexer.consumeMacroBody(input, '}');
            }
            case -1: 
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                input.backup(1);
                return false;
            }
        }
        return true;
    }

    private static boolean consumeMacroBody(LexerInput input, char barrier) {
        block5: while (true) {
            int c = input.read();
            switch (c) {
                case 36: {
                    if (MakefileLexer.consumeMacro(input)) continue block5;
                    return false;
                }
                case 92: {
                    MakefileLexer.consumeNewline(input);
                    continue block5;
                }
                case -1: 
                case 10: 
                case 13: {
                    input.backup(1);
                    return false;
                }
            }
            if (c == barrier) break;
        }
        return true;
    }

    private static Token<MakefileTokenId> createBareOrSpecial(String text, TokenFactory<MakefileTokenId> factory, Set<MakefileTokenId> allowedSpecial) {
        MakefileTokenId tokenId = SPECIAL_TOKENS.get(text);
        return factory.createToken((TokenId)(allowedSpecial.contains((Object)tokenId) ? tokenId : MakefileTokenId.BARE));
    }

    static {
        MakefileLexer.addSpecialTokens(MakefileTokenId.SPECIAL_TARGET, ".DEFAULT", ".IGNORE", ".POSIX", ".PRECIOUS", ".SCCS_GET", ".SILENT", ".SUFFIXES", ".PHONY", ".INTERMEDIATE", ".SECONDARY", ".SECONDEXPANSION", ".DELETE_ON_ERROR", ".LOW_RESOLUTION_TIME", ".EXPORT_ALL_VARIABLES", ".NOTPARALLEL", ".KEEP_STATE", ".KEEP_STATE_FILE", ".NO_PARALLEL", ".PARALLEL", ".LOCAL", ".WAIT", ".DONE", ".FAILED", ".GET_POSIX", ".INIT", ".MAKE_VERSION", ".SCCS_GET_POSIX");
        MakefileLexer.addSpecialTokens(MakefileTokenId.KEYWORD, "override", "ifdef", "ifndef", "ifeq", "ifneq", "else", "endif");
        MakefileLexer.addSpecialTokens(MakefileTokenId.DEFINE, "define");
        MakefileLexer.addSpecialTokens(MakefileTokenId.ENDEF, "endef");
        MakefileLexer.addSpecialTokens(MakefileTokenId.INCLUDE, "include");
        ALL = MakefileTokenId.language().tokenIds();
        NONE = EnumSet.noneOf(MakefileTokenId.class);
        ENDEF = EnumSet.of(MakefileTokenId.ENDEF);
    }

    private static enum State {
        AT_LINE_START,
        AFTER_LINE_START,
        AFTER_TAB_OR_SEMICOLON,
        IN_SHELL,
        IN_DEFINE,
        IN_DEFINE_AT_LINE_START,
        AFTER_EQUALS,
        AFTER_COLON;

    }
}

