/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class CssTCController
implements PropertyChangeListener {
    public static WeakReference<CssTCController> instance;
    private TopComponent lastCSSTC = null;
    private static final String SB_AND_PREVIEW_GROUP_NAME = "Csswsgrp";
    private static final String SB_ONLY_GROUP_NAME = "CssSBwsgrp";

    public static synchronized CssTCController getDefault() {
        CssTCController controllerInstance;
        if (instance == null) {
            instance = new WeakReference<CssTCController>(new CssTCController());
        }
        if ((controllerInstance = (CssTCController)instance.get()) == null) {
            controllerInstance = new CssTCController();
            instance = new WeakReference<CssTCController>(controllerInstance);
            return controllerInstance;
        }
        return (CssTCController)instance.get();
    }

    public CssTCController() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        reg.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)reg));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CssTCController.refreshOpenedWindowGroups();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent closedTC;
        if ("activated".equals(evt.getPropertyName())) {
            TopComponent activated = (TopComponent)evt.getNewValue();
            boolean isEditor = WindowManager.getDefault().isOpenedEditorTopComponent(activated);
            if (isEditor && this.isCssFileBound(activated)) {
                this.previewableActivated(activated);
            } else {
                if (activated instanceof CssPreviewTopComponent || activated instanceof StyleBuilderTopComponent) {
                    return;
                }
                if (isEditor && this.lastCSSTC != null) {
                    this.notPreviewableActivated();
                }
            }
        } else if (this.lastCSSTC != null && "tcClosed".equals(evt.getPropertyName()) && (closedTC = (TopComponent)evt.getNewValue()) == this.lastCSSTC) {
            this.notPreviewableActivated();
        }
    }

    private boolean isCssFileBound(TopComponent tc) {
        if (tc == null) {
            return false;
        }
        FileObject fob = (FileObject)tc.getLookup().lookup(FileObject.class);
        return fob != null && "text/x-css".equals(fob.getMIMEType());
    }

    private String getActiveGroupName() {
        return CssPreviewTopComponent.getDefault().isPreviewPanelRegistered() ? SB_AND_PREVIEW_GROUP_NAME : SB_ONLY_GROUP_NAME;
    }

    static void refreshOpenedWindowGroups() {
        if (CssPreviewTopComponent.getDefault().isPreviewPanelRegistered()) {
            CssTCController.closeGroup(SB_ONLY_GROUP_NAME);
        } else {
            CssTCController.closeGroup(SB_AND_PREVIEW_GROUP_NAME);
        }
    }

    private void previewableActivated(TopComponent tc) {
        this.lastCSSTC = tc;
        CssTCController.openGroup(this.getActiveGroupName());
    }

    private void notPreviewableActivated() {
        this.lastCSSTC = null;
        CssTCController.closeGroup(this.getActiveGroupName());
    }

    static void openGroup(String name) {
        TopComponentGroup tcg = WindowManager.getDefault().findTopComponentGroup(name);
        if (tcg != null) {
            tcg.open();
        }
    }

    static void closeGroup(String name) {
        TopComponentGroup tcg = WindowManager.getDefault().findTopComponentGroup(name);
        if (tcg != null) {
            tcg.close();
        }
    }
}

