/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitExecutionManager;
import org.netbeans.modules.junit.output.JUnitTestRunnerNodeFactory;
import org.netbeans.modules.junit.output.JUnitTestSession;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 0x400000;
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private final TestSession.SessionType sessionType;
    private boolean expectXmlReport;
    private final long timeOfSessionStart;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private boolean lastHeaderBrief;
    private final Manager manager = Manager.getInstance();
    private ClassPath platformSources;
    private TestSession testSession;
    private File resultsDir;
    private JUnitTestcase testcase;
    private Report report;
    private State state = State.DEFAULT;
    private long lastSuiteTime = 0L;

    JUnitOutputReader(AntSession session, AntSessionInfo sessionInfo, Project project, Properties props) {
        FileObject fileObj;
        this.sessionType = sessionInfo.getSessionType();
        File antScript = FileUtil.normalizeFile((File)session.getOriginatingScript());
        this.timeOfSessionStart = sessionInfo.getTimeOfTestTaskStart();
        if (project == null && (project = FileOwnerQuery.getOwner((FileObject)(fileObj = FileUtil.toFileObject((File)antScript)))) == null) {
            project = new Project(){

                public FileObject getProjectDirectory() {
                    return FileUtil.createMemoryFileSystem().getRoot();
                }

                public Lookup getLookup() {
                    return Lookup.EMPTY;
                }
            };
        }
        String className = props.getProperty("classname", "");
        String methodName = props.getProperty("methodname");
        String sName = "junit-custom".equals(FileUtil.toFileObject((File)antScript).getName()) ? NbBundle.getMessage(JUnitOutputReader.class, (String)"LBL_RerunFailedTests") : (methodName != null ? className + "." + methodName : className);
        this.testSession = new JUnitTestSession(sName, project, this.sessionType, new JUnitTestRunnerNodeFactory());
        this.testSession.setRerunHandler((RerunHandler)new JUnitExecutionManager(session, this.testSession, props));
    }

    TestSession getTestSession() {
        return this.testSession;
    }

    void verboseMessageLogged(AntEvent event) {
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        this.verboseMessageLogged(msg);
    }

    synchronized void verboseMessageLogged(String msg) {
        switch (this.state) {
            case SUITE_STARTED: {
                if (!msg.startsWith("junit.framework.TestListener: ")) break;
                String testListenerMsg = msg.substring("junit.framework.TestListener: ".length());
                if (testListenerMsg.startsWith("tests to run: ")) {
                    return;
                }
                int leftBracketIndex = testListenerMsg.indexOf(40);
                if (leftBracketIndex == -1) {
                    return;
                }
                String shortMsg = testListenerMsg.substring(0, leftBracketIndex);
                if (!shortMsg.equals("startTest")) break;
                String restOfMsg = testListenerMsg.substring("startTest".length());
                if (restOfMsg.length() != 0) {
                    char firstChar = restOfMsg.charAt(0);
                    char lastChar = restOfMsg.charAt(restOfMsg.length() - 1);
                    if (firstChar == '(' && lastChar == ')') {
                        this.testCaseStarted(restOfMsg.substring(1, restOfMsg.length() - 1));
                    }
                }
                return;
            }
            case TESTCASE_STARTED: {
                int errMsgStart;
                String troubleMsg;
                boolean hasErrMsg;
                String testName;
                if (!msg.startsWith("junit.framework.TestListener: ")) break;
                String testListenerMsg = msg.substring("junit.framework.TestListener: ".length());
                int leftBracketIndex = testListenerMsg.indexOf(40);
                if (leftBracketIndex == -1) {
                    return;
                }
                String shortMsg = testListenerMsg.substring(0, leftBracketIndex);
                if (shortMsg.equals("endTest")) {
                    String restOfMsg = testListenerMsg.substring("endTest".length());
                    if (restOfMsg.length() != 0) {
                        String name;
                        char firstChar = restOfMsg.charAt(0);
                        char lastChar = restOfMsg.charAt(restOfMsg.length() - 1);
                        if (firstChar == '(' && lastChar == ')' && (name = restOfMsg.substring(1, restOfMsg.length() - 1)).equals(this.testSession.getCurrentTestCase().getName())) {
                            this.testCaseFinished();
                        }
                    }
                    return;
                }
                if (!shortMsg.equals("addFailure") && !shortMsg.equals("addError")) break;
                int lastCharIndex = testListenerMsg.length() - 1;
                String insideBrackets = testListenerMsg.substring(shortMsg.length() + 1, lastCharIndex);
                int commaIndex = insideBrackets.indexOf(44);
                String string = testName = commaIndex == -1 ? insideBrackets : insideBrackets.substring(0, commaIndex);
                if (!testName.equals(this.testSession.getCurrentTestCase().getName())) {
                    return;
                }
                this.testSession.getCurrentTestCase().setTrouble(new Trouble(shortMsg.equals("addError")));
                boolean bl = hasErrMsg = commaIndex != -1 && commaIndex + 2 <= insideBrackets.length();
                if (hasErrMsg && !(troubleMsg = insideBrackets.substring(errMsgStart = Character.isSpaceChar(insideBrackets.charAt(commaIndex + 1)) ? commaIndex + 2 : commaIndex + 1)).equals("null")) {
                    this.addStackTraceLine(this.testSession.getCurrentTestCase(), troubleMsg, false);
                }
                return;
            }
            case DEFAULT: 
            case SUITE_FINISHED: 
            case TESTCASE_ISSUE: {
                String executable;
                ClassPath platformSrcs;
                Matcher matcher = RegexpUtils.JAVA_EXECUTABLE.matcher(msg);
                if (!matcher.find() || (platformSrcs = this.findPlatformSources(executable = matcher.group(1))) == null) break;
                this.platformSources = platformSrcs;
                break;
            }
        }
    }

    synchronized void messageLogged(AntEvent event) {
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        switch (this.state) {
            case SUITE_FINISHED: 
            case TESTCASE_ISSUE: {
                if (msg.startsWith("Testcase: ")) {
                    boolean success;
                    String header = msg.substring("Testcase: ".length());
                    boolean bl = this.lastHeaderBrief ? this.tryParseBriefHeader(header) || !(this.lastHeaderBrief = !this.tryParsePlainHeader(header)) : (success = this.tryParsePlainHeader(header) || (this.lastHeaderBrief = this.tryParseBriefHeader(header)));
                    if (!success) break;
                    this.state = State.TESTCASE_ISSUE;
                    break;
                }
            }
            case DEFAULT: {
                if (msg.startsWith("Testsuite: ")) {
                    String suiteName = msg.substring("Testsuite: ".length());
                    if (this.regexp.getFullJavaIdPattern().matcher(suiteName).matches()) {
                        this.suiteStarted(suiteName);
                        this.resultsDir = JUnitOutputReader.determineResultsDir(event);
                    }
                }
                if (!this.state.equals((Object)State.TESTCASE_ISSUE) || msg.equals("")) break;
                this.addStackTraceLine(this.testcase, msg, true);
                break;
            }
            case SUITE_STARTED: {
                if (msg.startsWith("Tests run: ")) {
                    Matcher matcher = this.regexp.getSuiteStatsPattern().matcher(msg);
                    if (matcher.matches()) {
                        try {
                            this.suiteFinished(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), this.parseTime(matcher.group(4)));
                            break;
                        }
                        catch (NumberFormatException ex) {
                            assert (false) : ex;
                            break;
                        }
                    }
                    assert (false) : "See bug #185544 \nPlease, provide details about your test run: \nJUnit version, a way how tests are launched, \nkind of the project and so on. \nDescription of your test environment, a sample \nproject and steps to reproduce this bug will be \nhighly appreciated.\nCause of this error is the JUnit message about \nexecution of the tests doesn't match for usual regexp pattern: \nmessage: \"" + msg + "\"\n" + "pattern: \"" + this.regexp.getSuiteStatsPattern();
                    break;
                }
            }
            case TESTCASE_STARTED: {
                int posTestListener = msg.indexOf("junit.framework.TestListener: ");
                if (posTestListener != -1) {
                    this.displayOutput(msg.substring(0, posTestListener), event.getLogLevel() == 1);
                    this.verboseMessageLogged(msg.substring(posTestListener));
                    break;
                }
                this.displayOutput(msg, event.getLogLevel() == 1);
                break;
            }
        }
    }

    private int parseTime(String timeString) {
        int timeMillis;
        try {
            double seconds = this.numberFormat.parse(timeString).doubleValue();
            timeMillis = Math.round((float)(seconds * 1000.0));
        }
        catch (ParseException ex) {
            timeMillis = -1;
        }
        return timeMillis;
    }

    private static File determineResultsDir(AntEvent event) {
        File resultsDir = null;
        String taskName = event.getTaskName();
        if (taskName != null) {
            if (taskName.equals("junit")) {
                resultsDir = JUnitOutputReader.determineJunitTaskResultsDir(event);
            } else if (taskName.equals("java")) {
                resultsDir = JUnitOutputReader.determineJavaTaskResultsDir(event);
            }
        }
        if (resultsDir != null && resultsDir.exists() && resultsDir.isDirectory()) {
            return resultsDir;
        }
        return null;
    }

    private static File determineJunitTaskResultsDir(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        if (taskStruct == null) {
            return null;
        }
        String todirAttr = null;
        boolean hasXmlFileOutput = false;
        for (TaskStructure taskChild : taskStruct.getChildren()) {
            String useFileAttr;
            String typeAttr;
            String taskChildName = taskChild.getName();
            if (taskChildName.equals("batchtest") || taskChildName.equals("test")) {
                todirAttr = taskChild.getAttribute("todir");
                continue;
            }
            if (!taskChildName.equals("formatter") || hasXmlFileOutput || (typeAttr = taskChild.getAttribute("type")) == null || !"xml".equals(event.evaluate(typeAttr)) || (useFileAttr = taskChild.getAttribute("usefile")) != null && !AntProject.toBoolean(event.evaluate(useFileAttr))) continue;
            hasXmlFileOutput = true;
        }
        if (!hasXmlFileOutput) {
            return null;
        }
        File resultsDir = todirAttr != null ? JUnitOutputReader.getFile(todirAttr, event) : JUnitOutputReader.getBaseDir(event);
        return JUnitOutputReader.findAbsolutePath(resultsDir, taskStruct, event);
    }

    private static File determineJavaTaskResultsDir(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        if (taskStruct == null) {
            return null;
        }
        String todirPath = null;
        for (TaskStructure taskChild : taskStruct.getChildren()) {
            String fullReportFileName;
            String formatter;
            int commaIndex;
            String taskChildName = taskChild.getName();
            if (!taskChildName.equals("arg")) continue;
            String valueAttr = taskChild.getAttribute("value");
            if (valueAttr == null) {
                valueAttr = taskChild.getAttribute("line");
            }
            if (valueAttr == null || !(valueAttr = event.evaluate(valueAttr)).startsWith("formatter=") || (commaIndex = (formatter = valueAttr.substring("formatter=".length())).indexOf(44)) == -1 || !formatter.substring(0, commaIndex).equals(XML_FORMATTER_CLASS_NAME) || (todirPath = new File(fullReportFileName = formatter.substring(commaIndex + 1)).getParent()) != null) continue;
            todirPath = ".";
        }
        if (todirPath == null) {
            return null;
        }
        File resultsDir = !todirPath.equals(".") ? new File(todirPath) : null;
        return JUnitOutputReader.findAbsolutePath(resultsDir, taskStruct, event);
    }

    private static File findAbsolutePath(File path, TaskStructure taskStruct, AntEvent event) {
        String dirAttr;
        if (JUnitOutputReader.isAbsolute(path)) {
            return path;
        }
        String forkAttr = taskStruct.getAttribute("fork");
        if (forkAttr != null && AntProject.toBoolean(event.evaluate(forkAttr)) && (dirAttr = taskStruct.getAttribute("dir")) != null && JUnitOutputReader.isAbsolute(path = JUnitOutputReader.combine(JUnitOutputReader.getFile(dirAttr, event), path))) {
            return path;
        }
        return JUnitOutputReader.combine(JUnitOutputReader.getBaseDir(event), path);
    }

    private static File combine(File parentPath, File path) {
        return path != null ? new File(parentPath, path.getPath()) : parentPath;
    }

    private static boolean isAbsolute(File path) {
        return path != null && path.isAbsolute();
    }

    private static File getFile(String attrValue, AntEvent event) {
        return new File(event.evaluate(attrValue));
    }

    private static File getBaseDir(AntEvent event) {
        return new File(event.getProperty("basedir"));
    }

    private ClassPath findPlatformSources(String javaExecutable) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            File f;
            FileObject fo = platforms[i].findTool("java");
            if (fo == null || !(f = FileUtil.toFile((FileObject)fo)).getAbsolutePath().startsWith(javaExecutable)) continue;
            return platforms[i].getSourceFolders();
        }
        return null;
    }

    void testTaskStarted(int expectedSuitesCount, boolean expectXmlOutput) {
        this.expectXmlReport = expectXmlOutput;
        this.manager.testStarted(this.testSession);
    }

    void testTaskFinished() {
        this.closePereviousReport();
    }

    private void closePereviousReport() {
        TestSuite currentSuite = this.testSession.getCurrentSuite();
        if (currentSuite != null) {
            JUnitTestSuite reportSuite;
            File reportFile;
            if (this.resultsDir != null && (reportFile = this.findReportFile()) != null && this.isValidReportFile(reportFile) && (reportSuite = this.parseReportFile(reportFile)) != null && reportSuite.getName().equals(currentSuite.getName())) {
                this.lastSuiteTime = reportSuite.getElapsedTime();
                for (Testcase tc : currentSuite.getTestcases()) {
                    if (tc.getOutput().isEmpty()) continue;
                    ArrayList<String> output = new ArrayList<String>();
                    for (OutputLine l : tc.getOutput()) {
                        output.add(l.getLine());
                    }
                    JUnitTestcase rtc = this.findTest(reportSuite, tc.getName());
                    if (rtc == null) continue;
                    rtc.addOutputLines(output);
                }
                if (!reportSuite.getTestcases().isEmpty()) {
                    currentSuite.getTestcases().clear();
                    currentSuite.getTestcases().addAll(reportSuite.getTestcases());
                }
            }
            if (this.report == null) {
                this.report = this.testSession.getReport(this.lastSuiteTime);
            } else {
                this.report.update(this.testSession.getReport(this.lastSuiteTime));
            }
            switch (this.state) {
                case SUITE_STARTED: 
                case TESTCASE_STARTED: {
                    this.report.setAborted(true);
                }
            }
            this.manager.displayReport(this.testSession, this.report, true);
            this.report = null;
            this.lastSuiteTime = 0L;
        }
    }

    void buildFinished(AntEvent event) {
        this.manager.sessionFinished(this.testSession);
    }

    private void suiteStarted(String suiteName) {
        this.closePereviousReport();
        JUnitTestSuite suite = new JUnitTestSuite(suiteName, this.testSession);
        this.testSession.addSuite((TestSuite)suite);
        this.manager.displaySuiteRunning(this.testSession, (TestSuite)suite);
        this.state = State.SUITE_STARTED;
        this.platformSources = null;
    }

    private void suiteFinished(int total, int failures, int errors, long time) {
        int i;
        Testcase tc2;
        int addFail = failures;
        int addError = errors;
        int addPass = total - failures - errors;
        block4: for (Testcase tc2 : this.testSession.getCurrentSuite().getTestcases()) {
            switch (tc2.getStatus()) {
                case ERROR: {
                    --addError;
                    continue block4;
                }
                case FAILED: {
                    --addFail;
                    continue block4;
                }
            }
            --addPass;
        }
        for (i = 0; i < addPass; ++i) {
            tc2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            tc2.setStatus(Status.PASSED);
            this.testSession.addTestCase(tc2);
        }
        for (i = 0; i < addFail; ++i) {
            tc2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            tc2.setStatus(Status.FAILED);
            this.testSession.addTestCase(tc2);
        }
        for (i = 0; i < addError; ++i) {
            tc2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            tc2.setStatus(Status.ERROR);
            this.testSession.addTestCase(tc2);
        }
        this.lastSuiteTime = time;
        this.state = State.SUITE_FINISHED;
    }

    private void testCaseStarted(String name) {
        JUnitTestcase tc = new JUnitTestcase(name, "JUnit Test", this.testSession);
        this.testSession.addTestCase((Testcase)tc);
        this.state = State.TESTCASE_STARTED;
    }

    private void testCaseFinished() {
        if (this.report == null) {
            this.report = this.testSession.getReport(0L);
        } else {
            this.report.update(this.testSession.getReport(0L));
        }
        this.manager.displayReport(this.testSession, this.report, false);
        this.state = State.SUITE_STARTED;
    }

    private void displayOutput(String text, boolean error) {
        this.manager.displayOutput(this.testSession, text, error);
        if (this.state == State.TESTCASE_STARTED) {
            ArrayList<String> addedLines = new ArrayList<String>();
            addedLines.add(text);
            Testcase tc = this.testSession.getCurrentTestCase();
            if (tc != null) {
                tc.addOutputLines(addedLines);
            }
        }
    }

    private boolean tryParsePlainHeader(String testcaseHeader) {
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(testcaseHeader);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            String timeString = matcher.group(2);
            this.testcase = this.findTest(this.testSession.getCurrentSuite(), methodName);
            if (this.testcase != null) {
                this.testcase.setTimeMillis(this.parseTime(timeString));
                return true;
            }
        }
        return false;
    }

    private JUnitTestcase findTest(TestSuite suite, String methodName) {
        JUnitTestcase ret = null;
        for (Testcase tcase : suite.getTestcases()) {
            if (!tcase.getName().equals(methodName)) continue;
            ret = (JUnitTestcase)tcase;
            break;
        }
        return ret;
    }

    private boolean tryParseBriefHeader(String testcaseHeader) {
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(testcaseHeader);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            String clsName = matcher.group(2);
            boolean error = matcher.group(3) == null;
            this.testcase = this.findTest(this.testSession.getCurrentSuite(), methodName);
            if (this.testcase == null) {
                this.testcase = new JUnitTestcase(methodName, "JUnit test", this.testSession);
                this.testSession.addTestCase((Testcase)this.testcase);
            }
            this.testcase.setClassName(clsName);
            Trouble trouble = this.testcase.getTrouble();
            if (trouble == null) {
                trouble = new Trouble(error);
                this.testcase.setTrouble(trouble);
            } else {
                trouble.setError(error);
                trouble.setStackTrace(null);
            }
            return true;
        }
        return false;
    }

    private File findReportFile() {
        File file = new File(this.resultsDir, "TEST-" + this.testSession.getCurrentSuite().getName() + ".xml");
        return file.isFile() ? file : null;
    }

    private boolean isValidReportFile(File reportFile) {
        Level logLevel;
        if (!reportFile.canRead()) {
            return false;
        }
        long lastModified = reportFile.lastModified();
        long timeDelta = lastModified - this.timeOfSessionStart;
        Logger logger = Logger.getLogger("org.netbeans.modules.junit.outputreader.timestamps");
        if (logger.isLoggable(logLevel = Level.FINER)) {
            logger.log(logLevel, "Report file: " + reportFile.getPath());
            GregorianCalendar timeStamp = new GregorianCalendar();
            timeStamp.setTimeInMillis(this.timeOfSessionStart);
            logger.log(logLevel, "Session start:    " + String.format("%1$tT.%2$03d", timeStamp, timeStamp.get(14)));
            timeStamp.setTimeInMillis(lastModified);
            logger.log(logLevel, "Report timestamp: " + String.format("%1$tT.%2$03d", timeStamp, timeStamp.get(14)));
        }
        if (timeDelta >= 0L) {
            return true;
        }
        return -timeDelta <= this.timeOfSessionStart % 1000L;
    }

    private JUnitTestSuite parseReportFile(File reportFile) {
        JUnitTestSuite suite;
        block6: {
            long fileSize = reportFile.length();
            if (fileSize < 0L || fileSize > 0x400000L) {
                return null;
            }
            suite = null;
            try {
                suite = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(reportFile), "UTF-8"), this.testSession);
            }
            catch (UnsupportedCharsetException ex) {
                assert (false);
            }
            catch (SAXException ex) {
            }
            catch (IOException ex) {
                int severity = 1;
                ErrorManager errMgr = ErrorManager.getDefault();
                if (!errMgr.isLoggable(severity)) break block6;
                errMgr.notify(severity, errMgr.annotate((Throwable)ex, "I/O exception while reading JUnit XML report file from JUnit: "));
            }
        }
        return suite;
    }

    private static int parseNonNegativeInteger(String str) throws NumberFormatException {
        int len = str.length();
        if (len == 0 || len > 8) {
            throw new NumberFormatException();
        }
        char c = str.charAt(0);
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        int result = c - 48;
        if (len > 1) {
            for (char d : str.substring(1).toCharArray()) {
                if (d < '0' || d > '9') {
                    throw new NumberFormatException();
                }
                result = 10 * result + (d - 48);
            }
        }
        return result;
    }

    private void addStackTraceLine(Testcase testcase, String line, boolean validateST) {
        String[] stArray;
        Trouble trouble = testcase.getTrouble();
        if (trouble == null || line == null || line.length() == 0 || line.equals("null")) {
            return;
        }
        if (validateST) {
            Pattern[] patterns;
            boolean valid = false;
            for (Pattern pattern : patterns = new Pattern[]{this.regexp.getCallstackLinePattern(), this.regexp.getComparisonHiddenPattern(), this.regexp.getFullJavaIdPattern()}) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                valid = true;
                break;
            }
            if (!valid) {
                return;
            }
        }
        if ((stArray = trouble.getStackTrace()) == null) {
            trouble.setStackTrace(new String[]{line});
            Matcher matcher = this.regexp.getComparisonPattern().matcher(line);
            if (matcher.matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(matcher.group(1) + matcher.group(2) + matcher.group(3), matcher.group(4) + matcher.group(5) + matcher.group(6)));
                return;
            }
            matcher = this.regexp.getComparisonHiddenPattern().matcher(line);
            if (matcher.matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(matcher.group(1), matcher.group(2)));
                return;
            }
        } else {
            ArrayList<String> stList = new ArrayList<String>(Arrays.asList(testcase.getTrouble().getStackTrace()));
            if (!line.startsWith((String)stList.get(stList.size() - 1))) {
                stList.add(line);
                trouble.setStackTrace(stList.toArray(new String[stList.size()]));
            }
        }
    }

    static enum State {
        DEFAULT,
        SUITE_STARTED,
        TESTCASE_STARTED,
        SUITE_FINISHED,
        TESTCASE_ISSUE;

    }
}

