/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.actions;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.junit.actions.TestClassInfoTask;
import org.netbeans.modules.junit.output.OutputUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(TestMethodAction.class.getName());
    private String command;

    protected TestMethodAction(String command) {
        this.command = command;
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    protected void performAction(final Node[] activatedNodes) {
        int caret;
        Document doc;
        EditorCookie ec = (EditorCookie)activatedNodes[0].getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
            if (pane != null) {
                doc = pane.getDocument();
                caret = pane.getCaret().getDot();
            } else {
                doc = null;
                caret = -1;
            }
        } else {
            doc = null;
            caret = -1;
        }
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionProvider ap;
                SingleMethod sm = TestMethodAction.this.getTestMethod(activatedNodes[0].getLookup(), doc, caret);
                if (sm != null && (ap = OutputUtils.getActionProvider(sm.getFile())) != null) {
                    ap.invokeAction(TestMethodAction.this.command, Lookups.singleton((Object)sm));
                }
            }
        }, (String)this.getName(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
    }

    private SingleMethod getTestMethod(Lookup lkp, Document doc, int cursor) {
        SingleMethod sm = (SingleMethod)lkp.lookup(SingleMethod.class);
        if (sm == null && doc != null) {
            JavaSource js = JavaSource.forDocument((Document)doc);
            TestClassInfoTask task = new TestClassInfoTask(cursor);
            try {
                Future f = js.runWhenScanFinished((Task)task, true);
                if (f.isDone() && task.getFileObject() != null && task.getMethodName() != null) {
                    sm = new SingleMethod(task.getFileObject(), task.getMethodName());
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return sm;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

