/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.databaseaccess.DatasourceAccessor;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.LOBValueWriter;
import oracle.toplink.essentials.internal.helper.ThreadCursoredList;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.Login;

public class DatabaseAccessor
extends DatasourceAccessor {
    public static boolean shouldUseDynamicStatements = true;
    protected Hashtable statementCache = new Hashtable(50);
    protected DatabaseMetaData metaData;
    protected LOBValueWriter lobWriter = null;
    protected boolean shouldUseThreadCursors = false;
    protected Statement dynamicStatement;
    protected boolean isDynamicStatementInUse = false;

    public void flushSelectCalls(AbstractSession session) {
        if (this.lobWriter != null) {
            this.lobWriter.buildAndExecuteSelectCalls(session);
        }
    }

    public LOBValueWriter getLOBWriter() {
        if (this.lobWriter == null) {
            this.lobWriter = new LOBValueWriter(this);
        }
        return this.lobWriter;
    }

    public synchronized Statement allocateDynamicStatement() throws SQLException {
        if (this.dynamicStatement == null) {
            this.dynamicStatement = this.getConnection().createStatement();
        }
        if (this.isDynamicStatementInUse()) {
            return this.getConnection().createStatement();
        }
        this.setIsDynamicStatementInUse(true);
        return this.dynamicStatement;
    }

    public boolean isDynamicStatementInUse() {
        return this.isDynamicStatementInUse;
    }

    public synchronized void setIsDynamicStatementInUse(boolean isDynamicStatementInUse) {
        this.isDynamicStatementInUse = isDynamicStatementInUse;
    }

    public void basicBeginTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().setAutoCommit(false);
            } else {
                this.getPlatform().beginTransaction(this);
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    protected void buildConnectLog(AbstractSession session) {
        try {
            if (session.shouldLog(4, "connection")) {
                DatabaseMetaData metaData = this.getConnectionMetaData();
                Object[] args = new Object[]{metaData.getURL(), metaData.getUserName(), metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), Helper.cr() + "\t"};
                session.log(4, "connection", "connected_user_database_driver", args, this);
            }
        }
        catch (SQLException exception) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        try {
            return call.buildOutputRow(statement);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, call, this, session);
        }
    }

    public Vector buildSortedFields(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        Vector<DatabaseField> sortedFields;
        try {
            Vector columnNames = this.getColumnNames(resultSet, session);
            if (fields == null) {
                sortedFields = new Vector<DatabaseField>(columnNames.size());
                Enumeration columnNamesEnum = columnNames.elements();
                while (columnNamesEnum.hasMoreElements()) {
                    sortedFields.addElement(new DatabaseField((String)columnNamesEnum.nextElement()));
                }
            } else {
                sortedFields = this.sortFields(fields, columnNames);
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
        return sortedFields;
    }

    protected void connect(Login login) throws DatabaseException {
        super.connect(login);
        this.checkTransactionIsolation();
    }

    protected void checkTransactionIsolation() throws DatabaseException {
        if (!this.isInTransaction() && this.getLogin() != null && ((DatabaseLogin)this.getLogin()).getTransactionIsolation() != -1) {
            try {
                this.getConnection().setTransactionIsolation(((DatabaseLogin)this.getLogin()).getTransactionIsolation());
            }
            catch (SQLException sqlEx) {
                throw DatabaseException.sqlException(sqlEx, this, null);
            }
        }
    }

    public void clearStatementCache(AbstractSession session) {
        if (this.hasStatementCache()) {
            Enumeration statements = this.getStatementCache().elements();
            while (statements.hasMoreElements()) {
                Statement statement = (Statement)statements.nextElement();
                try {
                    statement.close();
                }
                catch (SQLException exception) {}
            }
            this.setStatementCache(null);
        }
        if (this.dynamicStatement != null) {
            try {
                this.dynamicStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    public void closeCursor(ResultSet resultSet) throws DatabaseException {
        try {
            resultSet.close();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(Statement statement, AbstractSession session) throws SQLException {
        if (statement == null) {
            this.decrementCallCount();
            return;
        }
        try {
            session.startOperationProfile("sql execute");
            statement.close();
        }
        finally {
            session.endOperationProfile("sql execute");
            this.decrementCallCount();
            if (statement == this.dynamicStatement) {
                this.dynamicStatement = null;
                this.setIsDynamicStatementInUse(false);
            }
        }
    }

    public void commitTransaction(AbstractSession session) throws DatabaseException {
        this.writesCompleted(session);
        super.commitTransaction(session);
    }

    public void basicCommitTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().commitTransaction(this);
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    public AbstractRecord cursorRetrieveNextRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.next()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    public AbstractRecord cursorRetrievePreviousRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.previous()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    public void closeDatasourceConnection() throws DatabaseException {
        try {
            this.getConnection().close();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null);
        }
    }

    public void disconnect(AbstractSession session) throws DatabaseException {
        this.clearStatementCache(session);
        super.disconnect(session);
    }

    public void closeConnection() {
        this.clearStatementCache(null);
        super.closeConnection();
    }

    protected void executeBatchedStatement(PreparedStatement statement, AbstractSession session) throws DatabaseException {
        try {
            this.executeDirectNoSelect(statement, null, session);
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            this.closeStatement(statement, session);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        DatabaseCall dbCall;
        Vector<AbstractRecord> result;
        Statement statement;
        block35: {
            statement = null;
            result = null;
            dbCall = null;
            ResultSet resultSet = null;
            try {
                dbCall = (DatabaseCall)call;
            }
            catch (ClassCastException e) {
                throw QueryException.invalidDatabaseCall(call);
            }
            if (this.getLogin() == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            try {
                this.incrementCallCount(session);
                if (session.shouldLog(3, "sql")) {
                    session.log(3, "sql", dbCall.getLogString(this), null, this, false);
                }
                session.startOperationProfile("sql prepare");
                try {
                    statement = dbCall.prepareStatement(this, translationRow, session);
                }
                finally {
                    session.endOperationProfile("sql prepare");
                }
                if (dbCall.isNothingReturned()) {
                    result = this.executeNoSelect(dbCall, statement, session);
                    if (dbCall.isLOBLocatorNeeded()) {
                        this.getLOBWriter().addCall(dbCall);
                    }
                    break block35;
                }
                if (!dbCall.getReturnsResultSet() || dbCall.getReturnsResultSet() && dbCall.shouldBuildOutputRow()) {
                    result = session.getPlatform().executeStoredProcedure(dbCall, (PreparedStatement)statement, this, session);
                    break block35;
                }
                resultSet = this.executeSelect(dbCall, statement, session);
                if (dbCall.getFirstResult() != 0) {
                    resultSet.absolute(dbCall.getFirstResult());
                }
                ResultSetMetaData metaData = resultSet.getMetaData();
                dbCall.matchFieldOrder(resultSet, this, session);
                if (dbCall.isCursorReturned()) {
                    dbCall.setStatement(statement);
                    dbCall.setResult(resultSet);
                    return dbCall;
                }
                session.startOperationProfile("row fetch");
                try {
                    block37: {
                        block36: {
                            if (!dbCall.isOneRowReturned()) break block36;
                            if (resultSet.next()) {
                                if (dbCall.isLOBLocatorNeeded()) {
                                    this.getLOBWriter().fetchLocatorAndWriteValue(dbCall, resultSet);
                                } else {
                                    result = this.fetchRow(dbCall.getFields(), resultSet, metaData, session);
                                }
                                if (resultSet.next()) {
                                    session.getEventManager().moreRowsDetected(dbCall);
                                }
                                break block37;
                            } else {
                                result = null;
                            }
                            break block37;
                        }
                        boolean hasNext = resultSet.next();
                        Vector<AbstractRecord> results = null;
                        if (hasNext) {
                            if (this.shouldUseThreadCursors()) {
                                Vector vector = this.buildThreadCursoredResult(dbCall, resultSet, statement, metaData, session);
                                return vector;
                            }
                            results = new Vector(20);
                            while (hasNext) {
                                results.addElement(this.fetchRow(dbCall.getFields(), resultSet, metaData, session));
                                hasNext = resultSet.next();
                            }
                        } else {
                            results = new Vector<AbstractRecord>(0);
                        }
                        result = results;
                    }
                    resultSet.close();
                }
                finally {
                    session.endOperationProfile("row fetch");
                }
            }
            catch (SQLException exception) {
                try {
                    this.closeStatement(statement, session);
                    throw DatabaseException.sqlException(exception, dbCall, this, session);
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw DatabaseException.sqlException(exception, dbCall, this, session);
            }
            catch (RuntimeException exception) {
                try {
                    this.closeStatement(statement, session);
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                if (!(exception instanceof DatabaseException)) throw exception;
                ((DatabaseException)exception).setCall(dbCall);
                throw exception;
            }
        }
        try {
            this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
            return result;
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    protected Vector buildThreadCursoredResult(final DatabaseCall dbCall, final ResultSet resultSet, final Statement statement, final ResultSetMetaData metaData, final AbstractSession session) {
        final ThreadCursoredList results = new ThreadCursoredList(20);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                session.startOperationProfile("row fetch");
                try {
                    boolean hasNext = true;
                    while (hasNext) {
                        results.addElement(DatabaseAccessor.this.fetchRow(dbCall.getFields(), resultSet, metaData, session));
                        hasNext = resultSet.next();
                    }
                    resultSet.close();
                }
                catch (SQLException exception) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session);
                    }
                    catch (Exception closeException) {
                        // empty catch block
                    }
                    results.throwException(DatabaseException.sqlException(exception, dbCall, DatabaseAccessor.this, session));
                }
                catch (RuntimeException exception) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (exception instanceof DatabaseException) {
                        ((DatabaseException)exception).setCall(dbCall);
                    }
                    results.throwException(exception);
                }
                finally {
                    session.endOperationProfile("row fetch");
                }
                try {
                    DatabaseAccessor.this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
                }
                catch (SQLException exception) {
                    results.throwException(DatabaseException.sqlException(exception, DatabaseAccessor.this, session));
                }
                results.setIsComplete(true);
            }
        };
        thread.start();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeDirectNoSelect(Statement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        int rowCount = 0;
        try {
            session.startOperationProfile("sql execute");
            rowCount = call != null && call.isDynamicCall(session) ? statement.executeUpdate(call.getSQLString()) : ((PreparedStatement)statement).executeUpdate();
            if (!this.getPlatform().supportsAutoCommit() && !this.isInTransaction()) {
                this.getPlatform().autoCommit(this);
            }
        }
        catch (SQLException exception) {
            if (!this.getPlatform().shouldIgnoreException(exception)) {
                throw DatabaseException.sqlException(exception, this, session);
            }
        }
        finally {
            session.endOperationProfile("sql execute");
        }
        return new Integer(rowCount);
    }

    protected void executeJDK12BatchStatement(Statement statement, DatabaseCall dbCall, AbstractSession session) throws DatabaseException {
        try {
            statement.executeBatch();
        }
        catch (SQLException exception) {
            try {
                this.closeStatement(statement, session);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw DatabaseException.sqlException(exception, this, session);
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            if (dbCall != null) {
                this.releaseStatement((PreparedStatement)statement, dbCall.getSQLString(), dbCall, session);
            } else {
                this.closeStatement(statement, session);
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    protected Integer executeNoSelect(DatabaseCall call, Statement statement, AbstractSession session) throws DatabaseException {
        Integer rowCount = this.executeDirectNoSelect(statement, call, session);
        if (call.shouldBuildOutputRow()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            session.getEventManager().outputParametersDetected(outputRow, call);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet executeSelect(DatabaseCall call, Statement statement, AbstractSession session) throws SQLException {
        ResultSet resultSet;
        session.startOperationProfile("sql execute");
        try {
            resultSet = call.isDynamicCall(session) ? statement.executeQuery(call.getSQLString()) : ((PreparedStatement)statement).executeQuery();
        }
        finally {
            session.endOperationProfile("sql execute");
        }
        if (call.shouldBuildOutputRow()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            session.getEventManager().outputParametersDetected(outputRow, call);
        }
        return resultSet;
    }

    protected AbstractRecord fetchRow(Vector fields, ResultSet resultSet, ResultSetMetaData metaData, AbstractSession session) throws DatabaseException {
        Vector<Object> values = new Vector<Object>(fields.size());
        DatabasePlatform platform = this.getPlatform();
        boolean optimizeData = platform.shouldOptimizeDataConversion();
        int size = fields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)fields.elementAt(index);
            if (field != null) {
                values.add(this.getObject(resultSet, field, metaData, index + 1, platform, optimizeData, session));
                continue;
            }
            values.add(null);
        }
        return new DatabaseRecord(fields, values);
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName, columnName};
            session.log(1, "query", "query_column_meta_data_with_column", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getColumns(catalog, schema, tableName, columnName);
            Vector fields = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                result.addElement(this.fetchRow(fields, resultSet, metaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sqlException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sqlException, this, session);
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    protected Vector getColumnNames(ResultSet resultSet, AbstractSession session) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Vector<String> columnNames = new Vector<String>(metaData.getColumnCount());
        for (int index = 0; index < metaData.getColumnCount(); ++index) {
            String columnName = metaData.getColumnLabel(index + 1);
            if (columnName == null || columnName.equals("")) {
                columnName = "C" + (index + 1);
            }
            if (this.getPlatform().shouldForceFieldNamesToUpperCase()) {
                columnName = columnName.toUpperCase();
            }
            columnNames.addElement(columnName);
        }
        return columnNames;
    }

    public Connection getConnection() throws DatabaseException {
        return (Connection)this.getDatasourceConnection();
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.platform;
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    protected Object getObject(ResultSet resultSet, DatabaseField field, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform, boolean optimizeData, AbstractSession session) throws DatabaseException {
        Object value = null;
        try {
            int type;
            block19: {
                type = field.sqlType;
                if (type == -1) {
                    type = metaData.getColumnType(columnNumber);
                    field.setSqlType(type);
                }
                if (optimizeData) {
                    try {
                        value = this.getObjectThroughOptimizedDataConversion(resultSet, field, type, columnNumber, platform, session);
                        if (value == null) {
                            return null;
                        }
                        if (value == this) {
                            value = null;
                        }
                    }
                    catch (SQLException exception) {
                        if (!session.shouldLog(6, "sql")) break block19;
                        session.logThrowable(6, "sql", exception);
                    }
                }
            }
            if (value == null) {
                if (type == -4 && platform.usesStreamsForBinding()) {
                    InputStream tempInputStream = resultSet.getBinaryStream(columnNumber);
                    if (tempInputStream != null) {
                        try {
                            ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
                            int tempInt = tempInputStream.read();
                            while (tempInt != -1) {
                                tempOutputStream.write(tempInt);
                                tempInt = tempInputStream.read();
                            }
                            value = tempOutputStream.toByteArray();
                        }
                        catch (IOException exception) {
                            throw DatabaseException.errorReadingBlobData();
                        }
                    } else {
                        value = null;
                    }
                } else {
                    value = platform.getObjectFromResultSet(resultSet, columnNumber, type);
                    if (this.isBlob(type)) {
                        value = platform.convertObject(value, ClassConstants.APBYTE);
                    }
                    if (this.isClob(type)) {
                        value = this.getPlatform().convertObject(value, ClassConstants.STRING);
                    }
                }
            }
            if (resultSet.wasNull()) {
                value = null;
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
        return value;
    }

    protected Object getObjectThroughOptimizedDataConversion(ResultSet resultSet, DatabaseField field, int type, int columnNumber, DatabasePlatform platform, AbstractSession session) throws SQLException {
        Object value = this;
        Class fieldType = field.type;
        if (fieldType == ClassConstants.PLONG || fieldType == ClassConstants.LONG) {
            value = new Long(resultSet.getLong(columnNumber));
        } else if (type == 12 || type == 1) {
            value = resultSet.getString(columnNumber);
            if (type == 1 && value != null && platform.shouldTrimStrings()) {
                value = Helper.rightTrimString((String)value);
            }
        } else if (fieldType == ClassConstants.INTEGER || fieldType == ClassConstants.PINT) {
            value = new Integer(resultSet.getInt(columnNumber));
        } else if (fieldType == ClassConstants.FLOAT || fieldType == ClassConstants.PFLOAT) {
            value = new Float(resultSet.getFloat(columnNumber));
        } else if (fieldType == ClassConstants.DOUBLE || fieldType == ClassConstants.PDOUBLE) {
            value = new Double(resultSet.getDouble(columnNumber));
        } else if (fieldType == ClassConstants.SHORT || fieldType == ClassConstants.PSHORT) {
            value = new Short(resultSet.getShort(columnNumber));
        } else if (Helper.shouldOptimizeDates() && fieldType != null && (type == 92 || type == 91 || type == 93)) {
            String dateString = resultSet.getString(columnNumber);
            value = platform.convertObject(dateString, fieldType);
        } else if (fieldType != null && (type == 92 || type == 91 || type == 93)) {
            if (fieldType == ClassConstants.SQLDATE) {
                value = resultSet.getDate(columnNumber);
            } else if (fieldType == ClassConstants.TIME) {
                value = resultSet.getTime(columnNumber);
            } else if (fieldType == ClassConstants.TIMESTAMP) {
                value = resultSet.getTimestamp(columnNumber);
            }
        }
        return value;
    }

    protected boolean hasStatementCache() {
        return this.statementCache != null && !this.statementCache.isEmpty();
    }

    protected synchronized Hashtable getStatementCache() {
        if (this.statementCache == null) {
            this.statementCache = new Hashtable(50);
        }
        return this.statementCache;
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName};
            session.log(1, "query", "query_column_meta_data", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getTables(catalog, schema, tableName, types);
            Vector fields = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                result.addElement(this.fetchRow(fields, resultSet, metaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sqlException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sqlException, this, session);
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    public boolean isDatasourceConnected() {
        try {
            return !this.getConnection().isClosed();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null);
        }
    }

    public boolean shouldUseThreadCursors() {
        return this.shouldUseThreadCursors;
    }

    public void setShouldUseThreadCursors(boolean shouldUseThreadCursors) {
        this.shouldUseThreadCursors = shouldUseThreadCursors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement prepareStatement(DatabaseCall call, AbstractSession session) throws SQLException {
        Statement statement = null;
        if (call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                statement = (PreparedStatement)this.getStatementCache().get(call.getSQLString());
                if (statement != null) {
                    this.getStatementCache().remove(call.getSQLString());
                }
            }
        }
        if (statement == null) {
            statement = call.isCallableStatementRequired() ? (call.isResultSetScrollable() ? this.getConnection().prepareCall(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency()) : this.getConnection().prepareCall(call.getSQLString())) : (call.isResultSetScrollable() ? this.getConnection().prepareStatement(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency()) : (call.isDynamicCall(session) ? this.allocateDynamicStatement() : this.getConnection().prepareStatement(call.getSQLString())));
        }
        return statement;
    }

    protected void reconnect(AbstractSession session) {
        this.clearStatementCache(session);
        super.reconnect(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStatement(Statement statement, String sqlString, DatabaseCall call, AbstractSession session) throws SQLException {
        if (call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                if (!this.getStatementCache().containsKey(sqlString)) {
                    preparedStatement.clearParameters();
                    if (this.getStatementCache().size() > this.getPlatform().getStatementCacheSize()) {
                        PreparedStatement removedStatement = (PreparedStatement)this.getStatementCache().remove(this.getStatementCache().keys().nextElement());
                        this.closeStatement(removedStatement, session);
                    } else {
                        this.decrementCallCount();
                    }
                    this.getStatementCache().put(sqlString, preparedStatement);
                } else {
                    this.closeStatement(statement, session);
                }
            }
        } else if (statement == this.dynamicStatement) {
            if (call.getMaxRows() > 0) {
                statement.setMaxRows(0);
            }
            this.setIsDynamicStatementInUse(false);
            this.decrementCallCount();
        } else {
            this.closeStatement(statement, session);
        }
    }

    public void basicRollbackTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().rollbackTransaction(this);
            }
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, session);
        }
    }

    protected void setStatementCache(Hashtable statementCache) {
        this.statementCache = statementCache;
    }

    protected Vector sortFields(Vector fields, Vector columnNames) {
        Vector<DatabaseField> sortedFields = new Vector<DatabaseField>(columnNames.size());
        Vector eligableFields = (Vector)fields.clone();
        Enumeration columnNamesEnum = columnNames.elements();
        boolean valueFound = false;
        while (columnNamesEnum.hasMoreElements()) {
            String columnName = (String)columnNamesEnum.nextElement();
            DatabaseField field = null;
            Enumeration fieldEnum = eligableFields.elements();
            while (fieldEnum.hasMoreElements()) {
                field = (DatabaseField)fieldEnum.nextElement();
                if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                    if (!field.getName().equalsIgnoreCase(columnName)) continue;
                    valueFound = true;
                    sortedFields.addElement(field);
                    break;
                }
                if (!field.getName().equals(columnName)) continue;
                valueFound = true;
                sortedFields.addElement(field);
                break;
            }
            if (valueFound) {
                eligableFields.removeElement(field);
            } else {
                sortedFields.addElement(new DatabaseField());
            }
            valueFound = false;
        }
        return sortedFields;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("DatabaseAccessor(");
        if (this.isConnected()) {
            writer.write(ToStringLocalization.buildMessage("connected", null));
        } else {
            writer.write(ToStringLocalization.buildMessage("disconnected", null));
        }
        writer.write(")");
        return writer.toString();
    }

    private boolean isBlob(int type) {
        return type == 2004 || type == -4;
    }

    private boolean isClob(int type) {
        return type == 2005 || type == -1;
    }

    public void writesCompleted(AbstractSession session) {
    }
}

