/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GrailsProjectProperties;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DebugCustomizerPanel
extends JPanel {
    private GrailsProjectProperties uiProperties;
    private final boolean ieBrowserSupported;
    private final boolean ffBrowserSupported;
    private ButtonGroup browserButtonGroup;
    private JLabel debugClientLabel;
    private JRadioButton firefoxRadioButton;
    private JRadioButton internetExplorerRadioButton;
    private JLabel noSupportedBrowserLabel;

    public DebugCustomizerPanel(GrailsProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        String browserString = uiProperties.getDebugBrowser();
        WebClientToolsProjectUtils.Browser selectedBrowser = null;
        if (browserString == null) {
            browserString = this.ffBrowserSupported || !this.ieBrowserSupported ? WebClientToolsProjectUtils.Browser.FIREFOX.name() : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name();
        }
        this.firefoxRadioButton.setSelected((selectedBrowser = WebClientToolsProjectUtils.Browser.valueOf((String)browserString)) == WebClientToolsProjectUtils.Browser.FIREFOX);
        this.internetExplorerRadioButton.setSelected(selectedBrowser == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER);
        this.firefoxRadioButton.setEnabled(this.ffBrowserSupported);
        this.internetExplorerRadioButton.setEnabled(this.ieBrowserSupported);
        this.noSupportedBrowserLabel.setVisible(!this.ieBrowserSupported && !this.ffBrowserSupported);
    }

    private void initComponents() {
        this.browserButtonGroup = new ButtonGroup();
        this.debugClientLabel = new JLabel();
        this.firefoxRadioButton = new JRadioButton();
        this.internetExplorerRadioButton = new JRadioButton();
        this.noSupportedBrowserLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.debugClientLabel, (String)NbBundle.getMessage(DebugCustomizerPanel.class, (String)"DebugCustomizerPanel.debugClientLabel.text"));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        this.firefoxRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(DebugCustomizerPanel.class, (String)"DebugCustomizerPanel.firefoxRadioButton.text"));
        this.firefoxRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCustomizerPanel.this.firefoxRadioButtonActionPerformed(evt);
            }
        });
        this.browserButtonGroup.add(this.internetExplorerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.internetExplorerRadioButton, (String)NbBundle.getMessage(DebugCustomizerPanel.class, (String)"DebugCustomizerPanel.internetExplorerRadioButton.text"));
        this.internetExplorerRadioButton.setToolTipText(NbBundle.getMessage(DebugCustomizerPanel.class, (String)"DebugCustomizerPanel.internetExplorerRadioButton.tooltip"));
        this.internetExplorerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCustomizerPanel.this.internetExplorerRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.noSupportedBrowserLabel, (String)NbBundle.getMessage(DebugCustomizerPanel.class, (String)"DebugCustomizerPanel.noSupportedBrowserLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.debugClientLabel).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.internetExplorerRadioButton).addComponent(this.firefoxRadioButton))).addComponent(this.noSupportedBrowserLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.debugClientLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.firefoxRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.internetExplorerRadioButton).addGap(18, 18, 18).addComponent(this.noSupportedBrowserLabel).addContainerGap(181, Short.MAX_VALUE)));
    }

    private void firefoxRadioButtonActionPerformed(ActionEvent evt) {
        this.setBrowser();
    }

    private void internetExplorerRadioButtonActionPerformed(ActionEvent evt) {
        this.setBrowser();
    }

    private void setBrowser() {
        this.uiProperties.setDebugBrowser(this.internetExplorerRadioButton.isSelected() ? WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name() : WebClientToolsProjectUtils.Browser.FIREFOX.name());
    }
}

