/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class Utils {
    private Utils() {
    }

    public static File[] convertStringsToNormalizedFiles(Collection<String> strings) {
        File[] fos = new File[strings.size()];
        int index = 0;
        for (String str : strings) {
            File fil = new File(str);
            fos[index] = fil = FileUtil.normalizeFile((File)fil);
            ++index;
        }
        return fos;
    }

    static ClassPath createSourcePath(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(grailsProject.getSourceRoots().getRootURLs());
        urls.addAll(grailsProject.getTestSourceRoots().getRootURLs());
        return ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[urls.size()]));
    }

    static ClassPath createJDKSourcePath(Project nbproject) {
        GrailsProjectConfig config = (GrailsProjectConfig)nbproject.getLookup().lookup(GrailsProjectConfig.class);
        JavaPlatform jp = config.getJavaPlatform();
        if (jp == null) {
            jp = JavaPlatformManager.getDefault().getDefaultPlatform();
        }
        if (jp != null) {
            return jp.getSourceFolders();
        }
        return ClassPathSupport.createClassPath((URL[])new URL[0]);
    }

    private static ClassPath convertToClassPath(File[] roots) {
        ArrayList<URL> l = new ArrayList<URL>();
        for (int i = 0; i < roots.length; ++i) {
            URL url = Utils.fileToURL(roots[i]);
            l.add(url);
        }
        URL[] urls = l.toArray(new URL[l.size()]);
        return ClassPathSupport.createClassPath((URL[])urls);
    }

    private static ClassPath convertToSourcePath(File[] fs) {
        ArrayList<PathResourceImplementation> lst = new ArrayList<PathResourceImplementation>();
        HashSet<URL> existingSrc = new HashSet<URL>();
        for (int i = 0; i < fs.length; ++i) {
            URL url = Utils.fileToURL(fs[i]);
            try {
                FileObject[] srcfos = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
                for (int j = 0; j < srcfos.length; ++j) {
                    block8: {
                        if (FileUtil.isArchiveFile((FileObject)srcfos[j])) {
                            srcfos[j] = FileUtil.getArchiveRoot((FileObject)srcfos[j]);
                        }
                        try {
                            url = srcfos[j].getURL();
                            if (url.toExternalForm().endsWith("/")) break block8;
                            url = new URL(url.toExternalForm() + "/");
                        }
                        catch (FileStateInvalidException ex) {
                            ErrorManager.getDefault().notify(4096, (Throwable)ex);
                            continue;
                        }
                        catch (MalformedURLException ex) {
                            ErrorManager.getDefault().notify(4096, (Throwable)ex);
                            continue;
                        }
                    }
                    if (url == null || existingSrc.contains(url)) continue;
                    lst.add(ClassPathSupport.createResource((URL)url));
                    existingSrc.add(url);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return ClassPathSupport.createClassPath(lst);
    }

    static URL fileToURL(File file) {
        try {
            URL url = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            }
            if (!url.toExternalForm().endsWith("/")) {
                url = new URL(url.toExternalForm() + "/");
            }
            return url;
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return null;
        }
    }
}

