/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.integration.components;

import java.awt.Point;
import java.util.StringTokenizer;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactory;
import org.netbeans.modules.vmd.midp.components.MidpPrimitiveDescriptor;

public final class GamePrimitiveDescriptor
implements PrimitiveDescriptorFactory {
    static final String TYPEID_STRING_TILES = "#TiledLayerTiles";
    static final String TYPEID_STRING_FRAMES = "#SequenceFrames";
    static final String TYPEID_STRING_POINT = "#Point";
    static final TilesPrimitiveDescriptor PRIMITIVE_DESCRIPTOR_TILES = new TilesPrimitiveDescriptor();
    static final FramesPrimitiveDescriptor PRIMITIVE_DESCRIPTOR_FRAMES = new FramesPrimitiveDescriptor();
    static final PointPrimitiveDescriptor PRIMITIVE_DESCRIPTOR_POINT = new PointPrimitiveDescriptor();
    private MidpPrimitiveDescriptor midp = new MidpPrimitiveDescriptor();

    public String getProjectType() {
        return "vmd-midp-game";
    }

    public PrimitiveDescriptor getDescriptorForTypeIDString(String string) {
        if (TYPEID_STRING_TILES.equals(string)) {
            return PRIMITIVE_DESCRIPTOR_TILES;
        }
        if (TYPEID_STRING_FRAMES.equals(string)) {
            return PRIMITIVE_DESCRIPTOR_FRAMES;
        }
        if (TYPEID_STRING_POINT.equals(string)) {
            return PRIMITIVE_DESCRIPTOR_POINT;
        }
        return this.midp.getDescriptorForTypeIDString(string);
    }

    private static class TilesPrimitiveDescriptor
    implements PrimitiveDescriptor {
        private TilesPrimitiveDescriptor() {
        }

        public String serialize(Object value) {
            int[][] array = (int[][])value;
            StringBuffer serialized = new StringBuffer();
            int rows = array.length;
            int cols = array.length > 0 ? array[0].length : 0;
            serialized.append(rows).append(',').append(cols);
            int[][] arr$ = array;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int[] row;
                for (int cell : row = arr$[i$]) {
                    serialized.append(',').append(cell);
                }
            }
            return serialized.toString();
        }

        public Object deserialize(String serialized) {
            StringTokenizer tokenizer = new StringTokenizer(serialized, ",");
            int rows = Integer.parseInt(tokenizer.nextToken());
            int cols = Integer.parseInt(tokenizer.nextToken());
            int[][] array = new int[rows][cols];
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    array[y][x] = Integer.parseInt(tokenizer.nextToken());
                }
            }
            return array;
        }

        public boolean isValidInstance(Object object) {
            return object instanceof int[][];
        }
    }

    private static class FramesPrimitiveDescriptor
    implements PrimitiveDescriptor {
        private FramesPrimitiveDescriptor() {
        }

        public String serialize(Object value) {
            int[] array = (int[])value;
            StringBuilder serialized = new StringBuilder();
            serialized.append(array.length).append(",");
            for (int cell : array) {
                serialized.append(cell).append(',');
            }
            return serialized.toString();
        }

        public Object deserialize(String serialized) {
            String[] tokens = serialized.split(",");
            int length = Integer.parseInt(tokens[0]);
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Integer.parseInt(tokens[i + 1]);
            }
            return array;
        }

        public boolean isValidInstance(Object object) {
            return object instanceof int[];
        }
    }

    private static class PointPrimitiveDescriptor
    implements PrimitiveDescriptor {
        private PointPrimitiveDescriptor() {
        }

        public String serialize(Object value) {
            Point point = (Point)value;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString((int)point.getX()));
            sb.append(",");
            sb.append(Integer.toString((int)point.getY()));
            return sb.toString();
        }

        public Object deserialize(String serialized) {
            String[] xAndY = serialized.split(",");
            Point p = new Point(Integer.parseInt(xAndY[0]), Integer.parseInt(xAndY[1]));
            return p;
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Point;
        }
    }
}

