/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;

public class TiledLayerPreviewPanel
extends JComponent
implements TiledLayerListener {
    private TiledLayer tiledLayer;
    private boolean autoUpdate;

    public TiledLayerPreviewPanel(TiledLayer tl, boolean autoUpdate) {
        this.tiledLayer = tl;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TiledLayerPreviewPanel.this.repaint();
            }
        });
        this.setAutoUpdate(autoUpdate);
    }

    public void setAutoUpdate(boolean autoUpdate) {
        if (autoUpdate == this.autoUpdate) {
            return;
        }
        if (autoUpdate) {
            this.tiledLayer.addTiledLayerListener(this);
        } else {
            this.tiledLayer.removeTiledLayerListener(this);
        }
        this.autoUpdate = autoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void refresh() {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double ratioW = (double)this.getWidth() / (double)this.tiledLayer.getWidth();
        double ratioH = (double)this.getHeight() / (double)this.tiledLayer.getHeight();
        double ratio = Math.min(ratioW, ratioH);
        double x = 0.0;
        double y = 0.0;
        if (ratio == ratioW) {
            double newHeight = (double)this.tiledLayer.getHeight() * ratio;
            y = ((double)this.getHeight() - newHeight) / 2.0;
        } else {
            double newWidth = (double)this.tiledLayer.getWidth() * ratio;
            x = ((double)this.getWidth() - newWidth) / 2.0;
        }
        g.translate(x, y);
        g.scale(ratio, ratio);
        this.paintCellContents(g);
    }

    private void paintCellContents(Graphics2D g) {
        for (int r = 0; r < this.tiledLayer.getRowCount(); ++r) {
            for (int c = 0; c < this.tiledLayer.getColumnCount(); ++c) {
                Tile tile = this.tiledLayer.getTileAt(r, c);
                if (tile == null) continue;
                tile.paint(g, c * tile.getWidth(), r * tile.getHeight());
            }
        }
    }

    @Override
    public void tileChanged(TiledLayer source, int row, int col) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void tilesChanged(TiledLayer source, Set positions) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void columnsInserted(TiledLayer source, int index, int count) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void columnsRemoved(TiledLayer source, int index, int count) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void rowsInserted(TiledLayer source, int index, int count) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void rowsRemoved(TiledLayer source, int index, int count) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void tilesStructureChanged(TiledLayer source) {
        this.tiledLayerChangedVisualy();
    }

    private void tiledLayerChangedVisualy() {
        this.refresh();
    }
}

