/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.DelegatingVCS;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public class VersioningManager
implements PropertyChangeListener,
LookupListener,
PreferenceChangeListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static VersioningManager instance;
    private static boolean initialized;
    private static boolean initializing;
    private static final Object INIT_LOCK;
    private final FilesystemInterceptor filesystemInterceptor;
    private final Lookup.Result<VersioningSystem> systemsLookupResult;
    private final List<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(5);
    private final Map<File, VersioningSystem> folderOwners = new HashMap<File, VersioningSystem>(200);
    private final Map<File, VersioningSystem> fileOwners = new LinkedHashMap<File, VersioningSystem>(50){
        private int MAX_SIZE;
        {
            this.MAX_SIZE = 50;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, VersioningSystem> eldest) {
            return this.size() > this.MAX_SIZE;
        }
    };
    private VersioningSystem localHistory;
    static final Logger LOG;
    private final Map<File, Boolean> localHistoryFiles = new LinkedHashMap<File, Boolean>(200);
    private Map<String, Set<String>> interceptedMethods = new HashMap<String, Set<String>>();
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){};
    private int refreshSerial;

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        if (initialized && OpenProjects.getDefault().openProjects().isDone()) {
            return true;
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            if (!initializing) {
                initializing = true;
                new RequestProcessor("Initialize VCS").post(new Runnable(){

                    @Override
                    public void run() {
                        VersioningManager.getInstance();
                    }
                });
            }
        }
        return false;
    }

    private VersioningManager() {
        this.systemsLookupResult = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.filesystemInterceptor = new FilesystemInterceptor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            this.systemsLookupResult.addLookupListener((LookupListener)this);
            this.refreshVersioningSystems();
            this.filesystemInterceptor.init(this);
            VersioningSupport.getPreferences().addPreferenceChangeListener(this);
        }
        finally {
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningSystems() {
        int rs = ++this.refreshSerial;
        Collection systems = this.systemsLookupResult.allInstances();
        if (rs != this.refreshSerial) {
            return;
        }
        List<VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            for (VersioningSystem system : this.versioningSystems) {
                if (system instanceof DelegatingVCS && ((DelegatingVCS)system).isAlive()) {
                    ((DelegatingVCS)system).getDelegate().removePropertyChangeListener(this);
                    continue;
                }
                system.removePropertyChangeListener(this);
            }
            this.versioningSystems.clear();
            this.localHistory = null;
            this.versioningSystems.addAll(systems);
            for (VersioningSystem system : this.versioningSystems) {
                if (this.localHistory == null && Utils.isLocalHistory(system)) {
                    this.localHistory = system;
                }
                if (system instanceof DelegatingVCS && ((DelegatingVCS)system).isAlive()) {
                    ((DelegatingVCS)system).getDelegate().addPropertyChangeListener(this);
                    continue;
                }
                system.addPropertyChangeListener(this);
            }
        }
        this.flushFileOwnerCache();
        this.refreshDiffSidebars(null);
        VersioningAnnotationProvider.refreshAllAnnotations();
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars(Set<File> files) {
        DiffSidebarManager.getInstance().refreshSidebars(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushFileOwnerCache() {
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.folderOwners.clear();
        }
        map = this.fileOwners;
        synchronized (map) {
            this.fileOwners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNullOwners() {
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.flushNullOwners(this.folderOwners);
        }
        map = this.fileOwners;
        synchronized (map) {
            this.flushNullOwners(this.fileOwners);
        }
    }

    private void flushNullOwners(Map<File, VersioningSystem> map) {
        Iterator<File> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!map.get(it.next()).equals(this.NULL_OWNER)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem[] getVersioningSystems() {
        List<VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
        }
    }

    VersioningSystem[] getOwners(VCSContext ctx) {
        Set<File> files = ctx.getRootFiles();
        HashSet<VersioningSystem> owners = new HashSet<VersioningSystem>();
        for (File file : files) {
            VersioningSystem vs = this.getOwner(file);
            if (vs == null) continue;
            owners.add(vs);
        }
        return owners.toArray(new VersioningSystem[owners.size()]);
    }

    public VersioningSystem getOwner(File file) {
        return this.getOwner(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersioningSystem getOwner(File file, Boolean isFile) {
        VersioningSystem[] vs;
        Map<File, VersioningSystem> map;
        LOG.log(Level.FINE, "looking for owner of {0}", file);
        VersioningSystem owner = null;
        Map<File, VersioningSystem> map2 = this.fileOwners;
        synchronized (map2) {
            owner = this.fileOwners.get(file);
        }
        if (owner == null) {
            map2 = this.folderOwners;
            synchronized (map2) {
                owner = this.folderOwners.get(file);
            }
        }
        if (owner != null) {
            if (owner == this.NULL_OWNER) {
                LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{file});
                return null;
            }
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), file});
            return owner instanceof DelegatingVCS ? ((DelegatingVCS)owner).getDelegate() : owner;
        }
        File folder = file;
        if (isFile == null) {
            isFile = file.isFile();
        }
        if (isFile.booleanValue()) {
            folder = file.getParentFile();
            if (folder == null) {
                LOG.log(Level.FINE, " null parent");
                return null;
            }
            map = this.folderOwners;
            synchronized (map) {
                owner = this.folderOwners.get(folder);
            }
        }
        if (owner == null && VersioningSupport.isExcluded(folder)) {
            LOG.log(Level.FINE, " caching NULL_OWNER of excluded {0}", new Object[]{file});
            if (isFile.booleanValue()) {
                map = this.fileOwners;
                synchronized (map) {
                    this.fileOwners.put(folder, this.NULL_OWNER);
                }
            }
            map = this.folderOwners;
            synchronized (map) {
                this.folderOwners.put(folder, this.NULL_OWNER);
            }
            return null;
        }
        if (owner != null) {
            map = this.fileOwners;
            synchronized (map) {
                LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, file});
                this.fileOwners.put(file, owner != null ? owner : this.NULL_OWNER);
            }
            if (owner == this.NULL_OWNER) {
                LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{folder});
                return null;
            }
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), folder});
            return owner instanceof DelegatingVCS ? ((DelegatingVCS)owner).getDelegate() : owner;
        }
        File closestParent = null;
        for (VersioningSystem system : vs = this.getVersioningSystems()) {
            if (system == this.localHistory) continue;
            File topmost = system.getTopmostManagedAncestor(folder);
            LOG.log(Level.FINE, " {0} returns {1} ", new Object[]{system.getClass().getName(), topmost});
            if (topmost == null || closestParent != null && !Utils.isAncestorOrEqual(closestParent, topmost)) continue;
            VersioningSystem versioningSystem = system = system instanceof DelegatingVCS ? ((DelegatingVCS)system).getDelegate() : system;
            if (VersioningConfig.getDefault().isDisconnected(system, topmost)) {
                LOG.log(Level.FINE, " skipping disconnected owner = {0} for {1}", new Object[]{system.getClass().getName(), topmost});
                continue;
            }
            LOG.log(Level.FINE, " owner = {0}", new Object[]{system.getClass().getName()});
            owner = system;
            closestParent = topmost;
        }
        Map<File, VersioningSystem> map3 = this.folderOwners;
        synchronized (map3) {
            if (owner != null) {
                LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, folder});
                this.folderOwners.put(folder, owner);
            } else {
                while (folder != null) {
                    LOG.log(Level.FINE, " caching unversioned folder {0}", new Object[]{folder});
                    this.folderOwners.put(folder, this.NULL_OWNER);
                    folder = folder.getParentFile();
                }
            }
        }
        map3 = this.fileOwners;
        synchronized (map3) {
            LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, file});
            this.fileOwners.put(file, owner != null ? owner : this.NULL_OWNER);
        }
        LOG.log(Level.FINE, "owner = {0}", new Object[]{owner != null ? owner.getClass().getName() : null});
        return owner instanceof DelegatingVCS ? ((DelegatingVCS)owner).getDelegate() : owner;
    }

    VersioningSystem getLocalHistory(File file) {
        return this.getLocalHistory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem getLocalHistory(File file, Boolean isFile) {
        boolean isManaged;
        Object isManagedByLocalHistory;
        VersioningSystem lh = this.localHistory;
        if (lh == null) {
            return null;
        }
        String nbUserdir = System.getProperty("netbeans.user", "");
        if (!nbUserdir.isEmpty() && !Utils.isVersionUserdir() && Utils.isAncestorOrEqual(new File(nbUserdir), file)) {
            return null;
        }
        Map<File, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            isManagedByLocalHistory = this.localHistoryFiles.get(file);
            if (isManagedByLocalHistory != null && ((Boolean)isManagedByLocalHistory).booleanValue()) {
                return lh;
            }
        }
        File folder = file;
        if (isFile == null) {
            isFile = file.isFile();
        }
        if (isFile.booleanValue() && (folder = file.getParentFile()) == null) {
            return null;
        }
        isManagedByLocalHistory = this.localHistoryFiles;
        synchronized (isManagedByLocalHistory) {
            Boolean isManagedByLocalHistory2 = this.localHistoryFiles.get(folder);
            if (isManagedByLocalHistory2 != null) {
                return isManagedByLocalHistory2 != false ? lh : null;
            }
        }
        boolean bl = isManaged = lh.getTopmostManagedAncestor(folder) != null;
        if (isManaged) {
            this.putLocalHistoryFile(Boolean.TRUE, folder);
            return lh;
        }
        isManaged = lh.getTopmostManagedAncestor(file) != null;
        this.putLocalHistoryFile(isManaged, file);
        return isManaged ? lh : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalHistoryFile(Boolean b, File ... files) {
        Map<File, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            if (this.localHistoryFiles.size() > 1500) {
                Iterator<File> it = this.localHistoryFiles.keySet().iterator();
                for (int i = 0; i < 150; ++i) {
                    it.next();
                    it.remove();
                }
            }
            for (File file : files) {
                this.localHistoryFiles.put(file, b);
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshVersioningSystems();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (EVENT_STATUS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
            this.refreshDiffSidebars(files);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
        } else if (EVENT_VERSIONED_ROOTS.equals(evt.getPropertyName())) {
            if (evt.getSource() instanceof VersioningSystem) {
                this.versionedRootsChanged((VersioningSystem)evt.getSource());
            } else {
                this.versionedRootsChanged(null);
            }
        }
    }

    public void versionedRootsChanged() {
        this.versionedRootsChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionedRootsChanged(VersioningSystem owner) {
        if (owner == this.localHistory) {
            Map<File, Boolean> map = this.localHistoryFiles;
            synchronized (map) {
                this.localHistoryFiles.clear();
            }
        } else {
            this.flushFileOwnerCache();
            this.refreshDiffSidebars(null);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        VersioningAnnotationProvider.instance.refreshAnnotations(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean needsLocalHistory(String methodName) {
        boolean ret;
        block8: {
            boolean bl;
            ret = false;
            try {
                List<VersioningSystem> list = this.versioningSystems;
                // MONITORENTER : list
                if (this.localHistory != null) break block8;
                bl = ret;
                // MONITOREXIT : list
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
                throw throwable;
            }
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
            return bl;
        }
        Set<String> s = this.interceptedMethods.get(this.localHistory.getClass().getName());
        if (s == null) {
            Method[] m;
            s = new HashSet<String>();
            for (Method method : m = this.localHistory.getVCSInterceptor().getClass().getDeclaredMethods()) {
                if ((method.getModifiers() & 1) == 0) continue;
                s.add(method.getName());
            }
            this.interceptedMethods.put(this.localHistory.getClass().getName(), s);
        }
        boolean bl = ret = s.contains(methodName);
        // MONITOREXIT : list
        LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
        return bl;
    }

    static {
        initialized = false;
        initializing = false;
        INIT_LOCK = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.versioning");
    }
}

